/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustedAuthorities
extends Extension.Value
implements Iterable<TrustedAuthority> {
    private final ByteBuffer buffer;

    public TrustedAuthorities(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int length() {
        return 2 + (this.buffer.getShort(0) & 0xFFFF);
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public int size() {
        int len = this.buffer.getShort(0) & 0xFFFF;
        int n = 0;
        int i = 2;
        while (i < len) {
            TrustedAuthority auth = new TrustedAuthority((ByteBuffer)this.buffer.duplicate().position(i));
            i += auth.length();
            ++n;
            ++i;
        }
        return n;
    }

    public TrustedAuthority get(int index) {
        int len = this.buffer.getShort(0) & 0xFFFF;
        int n = 0;
        int i = 2;
        while (i < len && n <= index) {
            TrustedAuthority auth = new TrustedAuthority((ByteBuffer)this.buffer.duplicate().position(i));
            if (n == index) {
                return auth;
            }
            i += auth.length();
            ++n;
        }
        throw new IndexOutOfBoundsException();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        String subprefix = "  ";
        if (prefix != null) {
            subprefix = String.valueOf(prefix) + subprefix;
        }
        for (TrustedAuthority ta : this) {
            out.println(ta);
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} TrustedAuthorities;");
        return str.toString();
    }

    @Override
    public Iterator<TrustedAuthority> iterator() {
        return new AuthoritiesIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AuthoritiesIterator
    implements Iterator<TrustedAuthority> {
        private int index = 0;

        @Override
        public TrustedAuthority next() throws NoSuchElementException {
            try {
                return TrustedAuthorities.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < TrustedAuthorities.this.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IdentifierType {
        PRE_AGREED(0),
        KEY_SHA1_HASH(1),
        X509_NAME(2),
        CERT_SHA1_HASH(3);

        private final int value;

        private IdentifierType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class TrustedAuthority
    implements Constructed {
        private final ByteBuffer buffer;

        public TrustedAuthority(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        public int length() {
            switch (this.type().getValue()) {
                case 0: {
                    return 1;
                }
                case 1: 
                case 3: {
                    return 21;
                }
                case 2: {
                    return 3 + (this.buffer.getShort(1) & 0xFFFF);
                }
            }
            throw new IllegalArgumentException("unknown authority type");
        }

        public byte[] sha1Hash() {
            IdentifierType t = this.type();
            if (t != IdentifierType.CERT_SHA1_HASH && t != IdentifierType.KEY_SHA1_HASH) {
                throw new IllegalArgumentException((Object)((Object)t) + " does not have a hash value");
            }
            byte[] b = new byte[20];
            ((ByteBuffer)this.buffer.duplicate().position(1)).get(b);
            return b;
        }

        public X500Principal name() {
            int len = this.buffer.getShort(1) & 0xFFFF;
            byte[] b = new byte[len];
            ((ByteBuffer)this.buffer.duplicate().position(3)).get(b);
            return new X500Principal(b);
        }

        public IdentifierType type() {
            switch (this.buffer.get(0)) {
                case 0: {
                    return IdentifierType.PRE_AGREED;
                }
                case 1: {
                    return IdentifierType.KEY_SHA1_HASH;
                }
                case 2: {
                    return IdentifierType.X509_NAME;
                }
                case 3: {
                    return IdentifierType.CERT_SHA1_HASH;
                }
            }
            throw new IllegalArgumentException("invalid IdentifierType");
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String prefix) {
            StringWriter str = new StringWriter();
            PrintWriter out = new PrintWriter(str);
            if (prefix != null) {
                out.print(prefix);
            }
            out.println("struct {");
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  identifier_type = ");
            out.print((Object)this.type());
            out.println(";");
            switch (this.type().getValue()) {
                case 0: {
                    break;
                }
                case 1: 
                case 3: {
                    if (prefix != null) {
                        out.print(prefix);
                    }
                    out.print("  sha1_hash = ");
                    out.print(Util.toHexString(this.sha1Hash(), ':'));
                    out.println(";");
                    break;
                }
                case 2: {
                    if (prefix != null) {
                        out.print(prefix);
                    }
                    out.print("  name = ");
                    out.print(this.name());
                    out.println(";");
                }
            }
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("} TrustedAuthority;");
            return str.toString();
        }
    }
}

