/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import gnu.java.util.DoubleEnumeration;
import gnu.java.util.EmptyEnumeration;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoader {
    final HashMap loadedClasses = new HashMap();
    final HashMap<String, WeakReference<Class>> loadingConstraints = new HashMap();
    final HashMap definedPackages = new HashMap();
    private final ClassLoader parent;
    private final boolean initialized;
    static final ClassLoader systemClassLoader = VMClassLoader.getSystemClassLoader();
    private final ConcurrentHashMap<AnnotationsKey, Object[]> declaredAnnotations = new ConcurrentHashMap();
    static final ProtectionDomain defaultProtectionDomain;
    boolean defaultAssertionStatus = VMClassLoader.defaultAssertionStatus();
    static final Map systemPackageAssertionStatus;
    Map packageAssertionStatus;
    static final Map systemClassAssertionStatus;
    Map classAssertionStatus;

    static {
        String secman = SystemProperties.getProperty("java.security.manager");
        if (secman != null && SecurityManager.current == null) {
            if (secman.equals("") || secman.equals("default")) {
                SecurityManager.current = new SecurityManager();
            } else {
                try {
                    Class<?> cl = Class.forName(secman, false, systemClassLoader);
                    SecurityManager.current = (SecurityManager)cl.newInstance();
                }
                catch (Exception x) {
                    throw (InternalError)new InternalError("Unable to create SecurityManager").initCause(x);
                }
            }
        }
        CodeSource cs = new CodeSource(null, null);
        PermissionCollection perm = Policy.getPolicy().getPermissions(cs);
        defaultProtectionDomain = new ProtectionDomain(cs, perm);
        systemPackageAssertionStatus = VMClassLoader.packageAssertionStatus();
        systemClassAssertionStatus = VMClassLoader.classAssertionStatus();
    }

    final Object[] getDeclaredAnnotations(Class declaringClass, int member_type, int member_index, int kind_req) {
        Object[] result = this.declaredAnnotations.get(new AnnotationsKey(declaringClass, member_type, member_index, kind_req));
        if (result != AnnotationsKey.NIL && result != null) {
            return (Object[])result.clone();
        }
        return null;
    }

    final Object[] putDeclaredAnnotations(Class declaringClass, int member_type, int member_index, int kind_req, Object[] annotations) {
        this.declaredAnnotations.put(new AnnotationsKey(declaringClass, member_type, member_index, kind_req), annotations == null ? AnnotationsKey.NIL : annotations);
        return annotations == null ? null : (Object[])annotations.clone();
    }

    protected ClassLoader() throws SecurityException {
        this(systemClassLoader);
    }

    protected ClassLoader(ClassLoader parent) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.parent = parent;
        this.initialized = true;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    private native Class loadClassFromSig(String var1) throws ClassNotFoundException;

    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c;
        int lastDot;
        SecurityManager sm = SecurityManager.current;
        if (sm != null && (lastDot = name.lastIndexOf(46)) != -1) {
            sm.checkPackageAccess(name.substring(0, lastDot));
        }
        if (name.length() > 0 && name.charAt(0) == '[') {
            c = this.loadClassFromSig(name);
        } else {
            c = this.findLoadedClass(name);
            if (c == null) {
                block9: {
                    try {
                        if (this.parent == null) {
                            c = VMClassLoader.loadClass(name, resolve);
                            if (c != null) {
                                return c;
                            }
                            break block9;
                        }
                        return this.parent.loadClass(name, resolve);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                c = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    protected final Class<?> defineClass(byte[] data, int offset, int len) throws ClassFormatError {
        return this.defineClass(null, data, offset, len);
    }

    protected final Class<?> defineClass(String name, byte[] data, int offset, int len) throws ClassFormatError {
        return this.defineClass(name, data, offset, len, null);
    }

    protected final synchronized Class<?> defineClass(String name, byte[] data, int offset, int len, ProtectionDomain domain) throws ClassFormatError {
        this.checkInitialized();
        if (domain == null) {
            domain = defaultProtectionDomain;
        }
        Class retval = VMClassLoader.defineClass(this, name, data, offset, len, domain);
        this.loadedClasses.put(retval.getName(), retval);
        return retval;
    }

    protected final Class<?> defineClass(String name, ByteBuffer buf, ProtectionDomain domain) throws ClassFormatError {
        byte[] data = new byte[buf.remaining()];
        buf.get(data);
        return this.defineClass(name, data, 0, data.length, domain);
    }

    protected final void resolveClass(Class<?> c) {
        this.checkInitialized();
        VMClassLoader.resolveClass(c);
    }

    protected final Class<?> findSystemClass(String name) throws ClassNotFoundException {
        this.checkInitialized();
        return Class.forName(name, false, systemClassLoader);
    }

    public final ClassLoader getParent() {
        ClassLoader cl;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (cl = VMStackWalker.getCallingClassLoader()) != null && !cl.isAncestorOf(this)) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return this.parent;
    }

    protected final void setSigners(Class<?> c, Object[] signers) {
        this.checkInitialized();
        c.setSigners(signers);
    }

    protected final synchronized Class<?> findLoadedClass(String name) {
        this.checkInitialized();
        return (Class)this.loadedClasses.get(name);
    }

    public URL getResource(String name) {
        URL result = this.parent == null ? VMClassLoader.getResource(name) : this.parent.getResource(name);
        if (result == null) {
            result = this.findResource(name);
        }
        return result;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentResources = this.parent == null ? VMClassLoader.getResources(name) : this.parent.getResources(name);
        return new DoubleEnumeration<URL>(parentResources, this.findResources(name));
    }

    protected Enumeration<URL> findResources(String name) throws IOException {
        return new EmptyEnumeration<URL>();
    }

    protected URL findResource(String name) {
        return null;
    }

    public static final URL getSystemResource(String name) {
        return systemClassLoader.getResource(name);
    }

    public static Enumeration<URL> getSystemResources(String name) throws IOException {
        return systemClassLoader.getResources(name);
    }

    public InputStream getResourceAsStream(String name) {
        URL url;
        block3: {
            try {
                url = this.getResource(name);
                if (url != null) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return url.openStream();
    }

    public static final InputStream getSystemResourceAsStream(String name) {
        URL url;
        block3: {
            try {
                url = ClassLoader.getSystemResource(name);
                if (url != null) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return url.openStream();
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader cl;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (cl = VMStackWalker.getCallingClassLoader()) != null && cl != systemClassLoader) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return systemClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String name, String specTitle, String specVendor, String specVersion, String implTitle, String implVendor, String implVersion, URL sealed) {
        if (this.getPackage(name) != null) {
            throw new IllegalArgumentException("Package " + name + " already defined");
        }
        Package p = new Package(name, specTitle, specVendor, specVersion, implTitle, implVendor, implVersion, sealed, this);
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            this.definedPackages.put(name, p);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String name) {
        Package p = this.parent == null ? VMClassLoader.getPackage(name) : this.parent.getPackage(name);
        if (p == null) {
            HashMap hashMap = this.definedPackages;
            synchronized (hashMap) {
                p = (Package)this.definedPackages.get(name);
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Package[] packages;
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            packages = new Package[this.definedPackages.size()];
            this.definedPackages.values().toArray(packages);
        }
        Package[] parentPackages = this.parent == null ? VMClassLoader.getPackages() : this.parent.getPackages();
        Package[] allPackages = new Package[parentPackages.length + packages.length];
        System.arraycopy(parentPackages, 0, allPackages, 0, parentPackages.length);
        System.arraycopy(packages, 0, allPackages, parentPackages.length, packages.length);
        return allPackages;
    }

    protected String findLibrary(String name) {
        return null;
    }

    public void setDefaultAssertionStatus(boolean enabled) {
        this.defaultAssertionStatus = enabled;
    }

    public synchronized void setPackageAssertionStatus(String name, boolean enabled) {
        if (this.packageAssertionStatus == null) {
            this.packageAssertionStatus = new HashMap(systemPackageAssertionStatus);
        }
        this.packageAssertionStatus.put(name, enabled);
    }

    public synchronized void setClassAssertionStatus(String name, boolean enabled) {
        if (this.classAssertionStatus == null) {
            this.classAssertionStatus = new HashMap(systemClassAssertionStatus);
        }
        this.classAssertionStatus.put(name.toString(), enabled);
    }

    public synchronized void clearAssertionStatus() {
        this.defaultAssertionStatus = false;
        this.packageAssertionStatus = new HashMap();
        this.classAssertionStatus = new HashMap();
    }

    final boolean isAncestorOf(ClassLoader loader) {
        while (loader != null) {
            if (this == loader) {
                return true;
            }
            loader = loader.parent;
        }
        return false;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new SecurityException("attempt to use uninitialized class loader");
        }
    }

    static final class AnnotationsKey {
        final int member_type;
        final int member_index;
        final int kind_req;
        final Class declaringClass;
        final int hashCode;
        public static final Annotation[] NIL = new Annotation[0];

        public AnnotationsKey(Class declaringClass, int member_type, int member_index, int kind_req) {
            this.member_type = member_type;
            this.member_index = member_index;
            this.kind_req = kind_req;
            this.declaringClass = declaringClass;
            this.hashCode = member_type ^ member_index ^ kind_req ^ declaringClass.hashCode();
        }

        public boolean equals(Object obj) {
            AnnotationsKey other = (AnnotationsKey)obj;
            return this.member_type == other.member_type && this.member_index == other.member_index && this.kind_req == other.kind_req && this.declaringClass == other.declaringClass;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

