/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.interaction;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.drawing.ConnectionDraw;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.structure.WidgetCompanion;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

public class ConstraintHandle {
    private final WidgetInteractionTargets mOwner;
    private final ConstraintAnchor.Type mType;
    private ConstraintAnchor mAnchor;
    private int mX;
    private int mY;
    static final Color sShadowColor = new Color(0, 0, 0, 50);
    static final Stroke sShadowStroke = new BasicStroke(3.0f);

    public ConstraintHandle(WidgetInteractionTargets owner, ConstraintAnchor.Type type) {
        this.mOwner = owner;
        this.mType = type;
    }

    public ConstraintWidget getOwner() {
        return this.mOwner.getConstraintWidget();
    }

    public ConstraintAnchor getAnchor() {
        return this.mAnchor;
    }

    public void updateAnchor() {
        ConstraintWidget widget;
        this.mAnchor = this.mOwner != null ? ((widget = this.mOwner.getConstraintWidget()) instanceof Guideline ? ((Guideline)widget).getAnchor() : widget.getAnchor(this.mType)) : null;
    }

    public int getDrawX() {
        return this.mX;
    }

    public int getDrawY() {
        return this.mY;
    }

    void updatePosition() {
        if (this.mOwner == null) {
            this.mX = 0;
            this.mY = 0;
            return;
        }
        ConstraintWidget widget = this.mOwner.getConstraintWidget();
        int x = widget.getDrawX();
        int y = widget.getDrawY();
        int w = widget.getDrawWidth();
        int h = widget.getDrawHeight();
        if (this.mAnchor == null) {
            return;
        }
        switch (this.mAnchor.getType()) {
            case LEFT: {
                this.mX = x;
                this.mY = y + h / 2;
                break;
            }
            case TOP: {
                this.mX = x + w / 2;
                this.mY = y;
                break;
            }
            case RIGHT: {
                this.mX = x + w;
                this.mY = y + h / 2;
                break;
            }
            case BOTTOM: {
                this.mX = x + w / 2;
                this.mY = y + h;
                break;
            }
            case CENTER: 
            case CENTER_X: 
            case CENTER_Y: {
                this.mX = x + w / 2;
                this.mY = y + h / 2;
                break;
            }
            case BASELINE: {
                this.mX = x + w / 2;
                this.mY = y + widget.getBaselineDistance();
                break;
            }
        }
    }

    public int getBaselineHandleWidth(ViewTransform transform) {
        int padding;
        if (this.mType != ConstraintAnchor.Type.BASELINE) {
            return 0;
        }
        int w = transform.getSwingDimension(this.getOwner().getDrawWidth());
        if (w - 2 * (padding = (int)((double)w * 0.4 / 2.0)) < 16) {
            padding = (w - 16) / 2;
        }
        return w - 2 * padding;
    }

    public void draw(ViewTransform transform, Graphics2D g, ColorSet colorSet, boolean isSelected) {
        ConstraintWidget widget = this.getOwner();
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        WidgetDecorator decorator = companion.getWidgetDecorator(colorSet.getStyle());
        Color backgroundColor = decorator.getBackgroundColor();
        if (this.mType == ConstraintAnchor.Type.BASELINE) {
            int x = transform.getSwingX(this.getOwner().getDrawX());
            int y = transform.getSwingY(this.getOwner().getDrawY());
            int w = transform.getSwingDimension(this.getOwner().getDrawWidth());
            int baseline = transform.getSwingDimension(this.getOwner().getBaselineDistance());
            int padding = (w - this.getBaselineHandleWidth(transform)) / 2;
            int bh = 7;
            int by = y + baseline;
            if (isSelected) {
                Color pre = g.getColor();
                Stroke preStroke = g.getStroke();
                g.setColor(colorSet.getShadow());
                g.setStroke(colorSet.getShadowStroke());
                g.drawRoundRect(x + padding, by - bh / 2, w - 2 * padding, bh, bh, bh);
                g.setStroke(preStroke);
                g.setColor(pre);
            }
            Color previous = g.getColor();
            g.setColor(new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), previous.getAlpha()));
            g.fillRoundRect(x + padding, by - bh / 2, w - 2 * padding, bh, bh, bh);
            g.setColor(previous);
            g.drawRoundRect(x + padding, by - bh / 2, w - 2 * padding, bh, bh, bh);
            g.drawLine(x, by, x + padding, by);
            g.drawLine(x + w - padding, by, x + w, by);
            if (this.mAnchor.isConnected()) {
                int margin = 2;
                g.fillRoundRect(x + padding + margin, by - bh / 2 + margin, w - 2 * padding - 2 * margin, bh - 2 * margin, bh, bh);
                g.drawRoundRect(x + padding + margin, by - bh / 2 + margin, w - 2 * padding - 2 * margin, bh - 2 * margin, bh, bh);
            }
        } else {
            int innerMargin = 3;
            int radius = ConnectionDraw.CONNECTION_ANCHOR_SIZE;
            int dimension = radius * 2;
            int cx = transform.getSwingFX(this.mX) - dimension / 2;
            int cy = transform.getSwingFY(this.mY) - dimension / 2;
            Ellipse2D.Float outerCircle = new Ellipse2D.Float(cx, cy, dimension, dimension);
            if (isSelected) {
                Color pre = g.getColor();
                Stroke preStroke = g.getStroke();
                g.setColor(sShadowColor);
                g.setStroke(sShadowStroke);
                g.draw(outerCircle);
                g.setStroke(preStroke);
                g.setColor(pre);
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(backgroundColor);
            g2.fill(outerCircle);
            g2.dispose();
            g.draw(outerCircle);
            if (this.mAnchor.isConnected()) {
                int d = dimension - innerMargin * 2;
                g.fillRoundRect(cx + innerMargin, cy + innerMargin, d, d, d, d);
                g.drawRoundRect(cx + innerMargin, cy + innerMargin, d, d, d, d);
            }
        }
    }

    public String toString() {
        return this.mAnchor.toString();
    }
}

