/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.ClassFinder;
import com.intellij.GroupBasedTestClassFilter;
import com.intellij.PatternListTestClassFilter;
import com.intellij.TestClassesFilter;
import com.intellij.idea.Bombed;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.RunFirst;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCaseLoader {
    public static final String PERFORMANCE_TESTS_ONLY_FLAG = "idea.performance.tests";
    public static final String INCLUDE_PERFORMANCE_TESTS_FLAG = "idea.include.performance.tests";
    public static final String INCLUDE_UNCONVENTIONALLY_NAMED_TESTS_FLAG = "idea.include.unconventionally.named.tests";
    public static final String RUN_ONLY_AFFECTED_TEST_FLAG = "idea.run.only.affected.tests";
    private static final boolean PERFORMANCE_TESTS_ONLY = "true".equals(System.getProperty("idea.performance.tests"));
    private static final boolean INCLUDE_PERFORMANCE_TESTS = "true".equals(System.getProperty("idea.include.performance.tests"));
    private static final boolean INCLUDE_UNCONVENTIONALLY_NAMED_TESTS = "true".equals(System.getProperty("idea.include.unconventionally.named.tests"));
    private static final boolean RUN_ONLY_AFFECTED_TESTS = "true".equals(System.getProperty("idea.run.only.affected.tests"));
    private static final String ALL_TESTS_GROUP = "ALL";
    private static final String PLATFORM_LITE_FIXTURE_NAME = "com.intellij.testFramework.PlatformLiteFixture";
    private final List<Class> myClassList = new ArrayList<Class>();
    private final List<Throwable> myClassLoadingErrors = new ArrayList<Throwable>();
    private Class myFirstTestClass;
    private Class myLastTestClass;
    private final TestClassesFilter myTestClassesFilter;
    private final boolean myForceLoadPerformanceTests;
    private static final List<String> ourRankList = TestCaseLoader.getTeamCityRankList();

    public TestCaseLoader(String classFilterName) {
        this(classFilterName, false);
    }

    public TestCaseLoader(String classFilterName, boolean forceLoadPerformanceTests) {
        this.myForceLoadPerformanceTests = forceLoadPerformanceTests;
        TestClassesFilter testClassesFilter = this.calcTestClassFilter(classFilterName);
        TestClassesFilter affectedTestsFilter = TestCaseLoader.affectedTestsFilter();
        this.myTestClassesFilter = new TestClassesFilter.And(testClassesFilter, affectedTestsFilter);
        System.out.println(this.myTestClassesFilter.toString());
    }

    private TestClassesFilter calcTestClassFilter(String classFilterName) {
        String patterns = TestCaseLoader.getTestPatterns();
        if (!StringUtil.isEmpty((String)patterns)) {
            System.out.println("Using patterns: [" + patterns + "]");
            return new PatternListTestClassFilter(StringUtil.split((String)patterns, (String)";"));
        }
        List<URL> groupingFileUrls = Collections.emptyList();
        if (!StringUtil.isEmpty((String)classFilterName)) {
            try {
                groupingFileUrls = Collections.list(this.getClassLoader().getResources(classFilterName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List<String> testGroupNames = TestCaseLoader.getTestGroups();
        MultiMap groups = MultiMap.createLinked();
        for (URL fileUrl : groupingFileUrls) {
            try {
                InputStreamReader reader = new InputStreamReader(fileUrl.openStream());
                Throwable throwable = null;
                try {
                    groups.putAllValues(GroupBasedTestClassFilter.readGroups(reader));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Failed to load test groups from " + fileUrl);
            }
        }
        if (groups.isEmpty() || testGroupNames.contains(ALL_TESTS_GROUP)) {
            System.out.println("Using all classes");
            return TestClassesFilter.ALL_CLASSES;
        }
        System.out.println("Using test groups: " + testGroupNames);
        return new GroupBasedTestClassFilter((MultiMap<String, String>)groups, testGroupNames);
    }

    @Nullable
    private static String getTestPatterns() {
        return System.getProperty("intellij.build.test.patterns", System.getProperty("idea.test.patterns"));
    }

    @NotNull
    private static TestClassesFilter affectedTestsFilter() {
        if (RUN_ONLY_AFFECTED_TESTS) {
            System.out.println("Trying to load affected tests.");
            File affectedTestClasses = new File(System.getProperty("idea.home.path"), "discoveredTestClasses.txt");
            if (affectedTestClasses.exists()) {
                PatternListTestClassFilter patternListTestClassFilter;
                block5: {
                    System.out.println("Loading file with affected classes " + affectedTestClasses.getAbsolutePath());
                    try {
                        patternListTestClassFilter = new PatternListTestClassFilter(FileUtil.loadLines((File)affectedTestClasses));
                        if (patternListTestClassFilter != null) break block5;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    TestCaseLoader.$$$reportNull$$$0(0);
                }
                return patternListTestClassFilter;
            }
        }
        System.out.println("No affected tests were found, will run with the standard test filter.");
        TestClassesFilter testClassesFilter = TestClassesFilter.ALL_CLASSES;
        if (testClassesFilter == null) {
            TestCaseLoader.$$$reportNull$$$0(1);
        }
        return testClassesFilter;
    }

    @NotNull
    private static List<String> getTestGroups() {
        List list = StringUtil.split((String)System.getProperty("intellij.build.test.groups", System.getProperty("idea.test.group", "")).trim(), (String)";");
        if (list == null) {
            TestCaseLoader.$$$reportNull$$$0(2);
        }
        return list;
    }

    void addClassIfTestCase(Class testCaseClass, String moduleName) {
        if (this.shouldAddTestCase(testCaseClass, moduleName, true) && testCaseClass != this.myFirstTestClass && testCaseClass != this.myLastTestClass && TestFrameworkUtil.canRunTest(testCaseClass)) {
            this.myClassList.add(testCaseClass);
        }
    }

    void addFirstTest(Class aClass) {
        assert (this.myFirstTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, null, false)) : "not a test: " + aClass;
        this.myFirstTestClass = aClass;
    }

    void addLastTest(Class aClass) {
        assert (this.myLastTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, null, false)) : "not a test: " + aClass;
        this.myLastTestClass = aClass;
    }

    private boolean shouldAddTestCase(Class<?> testCaseClass, String moduleName, boolean testForExcluded) {
        if ((testCaseClass.getModifiers() & 0x400) != 0) {
            return false;
        }
        if (testForExcluded && this.shouldExcludeTestClass(moduleName, testCaseClass)) {
            return false;
        }
        if (TestCase.class.isAssignableFrom(testCaseClass) || TestSuite.class.isAssignableFrom(testCaseClass)) {
            return true;
        }
        try {
            Method suiteMethod = testCaseClass.getMethod("suite", new Class[0]);
            if (Test.class.isAssignableFrom(suiteMethod.getReturnType()) && (suiteMethod.getModifiers() & 8) != 0) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return TestFrameworkUtil.isJUnit4TestClass(testCaseClass);
    }

    private boolean shouldExcludeTestClass(String moduleName, Class testCaseClass) {
        if (!this.myForceLoadPerformanceTests && !TestCaseLoader.shouldIncludePerformanceTestCase(testCaseClass)) {
            return true;
        }
        String className = testCaseClass.getName();
        return !this.myTestClassesFilter.matches(className, moduleName) || TestCaseLoader.isBombed(testCaseClass);
    }

    public static boolean isBombed(AnnotatedElement element) {
        Bombed bombedAnnotation = element.getAnnotation(Bombed.class);
        if (bombedAnnotation == null) {
            return false;
        }
        return !TestFrameworkUtil.bombExplodes(bombedAnnotation);
    }

    public void loadTestCases(String moduleName, Collection<String> classNamesIterator) {
        for (String className : classNamesIterator) {
            try {
                Class<?> candidateClass = Class.forName(className, false, this.getClassLoader());
                this.addClassIfTestCase(candidateClass, moduleName);
            }
            catch (Throwable e) {
                String message = "Cannot load class " + className + ": " + e.getMessage();
                System.err.println(message);
                this.myClassLoadingErrors.add(new Throwable(message, e));
            }
        }
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public List<Throwable> getClassLoadingErrors() {
        return this.myClassLoadingErrors;
    }

    private static List<String> getTeamCityRankList() {
        if (TestCaseLoader.isPerformanceTestsRun()) {
            return Collections.emptyList();
        }
        String filePath = System.getProperty("teamcity.tests.recentlyFailedTests.file", null);
        if (filePath != null) {
            try {
                return FileUtil.loadLines((String)filePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private static int getRank(Class aClass) {
        if (TestCaseLoader.runFirst(aClass)) {
            return 0;
        }
        if (TestCaseLoader.isPerformanceTestsRun()) {
            return 1;
        }
        if (TestCaseLoader.isPlatformLiteFixture(aClass)) {
            return ourRankList.size() + 1;
        }
        int i = ourRankList.indexOf(aClass.getName());
        if (i != -1) {
            return i;
        }
        return ourRankList.size();
    }

    private static boolean runFirst(Class testClass) {
        return TestCaseLoader.getAnnotationInHierarchy(testClass, RunFirst.class) != null;
    }

    private static boolean isPlatformLiteFixture(Class aClass) {
        while (aClass != null) {
            if (PLATFORM_LITE_FIXTURE_NAME.equals(aClass.getName())) {
                return true;
            }
            aClass = aClass.getSuperclass();
        }
        return false;
    }

    public List<Class> getClasses() {
        ArrayList<Class> result = new ArrayList<Class>(this.myClassList.size());
        result.addAll(this.myClassList);
        Collections.sort(result, Comparator.comparingInt(TestCaseLoader::getRank));
        if (this.myFirstTestClass != null) {
            result.add(0, this.myFirstTestClass);
        }
        if (this.myLastTestClass != null) {
            result.add(this.myLastTestClass);
        }
        return result;
    }

    private void clearClasses() {
        this.myClassList.clear();
        this.myFirstTestClass = null;
        this.myLastTestClass = null;
    }

    static boolean isPerformanceTestsRun() {
        return PERFORMANCE_TESTS_ONLY;
    }

    static boolean isIncludingPerformanceTestsRun() {
        return INCLUDE_PERFORMANCE_TESTS;
    }

    static boolean shouldIncludePerformanceTestCase(Class aClass) {
        return TestCaseLoader.isIncludingPerformanceTestsRun() || TestCaseLoader.isPerformanceTestsRun() || !TestCaseLoader.isPerformanceTest(null, aClass);
    }

    static boolean isPerformanceTest(String methodName, Class aClass) {
        return TestFrameworkUtil.isPerformanceTest(methodName, aClass.getSimpleName());
    }

    public void fillTestCases(String rootPackage, List<File> classesRoots) {
        long before = System.currentTimeMillis();
        for (File classesRoot : classesRoots) {
            int oldCount = this.getClasses().size();
            ClassFinder classFinder = new ClassFinder(classesRoot, rootPackage, INCLUDE_UNCONVENTIONALLY_NAMED_TESTS);
            this.loadTestCases(classesRoot.getName(), classFinder.getClasses());
            int newCount = this.getClasses().size();
            if (newCount == oldCount) continue;
            System.out.println("Loaded " + (newCount - oldCount) + " tests from class root " + classesRoot);
        }
        if (this.myClassList.isEmpty()) {
            this.clearClasses();
        }
        long after = System.currentTimeMillis();
        String message = "Number of test classes found: " + this.getClasses().size() + " time to load: " + (after - before) / 1000L + "s.";
        System.out.println(message);
        TeamCityLogger.info(message);
    }

    @Nullable
    public static <T extends Annotation> T getAnnotationInHierarchy(@NotNull Class<?> clazz, @NotNull Class<T> annotationClass) {
        if (clazz == null) {
            TestCaseLoader.$$$reportNull$$$0(3);
        }
        if (annotationClass == null) {
            TestCaseLoader.$$$reportNull$$$0(4);
        }
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            T annotation = current.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/TestCaseLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "affectedTestsFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestGroups";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/TestCaseLoader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationInHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

