/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;

public abstract class BuildProperties
extends CompositeGenerator {
    @NonNls
    public static final String TARGET_ALL = "all";
    @NonNls
    public static final String TARGET_BUILD_MODULES = "build.modules";
    @NonNls
    public static final String TARGET_CLEAN = "clean";
    @NonNls
    public static final String TARGET_INIT = "init";
    @NonNls
    public static final String TARGET_REGISTER_CUSTOM_COMPILERS = "register.custom.compilers";
    @NonNls
    public static final String DEFAULT_TARGET = "all";
    @NonNls
    public static final String PROPERTY_COMPILER_NAME = "compiler.name";
    @NonNls
    public static final String PROPERTY_COMPILER_ADDITIONAL_ARGS = "compiler.args";
    @NonNls
    public static final String PROPERTY_COMPILER_MAX_MEMORY = "compiler.max.memory";
    @NonNls
    public static final String PROPERTY_COMPILER_EXCLUDES = "compiler.excluded";
    @NonNls
    public static final String PROPERTY_COMPILER_RESOURCE_PATTERNS = "compiler.resources";
    @NonNls
    public static final String PROPERTY_IGNORED_FILES = "ignored.files";
    @NonNls
    public static final String PROPERTY_COMPILER_GENERATE_DEBUG_INFO = "compiler.debug";
    @NonNls
    public static final String PROPERTY_COMPILER_GENERATE_NO_WARNINGS = "compiler.generate.no.warnings";
    @NonNls
    public static final String PROPERTY_PROJECT_JDK_HOME = "project.jdk.home";
    @NonNls
    public static final String PROPERTY_PROJECT_JDK_BIN = "project.jdk.bin";
    @NonNls
    public static final String PROPERTY_PROJECT_JDK_CLASSPATH = "project.jdk.classpath";
    @NonNls
    public static final String PROPERTY_SKIP_TESTS = "skip.tests";
    @NonNls
    public static final String PROPERTY_LIBRARIES_PATTERNS = "library.patterns";
    @NonNls
    public static final String PROPERTY_IDEA_HOME = "idea.home";
    @NonNls
    public static final String PROPERTY_JAVAC2_HOME = "javac2.home";
    @NonNls
    public static final String PROPERTY_JAVAC2_CLASSPATH_ID = "javac2.classpath";
    @NonNls
    public static final String PROPERTY_INCLUDE_JAVA_RUNTIME_FOR_INSTRUMENTATION = "javac2.instrumentation.includeJavaRuntime";

    protected abstract void createJdkGenerators(Project var1);

    public static Sdk[] getUsedJdks(Project project) {
        Module[] modules;
        HashSet<Sdk> jdks = new HashSet<Sdk>();
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (jdk == null) continue;
            jdks.add(jdk);
        }
        return jdks.toArray(new Sdk[0]);
    }

    @NonNls
    public static String getJdkPathId(@NonNls String jdkName) {
        return "jdk.classpath." + BuildProperties.convertName(jdkName);
    }

    @NonNls
    public static String getModuleChunkJdkClasspathProperty(@NonNls String moduleChunkName) {
        return "module.jdk.classpath." + BuildProperties.convertName(moduleChunkName);
    }

    @NonNls
    public static String getModuleChunkJdkHomeProperty(@NonNls String moduleChunkName) {
        return "module.jdk.home." + BuildProperties.convertName(moduleChunkName);
    }

    @NonNls
    public static String getModuleChunkJdkBinProperty(@NonNls String moduleChunkName) {
        return "module.jdk.bin." + BuildProperties.convertName(moduleChunkName);
    }

    @NonNls
    public static String getModuleChunkCompilerArgsProperty(@NonNls String moduleName) {
        return "compiler.args." + BuildProperties.convertName(moduleName);
    }

    @NonNls
    public static String getLibraryPathId(@NonNls String libraryName) {
        return "library." + BuildProperties.convertName(libraryName) + ".classpath";
    }

    @NonNls
    public static String getJdkHomeProperty(@NonNls String jdkName) {
        return "jdk.home." + BuildProperties.convertName(jdkName);
    }

    @NonNls
    public static String getJdkBinProperty(@NonNls String jdkName) {
        return "jdk.bin." + BuildProperties.convertName(jdkName);
    }

    @NonNls
    public static String getCompileTargetName(@NonNls String moduleName) {
        return "compile.module." + BuildProperties.convertName(moduleName);
    }

    @NonNls
    public static String getOutputPathProperty(@NonNls String moduleName) {
        return BuildProperties.convertName(moduleName) + ".output.dir";
    }

    @NonNls
    public static String getOutputPathForTestsProperty(@NonNls String moduleName) {
        return BuildProperties.convertName(moduleName) + ".testoutput.dir";
    }

    @NonNls
    public static String getClasspathProperty(@NonNls String moduleName) {
        return BuildProperties.convertName(moduleName) + ".module.production.classpath";
    }

    @NonNls
    public static String getTestClasspathProperty(@NonNls String moduleName) {
        return BuildProperties.convertName(moduleName) + ".module.classpath";
    }

    @NonNls
    public static String getRuntimeClasspathProperty(@NonNls String moduleName) {
        return BuildProperties.convertName(moduleName) + ".runtime.production.module.classpath";
    }

    @NonNls
    public static String getTestRuntimeClasspathProperty(@NonNls String moduleName) {
        return BuildProperties.convertName(moduleName) + ".runtime.module.classpath";
    }

    @NonNls
    public static String getBootClasspathProperty(@NonNls String moduleName) {
        return BuildProperties.convertName(moduleName) + ".module.bootclasspath";
    }

    @NonNls
    public static String getSourcepathProperty(@NonNls String moduleName) {
        return BuildProperties.convertName(moduleName) + ".module.sourcepath";
    }

    @NonNls
    public static String getTestSourcepathProperty(@NonNls String moduleName) {
        return BuildProperties.convertName(moduleName) + ".module.test.sourcepath";
    }

    @NonNls
    public static String getExcludedFromModuleProperty(@NonNls String moduleName) {
        return "excluded.from.module." + BuildProperties.convertName(moduleName);
    }

    @NonNls
    public static String getExcludedFromCompilationProperty(@NonNls String moduleName) {
        return "excluded.from.compilation." + BuildProperties.convertName(moduleName);
    }

    @NonNls
    public static String getProjectBuildFileName(Project project) {
        return BuildProperties.convertName(project.getName());
    }

    @NonNls
    public static String getModuleChunkBuildFileName(ModuleChunk chunk) {
        return "module_" + BuildProperties.convertName(chunk.getName());
    }

    @NonNls
    public static String getModuleCleanTargetName(@NonNls String moduleName) {
        return "clean.module." + BuildProperties.convertName(moduleName);
    }

    @NonNls
    public static String getModuleChunkBasedirProperty(ModuleChunk chunk) {
        return "module." + BuildProperties.convertName(chunk.getName()) + ".basedir";
    }

    @NonNls
    public static String getModuleBasedirProperty(Module module) {
        return "module." + BuildProperties.convertName(module.getName()) + ".basedir";
    }

    @NonNls
    public static String getProjectBaseDirProperty() {
        return "basedir";
    }

    public static File getModuleChunkBaseDir(ModuleChunk chunk) {
        return chunk.getBaseDir();
    }

    public static File getProjectBaseDir(Project project) {
        VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        return VfsUtil.virtualToIoFile((VirtualFile)baseDir);
    }

    @NonNls
    public static String convertName(@NonNls String name) {
        return name.replaceAll("\"", "").replaceAll("\\s+", "_").toLowerCase();
    }

    @NonNls
    public static String getPathMacroProperty(@NonNls String pathMacro) {
        return "path.variable." + BuildProperties.convertName(pathMacro);
    }

    @NonNls
    public static String propertyRef(@NonNls String propertyName) {
        return "${" + propertyName + "}";
    }

    @NonNls
    public static String propertyRelativePath(@NonNls String propertyName, @NonNls String relativePath) {
        return "${" + propertyName + "}/" + relativePath;
    }

    public static File toCanonicalFile(File file) {
        File canonicalFile;
        try {
            canonicalFile = file.getCanonicalFile();
        }
        catch (IOException e) {
            canonicalFile = file;
        }
        return canonicalFile;
    }

    @NonNls
    public static String getTempDirForModuleProperty(@NonNls String moduleName) {
        return "tmp.dir." + BuildProperties.convertName(moduleName);
    }
}

