/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.gradle.internal.impldep.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.PublicKeyPacket;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.util.encoders.Hex;

public class RFC6637Utils {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode("416E6F6E796D6F75732053656E64657220202020");

    private RFC6637Utils() {
    }

    public static String getAgreementAlgorithm(PublicKeyPacket publicKeyPacket) {
        ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
        switch (eCDHPublicBCPGKey.getHashAlgorithm()) {
            case 8: {
                return "ECCDHwithSHA256CKDF";
            }
            case 9: {
                return "ECCDHwithSHA384CKDF";
            }
            case 10: {
                return "ECCDHwithSHA512CKDF";
            }
        }
        throw new IllegalArgumentException("Unknown hash algorithm specified: " + eCDHPublicBCPGKey.getHashAlgorithm());
    }

    public static ASN1ObjectIdentifier getKeyEncryptionOID(int n) throws PGPException {
        switch (n) {
            case 7: {
                return NISTObjectIdentifiers.id_aes128_wrap;
            }
            case 8: {
                return NISTObjectIdentifiers.id_aes192_wrap;
            }
            case 9: {
                return NISTObjectIdentifiers.id_aes256_wrap;
            }
        }
        throw new PGPException("unknown symmetric algorithm ID: " + n);
    }

    public static byte[] createUserKeyingMaterial(PublicKeyPacket publicKeyPacket, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
        byte[] byArray = eCDHPublicBCPGKey.getCurveOID().getEncoded();
        byteArrayOutputStream.write(byArray, 1, byArray.length - 1);
        byteArrayOutputStream.write(publicKeyPacket.getAlgorithm());
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(eCDHPublicBCPGKey.getHashAlgorithm());
        byteArrayOutputStream.write(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
        byteArrayOutputStream.write(ANONYMOUS_SENDER);
        byteArrayOutputStream.write(keyFingerPrintCalculator.calculateFingerprint(publicKeyPacket));
        return byteArrayOutputStream.toByteArray();
    }
}

