/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.component.factory.java;

import java.lang.reflect.Modifier;
import org.gradle.internal.impldep.org.codehaus.plexus.PlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.gradle.internal.impldep.org.codehaus.plexus.component.factory.AbstractComponentFactory;
import org.gradle.internal.impldep.org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.ComponentDescriptor;

public class JavaComponentFactory
extends AbstractComponentFactory {
    public String getId() {
        return "java";
    }

    public Object newInstance(ComponentDescriptor componentDescriptor, ClassRealm classRealm, PlexusContainer container) throws ComponentInstantiationException {
        Class implementationClass = null;
        try {
            String implementation = componentDescriptor.getImplementation();
            implementationClass = classRealm.loadClass(implementation);
            int modifiers = implementationClass.getModifiers();
            if (Modifier.isInterface(modifiers)) {
                throw new ComponentInstantiationException("Cannot instantiate implementation '" + implementation + "' because the class is a interface.");
            }
            if (Modifier.isAbstract(modifiers)) {
                throw new ComponentInstantiationException("Cannot instantiate implementation '" + implementation + "' because the class is abstract.");
            }
            Object instance = implementationClass.newInstance();
            return instance;
        }
        catch (InstantiationException e) {
            throw this.makeException(classRealm, componentDescriptor, implementationClass, e);
        }
        catch (ClassNotFoundException e) {
            throw this.makeException(classRealm, componentDescriptor, implementationClass, e);
        }
        catch (IllegalAccessException e) {
            throw this.makeException(classRealm, componentDescriptor, implementationClass, e);
        }
        catch (LinkageError e) {
            throw this.makeException(classRealm, componentDescriptor, implementationClass, e);
        }
    }

    private ComponentInstantiationException makeException(ClassRealm componentClassRealm, ComponentDescriptor componentDescriptor, Class implementationClass, Throwable e) {
        String msg = componentClassRealm == null ? "classRealm is null for " + componentDescriptor : "Could not instantiate component: " + componentDescriptor.getHumanReadableKey() + " realm: " + componentClassRealm.getId();
        return new ComponentInstantiationException(msg, e);
    }
}

