/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.eclipse.jgit.api.GitCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.ConfigInvalidException;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.submodule.SubmoduleStatus;
import org.gradle.internal.impldep.org.eclipse.jgit.submodule.SubmoduleStatusType;
import org.gradle.internal.impldep.org.eclipse.jgit.submodule.SubmoduleWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleStatusCommand
extends GitCommand<Map<String, SubmoduleStatus>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleStatusCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleStatusCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    @Override
    public Map<String, SubmoduleStatus> call() throws GitAPIException {
        this.checkCallable();
        try {
            SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            HashMap<String, SubmoduleStatus> statuses = new HashMap<String, SubmoduleStatus>();
            while (generator.next()) {
                SubmoduleStatus status = this.getStatus(generator);
                statuses.put(status.getPath(), status);
            }
            return statuses;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubmoduleStatus getStatus(SubmoduleWalk generator) throws IOException, ConfigInvalidException {
        ObjectId headId;
        ObjectId id = generator.getObjectId();
        String path = generator.getPath();
        if (generator.getModulesPath() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.MISSING, path, id);
        }
        if (generator.getConfigUrl() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id);
        }
        Repository subRepo = generator.getRepository();
        if (subRepo == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id);
        }
        try {
            headId = subRepo.resolve("HEAD");
        }
        finally {
            subRepo.close();
        }
        if (headId == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id, headId);
        }
        if (!headId.equals(id)) {
            return new SubmoduleStatus(SubmoduleStatusType.REV_CHECKED_OUT, path, id, headId);
        }
        return new SubmoduleStatus(SubmoduleStatusType.INITIALIZED, path, id, headId);
    }
}

