/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.LockFailedException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.PackFile;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.PackLock;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.AnyObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Constants;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.CoreConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.PackParser;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.PackedObjectInfo;
import org.gradle.internal.impldep.org.eclipse.jgit.util.FileUtils;
import org.gradle.internal.impldep.org.eclipse.jgit.util.NB;

public class ObjectDirectoryPackParser
extends PackParser {
    private final FileObjectDatabase db;
    private final CRC32 crc;
    private final MessageDigest tailDigest;
    private int indexVersion;
    private boolean keepEmpty;
    private File tmpPack;
    private File tmpIdx;
    private RandomAccessFile out;
    private long origEnd;
    private byte[] origHash;
    private long packEnd;
    private byte[] packHash;
    private Deflater def;
    private PackFile newPack;

    ObjectDirectoryPackParser(FileObjectDatabase odb, InputStream src) {
        super(odb, src);
        this.db = odb;
        this.crc = new CRC32();
        this.tailDigest = Constants.newMessageDigest();
        this.indexVersion = this.db.getConfig().get(CoreConfig.KEY).getPackIndexVersion();
    }

    public void setIndexVersion(int version) {
        this.indexVersion = version;
    }

    public void setKeepEmpty(boolean empty) {
        this.keepEmpty = empty;
    }

    public PackFile getPackFile() {
        return this.newPack;
    }

    @Override
    public long getPackSize() {
        if (this.newPack == null) {
            return super.getPackSize();
        }
        File pack = this.newPack.getPackFile();
        long size = pack.length();
        String p = pack.getAbsolutePath();
        String i = p.substring(0, p.length() - ".pack".length()) + ".idx";
        File idx = new File(i);
        if (idx.exists() && idx.isFile()) {
            size += idx.length();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackLock parse(ProgressMonitor receiving, ProgressMonitor resolving) throws IOException {
        this.tmpPack = File.createTempFile("incoming_", ".pack", this.db.getDirectory());
        this.tmpIdx = new File(this.db.getDirectory(), ObjectDirectoryPackParser.baseName(this.tmpPack) + ".idx");
        try {
            this.out = new RandomAccessFile(this.tmpPack, "rw");
            super.parse(receiving, resolving);
            this.out.seek(this.packEnd);
            this.out.write(this.packHash);
            this.out.getChannel().force(true);
            this.out.close();
            this.writeIdx();
            this.tmpPack.setReadOnly();
            this.tmpIdx.setReadOnly();
            PackLock packLock = this.renameAndOpenPack(this.getLockMessage());
            return packLock;
        }
        finally {
            if (this.def != null) {
                this.def.end();
            }
            try {
                if (this.out != null && this.out.getChannel().isOpen()) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {}
            this.cleanupTemporaryFiles();
        }
    }

    @Override
    protected void onPackHeader(long objectCount) throws IOException {
    }

    @Override
    protected void onBeginWholeObject(long streamPosition, int type, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    @Override
    protected void onEndWholeObject(PackedObjectInfo info) throws IOException {
        info.setCRC((int)this.crc.getValue());
    }

    @Override
    protected void onBeginOfsDelta(long streamPosition, long baseStreamPosition, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    @Override
    protected void onBeginRefDelta(long streamPosition, AnyObjectId baseId, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    @Override
    protected PackParser.UnresolvedDelta onEndDelta() throws IOException {
        PackParser.UnresolvedDelta delta = new PackParser.UnresolvedDelta();
        delta.setCRC((int)this.crc.getValue());
        return delta;
    }

    @Override
    protected void onInflatedObjectData(PackedObjectInfo obj, int typeCode, byte[] data) throws IOException {
    }

    @Override
    protected void onObjectHeader(PackParser.Source src, byte[] raw, int pos, int len) throws IOException {
        this.crc.update(raw, pos, len);
    }

    @Override
    protected void onObjectData(PackParser.Source src, byte[] raw, int pos, int len) throws IOException {
        this.crc.update(raw, pos, len);
    }

    @Override
    protected void onStoreStream(byte[] raw, int pos, int len) throws IOException {
        this.out.write(raw, pos, len);
    }

    @Override
    protected void onPackFooter(byte[] hash) throws IOException {
        this.origEnd = this.packEnd = this.out.getFilePointer();
        this.origHash = hash;
        this.packHash = hash;
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackParser.UnresolvedDelta delta, PackParser.ObjectTypeAndSize info) throws IOException {
        this.out.seek(delta.getOffset());
        this.crc.reset();
        return this.readObjectHeader(info);
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackedObjectInfo obj, PackParser.ObjectTypeAndSize info) throws IOException {
        this.out.seek(obj.getOffset());
        this.crc.reset();
        return this.readObjectHeader(info);
    }

    @Override
    protected int readDatabase(byte[] dst, int pos, int cnt) throws IOException {
        return this.out.read(dst, pos, cnt);
    }

    @Override
    protected boolean checkCRC(int oldCRC) {
        return oldCRC == (int)this.crc.getValue();
    }

    private static String baseName(File tmpPack) {
        String name = tmpPack.getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    private void cleanupTemporaryFiles() {
        if (this.tmpIdx != null && !this.tmpIdx.delete() && this.tmpIdx.exists()) {
            this.tmpIdx.deleteOnExit();
        }
        if (this.tmpPack != null && !this.tmpPack.delete() && this.tmpPack.exists()) {
            this.tmpPack.deleteOnExit();
        }
    }

    @Override
    protected boolean onAppendBase(int typeCode, byte[] data, PackedObjectInfo info) throws IOException {
        info.setOffset(this.packEnd);
        byte[] buf = this.buffer();
        int sz = data.length;
        int len = 0;
        buf[len++] = (byte)(typeCode << 4 | sz & 0xF);
        sz >>>= 4;
        while (sz > 0) {
            int n = len - 1;
            buf[n] = (byte)(buf[n] | 0x80);
            buf[len++] = (byte)(sz & 0x7F);
            sz >>>= 7;
        }
        this.tailDigest.update(buf, 0, len);
        this.crc.reset();
        this.crc.update(buf, 0, len);
        this.out.seek(this.packEnd);
        this.out.write(buf, 0, len);
        this.packEnd += (long)len;
        if (this.def == null) {
            this.def = new Deflater(-1, false);
        } else {
            this.def.reset();
        }
        this.def.setInput(data);
        this.def.finish();
        while (!this.def.finished()) {
            len = this.def.deflate(buf);
            this.tailDigest.update(buf, 0, len);
            this.crc.update(buf, 0, len);
            this.out.write(buf, 0, len);
            this.packEnd += (long)len;
        }
        info.setCRC((int)this.crc.getValue());
        return true;
    }

    @Override
    protected void onEndThinPack() throws IOException {
        int n;
        byte[] buf = this.buffer();
        MessageDigest origDigest = Constants.newMessageDigest();
        MessageDigest tailDigest2 = Constants.newMessageDigest();
        MessageDigest packDigest = Constants.newMessageDigest();
        long origRemaining = this.origEnd;
        this.out.seek(0L);
        this.out.readFully(buf, 0, 12);
        origDigest.update(buf, 0, 12);
        origRemaining -= 12L;
        NB.encodeInt32(buf, 8, this.getObjectCount());
        this.out.seek(0L);
        this.out.write(buf, 0, 12);
        packDigest.update(buf, 0, 12);
        while ((n = this.out.read(buf)) >= 0) {
            if (origRemaining != 0L) {
                int origCnt = (int)Math.min((long)n, origRemaining);
                origDigest.update(buf, 0, origCnt);
                if ((origRemaining -= (long)origCnt) == 0L) {
                    tailDigest2.update(buf, origCnt, n - origCnt);
                }
            } else {
                tailDigest2.update(buf, 0, n);
            }
            packDigest.update(buf, 0, n);
        }
        if (!Arrays.equals(origDigest.digest(), this.origHash) || !Arrays.equals(tailDigest2.digest(), this.tailDigest.digest())) {
            throw new IOException(JGitText.get().packCorruptedWhileWritingToFilesystem);
        }
        this.packHash = packDigest.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIdx() throws IOException {
        List<PackedObjectInfo> list = this.getSortedObjectList(null);
        try (FileOutputStream os = new FileOutputStream(this.tmpIdx);){
            PackIndexWriter iw = this.indexVersion <= 0 ? PackIndexWriter.createOldestPossible(os, list) : PackIndexWriter.createVersion(os, this.indexVersion);
            iw.write(list, this.packHash);
            os.getChannel().force(true);
        }
    }

    private PackLock renameAndOpenPack(String lockMessage) throws IOException {
        if (!this.keepEmpty && this.getObjectCount() == 0) {
            this.cleanupTemporaryFiles();
            return null;
        }
        MessageDigest d = Constants.newMessageDigest();
        byte[] oeBytes = new byte[20];
        for (int i = 0; i < this.getObjectCount(); ++i) {
            PackedObjectInfo oe = this.getObject(i);
            oe.copyRawTo(oeBytes, 0);
            d.update(oeBytes);
        }
        String name = ObjectId.fromRaw(d.digest()).name();
        File packDir = new File(this.db.getDirectory(), "pack");
        File finalPack = new File(packDir, "pack-" + name + ".pack");
        File finalIdx = new File(packDir, "pack-" + name + ".idx");
        PackLock keep = new PackLock(finalPack, this.db.getFS());
        if (!(packDir.exists() || packDir.mkdir() || packDir.exists())) {
            this.cleanupTemporaryFiles();
            throw new IOException(MessageFormat.format(JGitText.get().cannotCreateDirectory, packDir.getAbsolutePath()));
        }
        if (finalPack.exists()) {
            this.cleanupTemporaryFiles();
            return null;
        }
        if (lockMessage != null) {
            try {
                if (!keep.lock(lockMessage)) {
                    throw new LockFailedException(finalPack, MessageFormat.format(JGitText.get().cannotLockPackIn, finalPack));
                }
            }
            catch (IOException e) {
                this.cleanupTemporaryFiles();
                throw e;
            }
        }
        try {
            FileUtils.rename(this.tmpPack, finalPack, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            this.cleanupTemporaryFiles();
            keep.unlock();
            throw new IOException(MessageFormat.format(JGitText.get().cannotMovePackTo, finalPack), e);
        }
        try {
            FileUtils.rename(this.tmpIdx, finalIdx, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            this.cleanupTemporaryFiles();
            keep.unlock();
            if (!finalPack.delete()) {
                finalPack.deleteOnExit();
            }
            throw new IOException(MessageFormat.format(JGitText.get().cannotMoveIndexTo, finalIdx), e);
        }
        try {
            this.newPack = this.db.openPack(finalPack);
        }
        catch (IOException err) {
            keep.unlock();
            if (finalPack.exists()) {
                FileUtils.delete(finalPack);
            }
            if (finalIdx.exists()) {
                FileUtils.delete(finalIdx);
            }
            throw err;
        }
        return lockMessage != null ? keep : null;
    }
}

