/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.support.descriptor;

import java.lang.reflect.Method;
import java.util.Objects;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ClassUtils;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ToStringBuilder;
import org.gradle.internal.impldep.org.junit.platform.engine.TestSource;

@API(status=API.Status.STABLE, since="1.0")
public class MethodSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final String methodName;
    private final String methodParameterTypes;

    public static MethodSource from(String className, String methodName) {
        return new MethodSource(className, methodName);
    }

    public static MethodSource from(String className, String methodName, String methodParameterTypes) {
        return new MethodSource(className, methodName, methodParameterTypes);
    }

    public static MethodSource from(Method method) {
        return new MethodSource(method);
    }

    private MethodSource(String className, String methodName) {
        this(className, methodName, null);
    }

    private MethodSource(String className, String methodName, String methodParameterTypes) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        this.className = className;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    private MethodSource(Method method) {
        Preconditions.notNull(method, "method must not be null");
        this.className = method.getDeclaringClass().getName();
        this.methodName = method.getName();
        this.methodParameterTypes = ClassUtils.nullSafeToString(method.getParameterTypes());
    }

    public String getClassName() {
        return this.className;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final String getMethodParameterTypes() {
        return this.methodParameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSource that = (MethodSource)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.methodParameterTypes, that.methodParameterTypes);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.methodParameterTypes);
    }

    public String toString() {
        return new ToStringBuilder(this).append("className", this.className).append("methodName", this.methodName).append("methodParameterTypes", this.methodParameterTypes).toString();
    }
}

