/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.util.artifact;

import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;

public class ArtifacIdUtils {
    private static final char SEP = ':';

    private ArtifacIdUtils() {
    }

    public static String toId(Artifact artifact) {
        String id = null;
        if (artifact != null) {
            id = ArtifacIdUtils.toId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion());
        }
        return id;
    }

    public static String toId(String groupId, String artifactId, String extension, String classifier, String version) {
        StringBuilder buffer = ArtifacIdUtils.concat(groupId, artifactId, extension, classifier);
        buffer.append(':');
        if (version != null) {
            buffer.append(version);
        }
        return buffer.toString();
    }

    public static String toBaseId(Artifact artifact) {
        String id = null;
        if (artifact != null) {
            id = ArtifacIdUtils.toId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getBaseVersion());
        }
        return id;
    }

    public static String toVersionlessId(Artifact artifact) {
        String id = null;
        if (artifact != null) {
            id = ArtifacIdUtils.toVersionlessId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier());
        }
        return id;
    }

    public static String toVersionlessId(String groupId, String artifactId, String extension, String classifier) {
        return ArtifacIdUtils.concat(groupId, artifactId, extension, classifier).toString();
    }

    private static StringBuilder concat(String groupId, String artifactId, String extension, String classifier) {
        StringBuilder buffer = new StringBuilder(128);
        if (groupId != null) {
            buffer.append(groupId);
        }
        buffer.append(':');
        if (artifactId != null) {
            buffer.append(artifactId);
        }
        buffer.append(':');
        if (extension != null) {
            buffer.append(extension);
        }
        if (classifier != null && classifier.length() > 0) {
            buffer.append(':').append(classifier);
        }
        return buffer;
    }
}

