/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\r\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\b\u001a\u0010\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010*\u00020\b\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0010*\u00020\b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0012"}, d2={"kotlinPackageFqn", "Lorg/jetbrains/kotlin/name/FqName;", "getKotlinPackageFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "kotlinReflectionPackageFqn", "getKotlinReflectionPackageFqn", "isFunction", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isFunctionOrKFunction", "isFunctionTypeOrSubtype", "isInterface", "isKFunction", "isNullable", "isTypeParameter", "superTypes", "", "typeParameterSuperTypes", "ir.backend.common"})
public final class IrTypeUtilsKt {
    @NotNull
    private static final FqName kotlinPackageFqn;
    @NotNull
    private static final FqName kotlinReflectionPackageFqn;

    @NotNull
    public static final FqName getKotlinPackageFqn() {
        return kotlinPackageFqn;
    }

    @NotNull
    public static final FqName getKotlinReflectionPackageFqn() {
        return kotlinReflectionPackageFqn;
    }

    public static final boolean isFunction(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($receiver);
        if (irClassifierSymbol == null) {
            return false;
        }
        IrClassifierSymbol classifier2 = irClassifierSymbol;
        String string = classifier2.getDescriptor().getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "classifier.descriptor.name.asString()");
        String name = string;
        if (!StringsKt.startsWith$default(name, "Function", false, 2, null)) {
            return false;
        }
        IrSymbolOwner irSymbolOwner = classifier2.getOwner();
        if (irSymbolOwner == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        }
        IrDeclaration declaration = (IrDeclaration)((Object)irSymbolOwner);
        IrDeclarationParent irDeclarationParent = declaration.getParent();
        if (!(irDeclarationParent instanceof IrPackageFragment)) {
            irDeclarationParent = null;
        }
        IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
        if (irPackageFragment == null) {
            return false;
        }
        IrPackageFragment parent2 = irPackageFragment;
        return Intrinsics.areEqual(parent2.getFqName(), kotlinPackageFqn);
    }

    public static final boolean isKFunction(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($receiver);
        if (irClassifierSymbol == null) {
            return false;
        }
        IrClassifierSymbol classifier2 = irClassifierSymbol;
        String string = classifier2.getDescriptor().getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "classifier.descriptor.name.asString()");
        String name = string;
        if (!StringsKt.startsWith$default(name, "KFunction", false, 2, null)) {
            return false;
        }
        IrSymbolOwner irSymbolOwner = classifier2.getOwner();
        if (irSymbolOwner == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        }
        IrDeclaration declaration = (IrDeclaration)((Object)irSymbolOwner);
        IrDeclarationParent irDeclarationParent = declaration.getParent();
        if (!(irDeclarationParent instanceof IrPackageFragment)) {
            irDeclarationParent = null;
        }
        IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
        if (irPackageFragment == null) {
            return false;
        }
        IrPackageFragment parent2 = irPackageFragment;
        return Intrinsics.areEqual(parent2.getFqName(), kotlinReflectionPackageFqn);
    }

    @NotNull
    public static final List<IrType> superTypes(@NotNull IrType $receiver) {
        List<IrType> list2;
        Object classifier2;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Object object = IrTypesKt.getClassifierOrNull($receiver);
        if (object == null || (object = object.getOwner()) == null) {
            return CollectionsKt.emptyList();
        }
        Object object2 = classifier2 = object;
        if (object2 instanceof IrClass) {
            list2 = ((IrClass)classifier2).getSuperTypes();
        } else if (object2 instanceof IrTypeParameter) {
            list2 = ((IrTypeParameter)classifier2).getSuperTypes();
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return list2;
    }

    @NotNull
    public static final List<IrType> typeParameterSuperTypes(@NotNull IrType $receiver) {
        List<IrType> list2;
        IrClassifierSymbol classifier2;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($receiver);
        if (irClassifierSymbol == null) {
            return CollectionsKt.emptyList();
        }
        IrClassifierSymbol irClassifierSymbol2 = classifier2 = irClassifierSymbol;
        if (irClassifierSymbol2 instanceof IrTypeParameterSymbol) {
            list2 = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes();
        } else if (irClassifierSymbol2 instanceof IrClassSymbol) {
            list2 = CollectionsKt.emptyList();
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return list2;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($receiver), isFunctionTypeOrSubtype.1.INSTANCE, isFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(bl, "DFS.ifAny(listOf(this), \u2026) }, { it.isFunction() })");
        return bl;
    }

    public static final boolean isTypeParameter(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return IrTypesKt.getClassifierOrNull($receiver) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($receiver);
        IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        if (!(irSymbolOwner instanceof IrClass)) {
            irSymbolOwner = null;
        }
        IrClass irClass = (IrClass)irSymbolOwner;
        return (irClass != null ? irClass.getKind() : null) == ClassKind.INTERFACE;
    }

    public static final boolean isFunctionOrKFunction(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return IrTypeUtilsKt.isFunction($receiver) || IrTypeUtilsKt.isKFunction($receiver);
    }

    public static final boolean isNullable(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($receiver), isNullable.1.INSTANCE, isNullable.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(bl, "DFS.ifAny(listOf(this), \u2026is IrDynamicType\n    }\n})");
        return bl;
    }

    static {
        FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf("kotlin"));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.fromSegments(listOf(\"kotlin\"))");
        kotlinPackageFqn = fqName2;
        FqName fqName3 = kotlinPackageFqn.child(Name.identifier("reflection"));
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "kotlinPackageFqn.child(N\u2026identifier(\"reflection\"))");
        kotlinReflectionPackageFqn = fqName3;
    }
}

