/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.tower.TowerLevelsKt;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingContextUtils {
    private BindingContextUtils() {
    }

    @Nullable
    public static VariableDescriptor extractVariableFromResolvedCall(@NotNull BindingContext bindingContext, @Nullable KtElement callElement) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callElement, bindingContext);
        if (resolvedCall2 == null || !(resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor)) {
            return null;
        }
        return (VariableDescriptor)resolvedCall2.getResultingDescriptor();
    }

    @Nullable
    public static VariableDescriptor variableDescriptorForDeclaration(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof VariableDescriptor) {
            return (VariableDescriptor)descriptor2;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            return TowerLevelsKt.getFakeDescriptorForObject((ClassDescriptor)descriptor2);
        }
        return null;
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorFromReference(@NotNull BindingContext bindingContext, @Nullable KtElement element) {
        if (element instanceof KtSimpleNameExpression) {
            return BindingContextUtils.variableDescriptorForDeclaration(bindingContext.get(BindingContext.REFERENCE_TARGET, (KtSimpleNameExpression)element));
        }
        if (element instanceof KtQualifiedExpression) {
            return BindingContextUtils.extractVariableDescriptorFromReference(bindingContext, ((KtQualifiedExpression)element).getSelectorExpression());
        }
        return null;
    }

    public static void recordFunctionDeclarationToDescriptor(@NotNull BindingTrace trace, @NotNull PsiElement psiElement, @NotNull SimpleFunctionDescriptor function2) {
        trace.record(BindingContext.FUNCTION, psiElement, function2);
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key) {
        return BindingContextUtils.getNotNull(bindingContext, slice, key, "Value at " + slice + " must not be null for " + key);
    }

    @NotNull
    public static KotlinType getTypeNotNull(@NotNull BindingContext bindingContext, @NotNull KtExpression expression2) {
        KotlinType result2 = bindingContext.getType(expression2);
        if (result2 == null) {
            throw new IllegalStateException("Type must be not null for " + expression2);
        }
        return result2;
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key, @NotNull String messageIfNull) {
        V value = bindingContext.get(slice, key);
        if (value == null) {
            throw new IllegalStateException(messageIfNull);
        }
        return value;
    }

    @NotNull
    public static DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context, @NotNull KtElement element) {
        KtNamedDeclaration declaration = PsiTreeUtil.getParentOfType((PsiElement)element, KtNamedDeclaration.class);
        if (declaration instanceof KtFunctionLiteral) {
            return BindingContextUtils.getEnclosingDescriptor(context, declaration);
        }
        DeclarationDescriptor descriptor2 = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        assert (descriptor2 != null) : "No descriptor for named declaration: " + declaration.getText() + "\n(of type " + declaration.getClass() + ")";
        return descriptor2;
    }

    @Nullable
    public static FunctionDescriptor getEnclosingFunctionDescriptor(@NotNull BindingContext context, @NotNull KtElement element) {
        KtElement functionOrClass = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)element, KtFunction.class, KtClassOrObject.class);
        DeclarationDescriptor descriptor2 = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionOrClass);
        if (functionOrClass instanceof KtFunction) {
            if (descriptor2 instanceof FunctionDescriptor) {
                return (FunctionDescriptor)descriptor2;
            }
            return null;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            return ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor();
        }
        return null;
    }

    public static void reportAmbiguousLabel(@NotNull BindingTrace trace, @NotNull KtSimpleNameExpression targetLabel, @NotNull Collection<DeclarationDescriptor> declarationsByLabel) {
        ArrayList<PsiElement> targets = Lists.newArrayList();
        for (DeclarationDescriptor descriptor2 : declarationsByLabel) {
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            assert (element != null) : "Label can only point to something in the same lexical scope";
            targets.add(element);
        }
        if (!targets.isEmpty()) {
            trace.record(BindingContext.AMBIGUOUS_LABEL_TARGET, targetLabel, targets);
        }
        trace.report(Errors.AMBIGUOUS_LABEL.on(targetLabel));
    }

    @Nullable
    public static KotlinType updateRecordedType(@Nullable KotlinType type2, @NotNull KtExpression expression2, @NotNull BindingTrace trace, boolean shouldBeMadeNullable) {
        if (type2 == null) {
            return null;
        }
        if (shouldBeMadeNullable) {
            type2 = TypeUtils.makeNullable(type2);
        }
        trace.recordType(expression2, type2);
        return type2;
    }

    @Nullable
    public static KotlinTypeInfo getRecordedTypeInfo(@NotNull KtExpression expression2, @NotNull BindingContext context) {
        if (context.get(BindingContext.PROCESSED, expression2) != Boolean.TRUE) {
            return null;
        }
        KotlinTypeInfo result2 = context.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        return result2 != null ? result2 : TypeInfoFactoryKt.noTypeInfo(DataFlowInfoFactory.EMPTY);
    }

    public static boolean isExpressionWithValidReference(@NotNull KtExpression expression2, @NotNull BindingContext context) {
        if (expression2 instanceof KtCallExpression) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context);
            return resolvedCall2 instanceof VariableAsFunctionResolvedCall;
        }
        return expression2 instanceof KtReferenceExpression;
    }

    public static boolean isCapturedInClosure(BindingContext bindingContext, DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof VariableDescriptor) || descriptor2 instanceof PropertyDescriptor) {
            return false;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
        return bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null;
    }

    public static boolean isVarCapturedInClosure(BindingContext bindingContext, DeclarationDescriptor descriptor2) {
        return BindingContextUtils.isCapturedInClosure(bindingContext, descriptor2) && ((VariableDescriptor)descriptor2).isVar();
    }

    @NotNull
    public static Pair<FunctionDescriptor, PsiElement> getContainingFunctionSkipFunctionLiterals(@Nullable DeclarationDescriptor startDescriptor, boolean strict) {
        PsiElement containingFunction;
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(startDescriptor, FunctionDescriptor.class, strict);
        PsiElement psiElement = containingFunction = containingFunctionDescriptor != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        while (containingFunction instanceof KtFunctionLiteral) {
            containingFunction = (containingFunctionDescriptor = DescriptorUtils.getParentOfType(containingFunctionDescriptor, FunctionDescriptor.class)) != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        }
        return new Pair<FunctionDescriptor, PsiElement>(containingFunctionDescriptor, containingFunction);
    }

    @Nullable
    public static ResolvedCall<ConstructorDescriptor> getDelegationConstructorCall(@NotNull BindingContext bindingContext, @NotNull ConstructorDescriptor constructorDescriptor) {
        return bindingContext.get(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructorDescriptor);
    }

    static void addOwnDataTo(@NotNull BindingTrace trace, @Nullable TraceEntryFilter filter2, boolean commitDiagnostics, @NotNull MutableSlicedMap map2, MutableDiagnosticsWithSuppression diagnostics2) {
        map2.forEach((slice, key, value) -> {
            if (filter2 == null || filter2.accept((WritableSlice<?, ?>)slice, key)) {
                trace.record(slice, key, value);
            }
            return null;
        });
        if (!commitDiagnostics) {
            return;
        }
        for (Diagnostic diagnostic : diagnostics2.getOwnDiagnostics()) {
            if (filter2 != null && !filter2.accept(null, diagnostic.getPsiElement())) continue;
            trace.report(diagnostic);
        }
    }
}

