/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.ElementColumnInfo;
import com.intellij.coverage.view.PercentageCoverageColumnInfo;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DirectoryCoverageViewExtension
extends CoverageViewExtension {
    private final CoverageAnnotator myAnnotator;

    public DirectoryCoverageViewExtension(Project project, CoverageAnnotator annotator, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        super(project, suitesBundle, stateBean);
        this.myAnnotator = annotator;
    }

    @Override
    public ColumnInfo[] createColumnInfos() {
        return new ColumnInfo[]{new ElementColumnInfo(), new PercentageCoverageColumnInfo(1, "Statistics, %", this.mySuitesBundle, this.myStateBean)};
    }

    @Override
    public String getSummaryForNode(AbstractTreeNode node) {
        String statInfo = this.myAnnotator.getDirCoverageInformationString((PsiDirectory)node.getValue(), this.mySuitesBundle, this.myCoverageDataManager);
        statInfo = StringUtil.notNullize((String)statInfo, (String)"No coverage");
        return statInfo + " in '" + node.toString() + "'";
    }

    @Override
    public String getSummaryForRootNode(AbstractTreeNode childNode) {
        Object value = childNode.getValue();
        return this.myAnnotator.getDirCoverageInformationString((PsiDirectory)value, this.mySuitesBundle, this.myCoverageDataManager);
    }

    @Override
    public String getPercentage(int columnIdx, AbstractTreeNode node) {
        Object value = node.getValue();
        if (value instanceof PsiFile) {
            return this.myAnnotator.getFileCoverageInformationString((PsiFile)value, this.mySuitesBundle, this.myCoverageDataManager);
        }
        return value != null ? this.myAnnotator.getDirCoverageInformationString((PsiDirectory)value, this.mySuitesBundle, this.myCoverageDataManager) : null;
    }

    @Override
    public PsiElement getParentElement(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            return containingFile.getContainingDirectory();
        }
        return null;
    }

    @Override
    @NotNull
    public AbstractTreeNode createRootNode() {
        VirtualFile baseDir = this.myProject.getBaseDir();
        CoverageListRootNode coverageListRootNode = new CoverageListRootNode(this.myProject, (PsiNamedElement)PsiManager.getInstance((Project)this.myProject).findDirectory(baseDir), this.mySuitesBundle, this.myStateBean);
        if (coverageListRootNode == null) {
            DirectoryCoverageViewExtension.$$$reportNull$$$0(0);
        }
        return coverageListRootNode;
    }

    @Override
    public List<AbstractTreeNode> getChildrenNodes(AbstractTreeNode node) {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        if (node instanceof CoverageListNode) {
            PsiDirectory[] subdirectories;
            Object val = node.getValue();
            if (val instanceof PsiFile || val == null) {
                return Collections.emptyList();
            }
            PsiDirectory psiDirectory = (PsiDirectory)val;
            for (PsiDirectory subdirectory : subdirectories = (PsiDirectory[])ReadAction.compute(() -> psiDirectory.getSubdirectories())) {
                children.add(new CoverageListNode(this.myProject, (PsiNamedElement)subdirectory, this.mySuitesBundle, this.myStateBean));
            }
            PsiFile[] psiFiles = (PsiFile[])ReadAction.compute(() -> psiDirectory.getFiles());
            for (PsiFile psiFile : psiFiles) {
                children.add(new CoverageListNode(this.myProject, (PsiNamedElement)psiFile, this.mySuitesBundle, this.myStateBean));
            }
            for (AbstractTreeNode childNode : children) {
                childNode.setParent(node);
            }
        }
        return children;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/view/DirectoryCoverageViewExtension", "createRootNode"));
    }
}

