/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitorHelper;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ParameterCastFix
extends GroovyFix {
    @NotNull
    private final PsiType myType;
    @NotNull
    private final String myName;
    private final int myPosition;

    public ParameterCastFix(int position, @NotNull PsiType type) {
        if (type == null) {
            ParameterCastFix.$$$reportNull$$$0(0);
        }
        this.myType = type;
        this.myPosition = position;
        StringBuilder builder = new StringBuilder();
        builder.append("Cast ");
        builder.append(position + 1);
        switch (position + 1) {
            case 1: {
                builder.append("st");
                break;
            }
            case 2: {
                builder.append("nd");
                break;
            }
            case 3: {
                builder.append("rd");
                break;
            }
            default: {
                builder.append("th");
            }
        }
        builder.append(" parameter to ").append(this.myType.getPresentableText());
        this.myName = builder.toString();
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        PsiElement element;
        GrArgumentList list;
        if (project == null) {
            ParameterCastFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            ParameterCastFix.$$$reportNull$$$0(2);
        }
        GrArgumentList grArgumentList = list = (element = descriptor2.getPsiElement()) instanceof GrArgumentList ? (GrArgumentList)element : PsiUtil.getArgumentsList(element);
        if (list == null) {
            return;
        }
        List<GrExpression> callArguments = GroovyTypeCheckVisitorHelper.getExpressionArgumentsOfCall(list);
        if (callArguments == null || this.myPosition >= callArguments.size()) {
            return;
        }
        GrExpression expression = callArguments.get(this.myPosition);
        GrCastFix.doSafeCast(project, this.myType, expression);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ParameterCastFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Add parameter cast" == null) {
            ParameterCastFix.$$$reportNull$$$0(4);
        }
        return "Add parameter cast";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/assignment/ParameterCastFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/assignment/ParameterCastFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

