/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GrUnresolvedAccessInspection;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.QuickFixActionRegistrarAdapter;
import org.jetbrains.plugins.groovy.extensions.GroovyUnresolvedHighlightFilter;
import org.jetbrains.plugins.groovy.findUsages.MissingMethodAndPropertyUtil;
import org.jetbrains.plugins.groovy.lang.GrCreateClassKind;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GroovyDocPsiElement;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.transformations.impl.GroovyObjectTransformationSupport;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GrUnresolvedAccessChecker {
    public static final Logger LOG = Logger.getInstance(GrUnresolvedAccessChecker.class);
    private static final LightCacheKey<Map<String, Boolean>> GROOVY_OBJECT_METHODS_CACHE = new LightCacheKey<Map<String, Boolean>>(){

        @Override
        protected long getModificationCount(PsiElement holder) {
            return holder.getManager().getModificationTracker().getModificationCount();
        }
    };
    private final HighlightDisplayKey myDisplayKey;
    private final boolean myInspectionEnabled;
    private final GrUnresolvedAccessInspection myInspection;

    public GrUnresolvedAccessChecker(@NotNull GroovyFileBase file, @NotNull Project project) {
        if (file == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(1);
        }
        this.myInspectionEnabled = GrUnresolvedAccessInspection.isInspectionEnabled(file, project);
        this.myInspection = this.myInspectionEnabled ? GrUnresolvedAccessInspection.getInstance(file, project) : null;
        this.myDisplayKey = GrUnresolvedAccessInspection.findDisplayKey();
    }

    @Nullable
    public HighlightInfo checkCodeReferenceElement(GrCodeReferenceElement refElement) {
        HighlightInfo info = this.checkCodeRefInner(refElement);
        this.addEmptyIntentionIfNeeded(info);
        return info;
    }

    @Nullable
    public List<HighlightInfo> checkReferenceExpression(GrReferenceExpression ref) {
        List<HighlightInfo> info = this.checkRefInner(ref);
        this.addEmptyIntentionIfNeeded((HighlightInfo)ContainerUtil.getFirstItem(info));
        return info;
    }

    @Nullable
    private HighlightInfo checkCodeRefInner(GrCodeReferenceElement refElement) {
        if (PsiTreeUtil.getParentOfType((PsiElement)refElement, GroovyDocPsiElement.class) != null) {
            return null;
        }
        PsiElement nameElement = refElement.getReferenceNameElement();
        if (nameElement == null) {
            return null;
        }
        if (GrUnresolvedAccessChecker.isResolvedStaticImport(refElement)) {
            return null;
        }
        GroovyResolveResult resolveResult = refElement.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        if (!(refElement.getParent() instanceof GrPackageDefinition) && resolved == null) {
            String message = GroovyBundle.message("cannot.resolve", refElement.getReferenceName());
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(nameElement).descriptionAndTooltip(message).create();
            GrUnresolvedAccessChecker.registerCreateClassByTypeFix(refElement, info, this.myDisplayKey);
            GrUnresolvedAccessChecker.registerAddImportFixes(refElement, info, this.myDisplayKey);
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)refElement, (QuickFixActionRegistrar)new QuickFixActionRegistrarAdapter(info, this.myDisplayKey));
            QuickFixFactory.getInstance().registerOrderEntryFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarAdapter(info, this.myDisplayKey), (PsiReference)refElement);
            return info;
        }
        if (refElement.getParent() instanceof GrNewExpression && GrStaticChecker.isInStaticContext(refElement)) {
            PsiClass clazz;
            PsiClass outerClass;
            GrNewExpression newExpression = (GrNewExpression)refElement.getParent();
            if (resolved instanceof PsiClass && (outerClass = (clazz = (PsiClass)resolved).getContainingClass()) != null && com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)clazz) && !PsiUtil.hasEnclosingInstanceInScope(outerClass, newExpression, true) && !PsiImplUtil.hasArguments(newExpression)) {
                String qname = clazz.getQualifiedName();
                LOG.assertTrue(qname != null);
                return GrUnresolvedAccessChecker.createAnnotationForRef(refElement, true, GroovyBundle.message("cannot.reference.non.static", qname));
            }
        }
        return null;
    }

    @Nullable
    private List<HighlightInfo> checkRefInner(GrReferenceExpression ref) {
        PsiElement refNameElement = ref.getReferenceNameElement();
        if (refNameElement == null) {
            return null;
        }
        boolean inStaticContext = PsiUtil.isCompileStatic(ref) || GrStaticChecker.isPropertyAccessInStaticMethod(ref);
        GroovyResolveResult resolveResult = GrUnresolvedAccessChecker.getBestResolveResult(ref);
        if (resolveResult.getElement() != null) {
            if (!this.myInspectionEnabled) {
                return null;
            }
            if (!GrUnresolvedAccessChecker.isStaticOk(resolveResult)) {
                String message = GroovyBundle.message("cannot.reference.non.static", ref.getReferenceName());
                return Collections.singletonList(GrUnresolvedAccessChecker.createAnnotationForRef(ref, inStaticContext, message));
            }
            return null;
        }
        if (ResolveUtil.isKeyOfMap(ref) || ResolveUtil.isClassReference(ref)) {
            return null;
        }
        if (!inStaticContext) {
            if (!this.myInspectionEnabled) {
                return null;
            }
            assert (this.myInspection != null);
            if (!this.myInspection.myHighlightIfGroovyObjectOverridden && GrUnresolvedAccessChecker.areGroovyObjectMethodsOverridden(ref)) {
                return null;
            }
            if (!this.myInspection.myHighlightIfMissingMethodsDeclared && GrUnresolvedAccessChecker.areMissingMethodsDeclared(ref)) {
                return null;
            }
            if (GrUnresolvedAccessInspection.isSuppressed(ref)) {
                return null;
            }
        }
        if (inStaticContext || GrUnresolvedAccessChecker.shouldHighlightAsUnresolved(ref)) {
            HighlightInfo info = GrUnresolvedAccessChecker.createAnnotationForRef(ref, inStaticContext, GroovyBundle.message("cannot.resolve", ref.getReferenceName()));
            if (info == null) {
                return null;
            }
            ArrayList result2 = ContainerUtil.newArrayList();
            result2.add(info);
            if (ref.getParent() instanceof GrMethodCall) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)GrUnresolvedAccessChecker.registerStaticImportFix(ref, this.myDisplayKey));
            } else {
                GrUnresolvedAccessChecker.registerCreateClassByTypeFix(ref, info, this.myDisplayKey);
                GrUnresolvedAccessChecker.registerAddImportFixes(ref, info, this.myDisplayKey);
            }
            GrUnresolvedAccessChecker.registerReferenceFixes(ref, info, inStaticContext, this.myDisplayKey);
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)ref, (QuickFixActionRegistrar)new QuickFixActionRegistrarAdapter(info, this.myDisplayKey));
            QuickFixFactory.getInstance().registerOrderEntryFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarAdapter(info, this.myDisplayKey), (PsiReference)ref);
            return result2;
        }
        return null;
    }

    private static boolean areMissingMethodsDeclared(GrReferenceExpression ref) {
        PsiType qualifierType = PsiImplUtil.getQualifierType(ref);
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)qualifierType).resolve();
        if (resolved == null) {
            return false;
        }
        if (ref.getParent() instanceof GrCall) {
            PsiMethod[] found;
            for (PsiMethod method : found = resolved.findMethodsByName("methodMissing", true)) {
                if (!MissingMethodAndPropertyUtil.isMethodMissing(method)) continue;
                return true;
            }
        } else {
            PsiMethod[] found;
            for (PsiMethod method : found = resolved.findMethodsByName("propertyMissing", true)) {
                if (!MissingMethodAndPropertyUtil.isPropertyMissing(method)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean areGroovyObjectMethodsOverridden(GrReferenceExpression ref) {
        PsiMethod patternMethod = GrUnresolvedAccessChecker.findPatternMethod(ref);
        if (patternMethod == null) {
            return false;
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier != null) {
            return GrUnresolvedAccessChecker.checkGroovyObjectMethodsByQualifier(ref, patternMethod);
        }
        return GrUnresolvedAccessChecker.checkMethodInPlace(ref, patternMethod);
    }

    private static boolean checkMethodInPlace(GrReferenceExpression ref, PsiMethod patternMethod) {
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{GrClosableBlock.class, PsiMember.class, PsiFile.class});
        assert (container != null);
        return GrUnresolvedAccessChecker.checkContainer(patternMethod, container);
    }

    private static boolean checkContainer(@NotNull PsiMethod patternMethod, @NotNull PsiElement container) {
        Boolean cachedResult;
        if (patternMethod == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(2);
        }
        if (container == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(3);
        }
        String name = patternMethod.getName();
        ConcurrentMap cached = GROOVY_OBJECT_METHODS_CACHE.getCachedValue(container);
        if (cached == null) {
            cached = ContainerUtil.newConcurrentMap();
            GROOVY_OBJECT_METHODS_CACHE.putCachedValue(container, cached);
        }
        if ((cachedResult = cached.get(name)) != null) {
            return cachedResult;
        }
        boolean result2 = GrUnresolvedAccessChecker.doCheckContainer(patternMethod, container, name);
        cached.put(name, result2);
        return result2;
    }

    private static boolean doCheckContainer(final PsiMethod patternMethod, PsiElement container, final String name) {
        final Ref result2 = new Ref((Object)false);
        GrScopeProcessorWithHints processor = new GrScopeProcessorWithHints(name, ClassHint.RESOLVE_KINDS_METHOD){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element instanceof PsiMethod && name.equals(((PsiMethod)element).getName()) && patternMethod.getParameterList().getParametersCount() == ((PsiMethod)element).getParameterList().getParametersCount() && GrUnresolvedAccessChecker.isNotFromGroovyObject((PsiMethod)element)) {
                    result2.set((Object)true);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessChecker$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ResolveUtil.treeWalkUp(container, processor, true);
        return (Boolean)result2.get();
    }

    private static boolean checkGroovyObjectMethodsByQualifier(GrReferenceExpression ref, PsiMethod patternMethod) {
        PsiType qualifierType = PsiImplUtil.getQualifierType(ref);
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)qualifierType).resolve();
        if (resolved == null) {
            return false;
        }
        PsiMethod found = resolved.findMethodBySignature(patternMethod, true);
        if (found == null) {
            return false;
        }
        return GrUnresolvedAccessChecker.isNotFromGroovyObject(found);
    }

    private static boolean isNotFromGroovyObject(@NotNull PsiMethod found) {
        if (found == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(4);
        }
        if (GroovyObjectTransformationSupport.isGroovyObjectSupportMethod(found)) {
            return false;
        }
        PsiClass aClass = found.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qname = aClass.getQualifiedName();
        if ("groovy.lang.GroovyObject".equals(qname)) {
            return false;
        }
        return !"groovy.lang.GroovyObjectSupport".equals(qname);
    }

    @Nullable
    private static PsiMethod findPatternMethod(@NotNull GrReferenceExpression ref) {
        PsiClass groovyObject;
        if (ref == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(5);
        }
        if ((groovyObject = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("groovy.lang.GroovyObject", ref.getResolveScope())) == null) {
            return null;
        }
        String methodName = ref.getParent() instanceof GrCall ? "invokeMethod" : (PsiUtil.isLValue(ref) ? "setProperty" : "getProperty");
        PsiMethod[] patternMethods = groovyObject.findMethodsByName(methodName, false);
        if (patternMethods.length != 1) {
            return null;
        }
        return patternMethods[0];
    }

    private void addEmptyIntentionIfNeeded(@Nullable HighlightInfo info) {
        if (info != null) {
            int s2;
            int s1 = info.quickFixActionMarkers != null ? info.quickFixActionMarkers.size() : 0;
            int n = s2 = info.quickFixActionRanges != null ? info.quickFixActionRanges.size() : 0;
            if (s1 + s2 == 0) {
                EmptyIntentionAction emptyIntentionAction = new EmptyIntentionAction(GrUnresolvedAccessInspection.getDisplayText());
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)emptyIntentionAction, (HighlightDisplayKey)this.myDisplayKey);
            }
        }
    }

    private static boolean isResolvedStaticImport(GrCodeReferenceElement refElement) {
        PsiElement parent = refElement.getParent();
        return parent instanceof GrImportStatement && ((GrImportStatement)parent).isStatic() && refElement.multiResolve(false).length > 0;
    }

    private static boolean isStaticOk(GroovyResolveResult resolveResult) {
        if (resolveResult.isStaticsOK()) {
            return true;
        }
        PsiElement resolved = resolveResult.getElement();
        LOG.assertTrue(resolved != null);
        LOG.assertTrue(resolved instanceof PsiModifierListOwner, (Object)(resolved + " : " + resolved.getText()));
        return ((PsiModifierListOwner)resolved).hasModifierProperty("static");
    }

    @NotNull
    private static GroovyResolveResult getBestResolveResult(GrReferenceExpression ref) {
        GroovyResolveResult[] results = ref.multiResolve(false);
        if (results.length == 0) {
            EmptyGroovyResolveResult emptyGroovyResolveResult = EmptyGroovyResolveResult.INSTANCE;
            if (emptyGroovyResolveResult == null) {
                GrUnresolvedAccessChecker.$$$reportNull$$$0(6);
            }
            return emptyGroovyResolveResult;
        }
        if (results.length == 1) {
            GroovyResolveResult groovyResolveResult = results[0];
            if (groovyResolveResult == null) {
                GrUnresolvedAccessChecker.$$$reportNull$$$0(7);
            }
            return groovyResolveResult;
        }
        for (GroovyResolveResult result2 : results) {
            if (!result2.isAccessible() || !result2.isStaticsOK()) continue;
            GroovyResolveResult groovyResolveResult = result2;
            if (groovyResolveResult == null) {
                GrUnresolvedAccessChecker.$$$reportNull$$$0(8);
            }
            return groovyResolveResult;
        }
        for (GroovyResolveResult result2 : results) {
            if (!result2.isStaticsOK()) continue;
            GroovyResolveResult groovyResolveResult = result2;
            if (groovyResolveResult == null) {
                GrUnresolvedAccessChecker.$$$reportNull$$$0(9);
            }
            return groovyResolveResult;
        }
        GroovyResolveResult groovyResolveResult = results[0];
        if (groovyResolveResult == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(10);
        }
        return groovyResolveResult;
    }

    @Nullable
    private static HighlightInfo createAnnotationForRef(@NotNull GrReferenceElement ref, boolean strongError, @NotNull String message) {
        if (ref == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(11);
        }
        if (message == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(12);
        }
        HighlightDisplayLevel displayLevel = strongError ? HighlightDisplayLevel.ERROR : GrUnresolvedAccessInspection.getHighlightDisplayLevel(ref.getProject(), ref);
        return GrInspectionUtil.createAnnotationForRef(ref, displayLevel, message);
    }

    @Nullable
    private static HighlightInfo registerStaticImportFix(@NotNull GrReferenceExpression referenceExpression, @Nullable HighlightDisplayKey key) {
        String referenceName;
        if (referenceExpression == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)(referenceName = referenceExpression.getReferenceName()))) {
            return null;
        }
        if (referenceExpression.getQualifier() != null) {
            return null;
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(referenceExpression.getParent()).createUnconditionally();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createGroovyStaticImportMethodFix((GrMethodCall)referenceExpression.getParent()), (HighlightDisplayKey)key);
        return info;
    }

    private static void registerReferenceFixes(GrReferenceExpression refExpr, HighlightInfo info, boolean compileStatic, HighlightDisplayKey key) {
        PsiClass targetClass = QuickfixUtil.findTargetClass(refExpr, compileStatic);
        if (targetClass == null) {
            return;
        }
        if (!compileStatic) {
            GrUnresolvedAccessChecker.addDynamicAnnotation(info, refExpr, key);
        }
        if (!(targetClass instanceof SyntheticElement) || targetClass instanceof GroovyScriptClass) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createCreateFieldFromUsageFix(refExpr), (HighlightDisplayKey)key);
            if (PsiUtil.isAccessedForReading(refExpr)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createCreateGetterFromUsageFix(refExpr, targetClass), (HighlightDisplayKey)key);
            }
            if (PsiUtil.isLValue(refExpr)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createCreateSetterFromUsageFix(refExpr), (HighlightDisplayKey)key);
            }
            if (refExpr.getParent() instanceof GrCall && refExpr.getParent() instanceof GrExpression) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createCreateMethodFromUsageFix(refExpr), (HighlightDisplayKey)key);
            }
        }
        if (!refExpr.isQualified()) {
            GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)refExpr, GrVariableDeclarationOwner.class);
            if (!(owner instanceof GroovyFileBase) || ((GroovyFileBase)owner).isScript()) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createCreateLocalVariableFromUsageFix(refExpr, owner), (HighlightDisplayKey)key);
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)refExpr, GrMethod.class) != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createCreateParameterFromUsageFix(refExpr), (HighlightDisplayKey)key);
            }
        }
    }

    private static void addDynamicAnnotation(HighlightInfo info, GrReferenceExpression referenceExpression, HighlightDisplayKey key) {
        PsiFile containingFile = referenceExpression.getContainingFile();
        if (containingFile != null) {
            VirtualFile file = containingFile.getVirtualFile();
            if (file == null) {
                return;
            }
        } else {
            return;
        }
        if (PsiUtil.isCall(referenceExpression)) {
            PsiType[] argumentTypes = PsiUtil.getArgumentTypes(referenceExpression, false);
            if (argumentTypes != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (TextRange)referenceExpression.getTextRange(), (IntentionAction)GroovyQuickFixFactory.getInstance().createDynamicMethodFix(referenceExpression, argumentTypes), (HighlightDisplayKey)key);
            }
        } else {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (TextRange)referenceExpression.getTextRange(), (IntentionAction)GroovyQuickFixFactory.getInstance().createDynamicPropertyFix(referenceExpression), (HighlightDisplayKey)key);
        }
    }

    private static void registerAddImportFixes(GrReferenceElement refElement, @Nullable HighlightInfo info, HighlightDisplayKey key) {
        String referenceName = refElement.getReferenceName();
        if (StringUtil.isEmpty((String)referenceName)) {
            return;
        }
        if (!(refElement instanceof GrCodeReferenceElement) && Character.isLowerCase(referenceName.charAt(0))) {
            return;
        }
        if (refElement.getQualifier() != null) {
            return;
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createGroovyAddImportAction(refElement), (HighlightDisplayKey)key);
    }

    private static void registerCreateClassByTypeFix(@NotNull GrReferenceElement refElement, @Nullable HighlightInfo info, HighlightDisplayKey key) {
        GrPackageDefinition packageDefinition;
        if (refElement == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(14);
        }
        if ((packageDefinition = (GrPackageDefinition)PsiTreeUtil.getParentOfType((PsiElement)refElement, GrPackageDefinition.class)) != null) {
            return;
        }
        PsiElement parent = refElement.getParent();
        if (parent instanceof GrNewExpression && refElement.getManager().areElementsEquivalent((PsiElement)((GrNewExpression)parent).getReferenceElement(), (PsiElement)refElement)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFromNewAction((GrNewExpression)parent), (HighlightDisplayKey)key);
        } else if (GrUnresolvedAccessChecker.canBeClassOrPackage(refElement)) {
            if (GrUnresolvedAccessChecker.shouldBeInterface(refElement)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFixAction(refElement, GrCreateClassKind.INTERFACE), (HighlightDisplayKey)key);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFixAction(refElement, GrCreateClassKind.TRAIT), (HighlightDisplayKey)key);
            } else if (GrUnresolvedAccessChecker.shouldBeClass(refElement)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFixAction(refElement, GrCreateClassKind.CLASS), (HighlightDisplayKey)key);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFixAction(refElement, GrCreateClassKind.ENUM), (HighlightDisplayKey)key);
            } else if (GrUnresolvedAccessChecker.shouldBeAnnotation(refElement)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFixAction(refElement, GrCreateClassKind.ANNOTATION), (HighlightDisplayKey)key);
            } else {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFixAction(refElement, GrCreateClassKind.CLASS), (HighlightDisplayKey)key);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFixAction(refElement, GrCreateClassKind.INTERFACE), (HighlightDisplayKey)key);
                if (!refElement.isQualified() || GrUnresolvedAccessChecker.resolvesToGroovy(refElement.getQualifier())) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFixAction(refElement, GrCreateClassKind.TRAIT), (HighlightDisplayKey)key);
                }
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFixAction(refElement, GrCreateClassKind.ENUM), (HighlightDisplayKey)key);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)GroovyQuickFixFactory.getInstance().createClassFixAction(refElement, GrCreateClassKind.ANNOTATION), (HighlightDisplayKey)key);
            }
        }
    }

    private static boolean resolvesToGroovy(PsiElement qualifier) {
        PsiType type;
        if (qualifier instanceof GrReferenceElement) {
            return ((GrReferenceElement)qualifier).resolve() instanceof GroovyPsiElement;
        }
        if (qualifier instanceof GrExpression && (type = ((GrExpression)qualifier).getType()) instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type).resolve();
            return resolved instanceof GroovyPsiElement;
        }
        return false;
    }

    private static boolean canBeClassOrPackage(@NotNull GrReferenceElement refElement) {
        if (refElement == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(15);
        }
        return !(refElement instanceof GrReferenceExpression) || ResolveUtil.canBeClassOrPackage((GrReferenceExpression)refElement);
    }

    private static boolean shouldBeAnnotation(GrReferenceElement element) {
        return element.getParent() instanceof GrAnnotation;
    }

    private static boolean shouldBeInterface(GrReferenceElement myRefElement) {
        PsiElement parent = myRefElement.getParent();
        return parent instanceof GrImplementsClause || parent instanceof GrExtendsClause && parent.getParent() instanceof GrInterfaceDefinition;
    }

    private static boolean shouldBeClass(GrReferenceElement myRefElement) {
        PsiElement parent = myRefElement.getParent();
        return parent instanceof GrExtendsClause && !(parent.getParent() instanceof GrInterfaceDefinition);
    }

    private static boolean shouldHighlightAsUnresolved(@NotNull GrReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(16);
        }
        if (GrHighlightUtil.isDeclarationAssignment(referenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)referenceExpression.getQualifier();
        if (qualifier != null && qualifier.getType() == null && !GrUnresolvedAccessChecker.isRefToPackage(qualifier)) {
            return false;
        }
        if (qualifier != null && referenceExpression.getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER && referenceExpression.multiResolve(false).length > 0) {
            return false;
        }
        if (!GroovyUnresolvedHighlightFilter.shouldHighlight(referenceExpression)) {
            return false;
        }
        CollectConsumer consumer = new CollectConsumer();
        for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
            searcher.findDeclarationsAt((PsiElement)referenceExpression, 0, (Consumer)consumer);
            if (consumer.getResult().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean isRefToPackage(GrExpression expr) {
        return expr instanceof GrReferenceExpression && ((GrReferenceExpression)expr).resolve() instanceof PsiPackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "found";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessChecker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessChecker";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestResolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkContainer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNotFromGroovyObject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPatternMethod";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationForRef";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerStaticImportFix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerCreateClassByTypeFix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canBeClassOrPackage";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightAsUnresolved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

