/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class AnnotatedContextFilter
implements ContextFilter {
    private final String myAnnoQName;

    public AnnotatedContextFilter(String annoQName) {
        this.myAnnoQName = annoQName;
    }

    @Override
    public boolean isApplicable(GroovyClassDescriptor descriptor2, ProcessingContext ctx) {
        if (AnnotatedContextFilter.getPossibleAnnotations(descriptor2.getPlaceFile()).get(StringUtil.getShortName((String)this.myAnnoQName)) != Boolean.TRUE) {
            return false;
        }
        return AnnotatedContextFilter.findContextAnnotation(descriptor2.getPlace(), this.myAnnoQName) != null;
    }

    private static Map<String, Boolean> getPossibleAnnotations(PsiFile file) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            ConcurrentMap result2 = StringUtil.contains((CharSequence)file.getViewProvider().getContents(), (CharSequence)"@") ? ConcurrentFactoryMap.createMap(anno -> GrFileIndexUtil.hasNameInFile(file, anno)) : Collections.emptyMap();
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{file});
        });
    }

    @Nullable
    public static PsiAnnotation findContextAnnotation(@NotNull PsiElement context, String annoQName) {
        if (context == null) {
            AnnotatedContextFilter.$$$reportNull$$$0(0);
        }
        for (PsiElement current = context; current != null; current = current.getContext()) {
            GrPackageDefinition packageDefinition;
            if (current instanceof PsiModifierListOwner) {
                PsiAnnotation annotation;
                if (current instanceof GrVariableDeclaration || (annotation = AnnotatedContextFilter.findAnnotation(((PsiModifierListOwner)current).getModifierList(), annoQName)) == null) continue;
                return annotation;
            }
            if (!(current instanceof PsiFile)) continue;
            if (current instanceof GroovyFile && (packageDefinition = ((GroovyFile)current).getPackageDefinition()) != null) {
                return AnnotatedContextFilter.findAnnotation(packageDefinition.getAnnotationList(), annoQName);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotation(PsiModifierList modifierList, String annoQName) {
        return modifierList != null ? modifierList.findAnnotation(annoQName) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/dsl/toplevel/AnnotatedContextFilter", "findContextAnnotation"));
    }
}

