/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.hash.HashSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlignmentProvider {
    private final Map<PsiElement, Set<PsiElement>> myTree = new HashMap<PsiElement, Set<PsiElement>>();
    private final Map<Set<PsiElement>, Alignment> myAlignments = new HashMap<Set<PsiElement>, Alignment>();
    private final Map<Set<PsiElement>, Boolean> myAllowBackwardShift = new HashMap<Set<PsiElement>, Boolean>();
    private final Map<Set<PsiElement>, Alignment.Anchor> myAnchor = new HashMap<Set<PsiElement>, Alignment.Anchor>();

    public void addPair(@NotNull PsiElement e1, @NotNull PsiElement e2, @Nullable Boolean allowBackwardShift) {
        if (e1 == null) {
            AlignmentProvider.$$$reportNull$$$0(0);
        }
        if (e2 == null) {
            AlignmentProvider.$$$reportNull$$$0(1);
        }
        this.addPair(e1, e2, allowBackwardShift, null);
    }

    public void addPair(@NotNull PsiElement e1, @NotNull PsiElement e2, @Nullable Boolean allowBackwardShift, @Nullable Alignment.Anchor anchor) {
        if (e1 == null) {
            AlignmentProvider.$$$reportNull$$$0(2);
        }
        if (e2 == null) {
            AlignmentProvider.$$$reportNull$$$0(3);
        }
        assert (e1 != e2);
        Set<PsiElement> set1 = this.myTree.get(e1);
        Set<PsiElement> set2 = this.myTree.get(e2);
        if (set1 != null && set2 != null) {
            assert (!this.myAlignments.containsKey(set1) || !this.myAlignments.containsKey(set2));
            assert (this.myAllowBackwardShift.get(set1).booleanValue() == this.myAllowBackwardShift.get(set2).booleanValue());
            assert (this.myAnchor.get(set1) == this.myAnchor.get(set2));
            if (allowBackwardShift != null) assert (this.myAllowBackwardShift.get(set1).booleanValue() == allowBackwardShift.booleanValue());
            if (anchor != null) assert (this.myAnchor.get(set1) == anchor);
            if (this.myAlignments.containsKey(set2)) {
                this.addSet(set1, set2);
            } else {
                set1.addAll(set2);
                this.addSet(set2, set1);
            }
        } else if (set1 != null) {
            this.addElement(e2, allowBackwardShift, anchor, set1);
        } else if (set2 != null) {
            this.addElement(e1, allowBackwardShift, anchor, set2);
        } else {
            HashSet<PsiElement> set = AlignmentProvider.createHashSet();
            this.addInternal((Set<PsiElement>)set, e1);
            this.addInternal((Set<PsiElement>)set, e2);
            this.myAllowBackwardShift.put((Set<PsiElement>)set, allowBackwardShift);
            this.myAnchor.put((Set<PsiElement>)set, anchor);
        }
    }

    private void addElement(PsiElement e, Boolean allowBackwardShift, Alignment.Anchor anchor, Set<PsiElement> set) {
        if (allowBackwardShift != null) assert (this.myAllowBackwardShift.get(set).booleanValue() == allowBackwardShift.booleanValue());
        if (anchor != null) assert (this.myAnchor.get(set) == anchor);
        this.addInternal(set, e);
    }

    private void addSet(Set<PsiElement> set1, Set<PsiElement> set2) {
        Iterator<PsiElement> iterator2 = set1.iterator();
        while (iterator2.hasNext()) {
            PsiElement element = iterator2.next();
            iterator2.remove();
            this.addInternal(set2, element);
        }
    }

    private void addInternal(@NotNull Set<PsiElement> set, @NotNull PsiElement element) {
        if (set == null) {
            AlignmentProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            AlignmentProvider.$$$reportNull$$$0(5);
        }
        this.myTree.put(element, set);
        set.add(element);
    }

    @NotNull
    private static HashSet<PsiElement> createHashSet() {
        HashSet<PsiElement> hashSet = new HashSet<PsiElement>(){
            private final int myhash = new Object().hashCode();

            public int hashCode() {
                return this.myhash;
            }
        };
        if (hashSet == null) {
            AlignmentProvider.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public void addPair(@NotNull ASTNode node1, @NotNull ASTNode node2, boolean allowBackwardShift) {
        if (node1 == null) {
            AlignmentProvider.$$$reportNull$$$0(7);
        }
        if (node2 == null) {
            AlignmentProvider.$$$reportNull$$$0(8);
        }
        this.addPair(node1.getPsi(), node2.getPsi(), (Boolean)allowBackwardShift);
    }

    private void add(@NotNull PsiElement element, boolean allowBackwardShift) {
        if (element == null) {
            AlignmentProvider.$$$reportNull$$$0(9);
        }
        this.add(element, allowBackwardShift, Alignment.Anchor.LEFT);
    }

    private void add(@NotNull PsiElement element, boolean allowBackwardShift, @NotNull Alignment.Anchor anchor) {
        if (element == null) {
            AlignmentProvider.$$$reportNull$$$0(10);
        }
        if (anchor == null) {
            AlignmentProvider.$$$reportNull$$$0(11);
        }
        if (this.myTree.get(element) != null) {
            return;
        }
        HashSet<PsiElement> set = AlignmentProvider.createHashSet();
        set.add((Object)element);
        this.myTree.put(element, (Set<PsiElement>)set);
        this.myAllowBackwardShift.put((Set<PsiElement>)set, allowBackwardShift);
        this.myAnchor.put((Set<PsiElement>)set, anchor);
    }

    @Nullable
    public Alignment getAlignment(@NotNull PsiElement e) {
        Set<PsiElement> set;
        if (e == null) {
            AlignmentProvider.$$$reportNull$$$0(12);
        }
        if ((set = this.myTree.get(e)) == null) {
            return null;
        }
        Alignment alignment = this.myAlignments.get(set);
        if (alignment != null) {
            return alignment;
        }
        Alignment.Anchor anchor = this.myAnchor.get(set);
        if (anchor == null) {
            this.myAnchor.put(set, Alignment.Anchor.LEFT);
            anchor = Alignment.Anchor.LEFT;
        }
        alignment = Alignment.createAlignment((boolean)this.myAllowBackwardShift.get(set), (Alignment.Anchor)anchor);
        this.myAlignments.put(set, alignment);
        return alignment;
    }

    @NotNull
    public Aligner createAligner(boolean allowBackwardShift) {
        Aligner aligner = new Aligner(allowBackwardShift, Alignment.Anchor.LEFT);
        if (aligner == null) {
            AlignmentProvider.$$$reportNull$$$0(13);
        }
        return aligner;
    }

    @NotNull
    public Aligner createAligner(PsiElement element, boolean allowBackwardShift, Alignment.Anchor anchor) {
        Aligner aligner = new Aligner(allowBackwardShift, anchor);
        aligner.append(element);
        Aligner aligner2 = aligner;
        if (aligner2 == null) {
            AlignmentProvider.$$$reportNull$$$0(14);
        }
        return aligner2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/formatter/AlignmentProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/formatter/AlignmentProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashSet";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createAligner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPair";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addInternal";
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAlignment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Aligner {
        private PsiElement myRef;
        private boolean allowBackwardShift;
        @NotNull
        private final Alignment.Anchor myAnchor;

        private Aligner(@NotNull boolean allowBackwardShift, Alignment.Anchor anchor) {
            if (anchor == null) {
                Aligner.$$$reportNull$$$0(0);
            }
            this.myRef = null;
            this.allowBackwardShift = true;
            this.allowBackwardShift = allowBackwardShift;
            this.myAnchor = anchor;
        }

        public void append(@Nullable PsiElement element) {
            if (element == null) {
                return;
            }
            if (this.myRef == null) {
                this.myRef = element;
                AlignmentProvider.this.add(element, this.allowBackwardShift, this.myAnchor);
            } else {
                AlignmentProvider.this.addPair(this.myRef, element, this.allowBackwardShift, this.myAnchor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/plugins/groovy/formatter/AlignmentProvider$Aligner", "<init>"));
        }
    }
}

