/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;

public class GroovyWrappingProcessor {
    private final ASTNode myNode;
    private final CommonCodeStyleSettings mySettings;
    private final IElementType myParentType;
    private final Wrap myCommonWrap;
    private final FormattingContext myContext;
    private boolean myUsedDefaultWrap = false;
    private static final TokenSet SKIP = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mCOMMA, GroovyTokenTypes.mQUESTION, GroovyTokenTypes.mSEMI, GroovyTokenTypes.mASSIGN, GroovyTokenTypes.mBAND_ASSIGN, GroovyTokenTypes.mBOR_ASSIGN, GroovyTokenTypes.mBSR_ASSIGN, GroovyTokenTypes.mBXOR_ASSIGN, GroovyTokenTypes.mDIV_ASSIGN, GroovyTokenTypes.mMINUS_ASSIGN, GroovyTokenTypes.mMOD_ASSIGN, GroovyTokenTypes.mPLUS_ASSIGN, GroovyTokenTypes.mSL_ASSIGN, GroovyTokenTypes.mSR_ASSIGN, GroovyTokenTypes.mSTAR_ASSIGN, GroovyTokenTypes.mSTAR_STAR_ASSIGN, GroovyTokenTypes.mASSIGN, GroovyTokenTypes.mBAND_ASSIGN, GroovyTokenTypes.mBOR_ASSIGN, GroovyTokenTypes.mBSR_ASSIGN, GroovyTokenTypes.mBXOR_ASSIGN, GroovyTokenTypes.mDIV_ASSIGN, GroovyTokenTypes.mMINUS_ASSIGN, GroovyTokenTypes.mMOD_ASSIGN, GroovyTokenTypes.mPLUS_ASSIGN, GroovyTokenTypes.mSL_ASSIGN, GroovyTokenTypes.mSR_ASSIGN, GroovyTokenTypes.mSTAR_ASSIGN, GroovyTokenTypes.mSTAR_STAR_ASSIGN, GroovyTokenTypes.mBAND, GroovyTokenTypes.mBOR, GroovyTokenTypes.mBXOR, GroovyTokenTypes.mDIV, GroovyTokenTypes.mEQUAL, GroovyTokenTypes.mGE, GroovyTokenTypes.mGT, GroovyTokenTypes.mLOR, GroovyTokenTypes.mLT, GroovyTokenTypes.mLE, GroovyTokenTypes.mMINUS, GroovyTokenTypes.kAS, GroovyTokenTypes.kIN, GroovyTokenTypes.mMOD, GroovyTokenTypes.mPLUS, GroovyTokenTypes.mSTAR, GroovyTokenTypes.mSTAR_STAR, GroovyTokenTypes.mNOT_EQUAL, GroovyTokenTypes.mCOMPARE_TO, GroovyTokenTypes.mLAND, GroovyTokenTypes.kINSTANCEOF, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMPOSITE_LSHIFT_SIGN, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMPOSITE_RSHIFT_SIGN, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMPOSITE_TRIPLE_SHIFT_SIGN, GroovyTokenTypes.mREGEX_FIND, GroovyTokenTypes.mREGEX_MATCH, GroovyTokenTypes.mRANGE_INCLUSIVE, GroovyTokenTypes.mRANGE_EXCLUSIVE, GroovyTokenTypes.mBNOT, GroovyTokenTypes.mLNOT, GroovyTokenTypes.mMINUS, GroovyTokenTypes.mDEC, GroovyTokenTypes.mPLUS, GroovyTokenTypes.mINC, GroovyTokenTypes.mSPREAD_DOT, GroovyTokenTypes.mOPTIONAL_DOT, GroovyTokenTypes.mMEMBER_POINTER, GroovyTokenTypes.mDOT, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMPOSITE_LSHIFT_SIGN, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMPOSITE_RSHIFT_SIGN, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMPOSITE_TRIPLE_SHIFT_SIGN, GroovyTokenTypes.mLT, GroovyTokenTypes.mGT, GroovyTokenTypes.mLE, GroovyTokenTypes.mGE, GroovyTokenTypes.kIN, GroovyTokenTypes.kIN, GroovyTokenTypes.mCOLON, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.GSTRING_INJECTION, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END});
    private final TokenSet ANNOTATION_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.CLASS_DEFINITION, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.INTERFACE_DEFINITION, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ENUM_DEFINITION, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.TRAIT_DEFINITION, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ANNOTATION_DEFINITION, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.METHOD_DEFINITION, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.CONSTRUCTOR_DEFINITION, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.VARIABLE_DEFINITION, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.PARAMETER, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ENUM_CONSTANT, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.IMPORT_STATEMENT});

    public GroovyWrappingProcessor(GroovyBlock block) {
        this.myContext = block.getContext();
        this.mySettings = this.myContext.getSettings();
        this.myNode = block.getNode();
        this.myParentType = this.myNode.getElementType();
        this.myCommonWrap = this.createCommonWrap();
    }

    public Wrap getChildWrap(ASTNode childNode) {
        int wrapType;
        ASTNode leftSibling;
        if (this.myContext.isInsidePlainGString()) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        IElementType childType = childNode.getElementType();
        if (SKIP.contains(childType)) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        if (this.myParentType == GroovyElementTypes.ARGUMENT_LIST && (childType == GroovyElementTypes.T_LBRACK || childType == GroovyElementTypes.T_RBRACK)) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        if (this.myParentType == GroovyElementTypes.APPLICATION_ARGUMENT_LIST && this.myNode.getFirstChildNode() == childNode) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        if (!(this.myParentType != org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.EXTENDS_CLAUSE && this.myParentType != org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.IMPLEMENTS_CLAUSE || childType != GroovyTokenTypes.kEXTENDS && childType != GroovyTokenTypes.kIMPLEMENTS)) {
            return Wrap.createWrap((int)this.mySettings.EXTENDS_KEYWORD_WRAP, (boolean)true);
        }
        if (!(this.myParentType != org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ARGUMENTS && this.myParentType != GroovyElementTypes.TRY_RESOURCE_LIST || childType != GroovyTokenTypes.mLPAREN && childType != GroovyTokenTypes.mRPAREN)) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        if (this.myParentType == GroovyElementTypes.ARRAY_INITIALIZER && (childType == GroovyElementTypes.T_LBRACE || childType == GroovyElementTypes.T_RBRACE)) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.THROW_CLAUSE && childType == GroovyTokenTypes.kTHROWS) {
            return Wrap.createWrap((int)this.mySettings.THROWS_KEYWORD_WRAP, (boolean)true);
        }
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.MODIFIERS) {
            if (GroovyWrappingProcessor.getLeftSiblingType(childNode) == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ANNOTATION) {
                return this.getCommonWrap();
            }
            return null;
        }
        if (this.myParentType == GroovyElementTypes.PARAMETER_LIST && (childType == GroovyElementTypes.T_LPAREN || childType == GroovyElementTypes.T_RPAREN)) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        if (this.ANNOTATION_CONTAINERS.contains(this.myParentType) && (leftSibling = GroovyWrappingProcessor.getLeftSibling(childNode)) != null && leftSibling.getElementType() == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.MODIFIERS && GroovyWrappingProcessor.endsWithAnnotation(leftSibling) && (wrapType = this.getAnnotationsWrapType(childNode)) != -1) {
            return Wrap.createWrap((int)wrapType, (boolean)true);
        }
        return this.getCommonWrap();
    }

    @Nullable
    private static IElementType getLeftSiblingType(ASTNode node) {
        ASTNode prev = GroovyWrappingProcessor.getLeftSibling(node);
        return prev != null ? prev.getElementType() : null;
    }

    private static ASTNode getLeftSibling(ASTNode node) {
        ASTNode prev;
        for (prev = node.getTreePrev(); prev != null && StringUtil.isEmptyOrSpaces((String)prev.getText()); prev = prev.getTreePrev()) {
        }
        return prev;
    }

    private static boolean endsWithAnnotation(ASTNode modifierListNode) {
        PsiElement psi = modifierListNode.getPsi();
        return psi instanceof GrModifierList && psi.getLastChild() instanceof GrAnnotation;
    }

    private Wrap getCommonWrap() {
        if (this.myCommonWrap == null) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        if (this.myUsedDefaultWrap) {
            return this.myCommonWrap;
        }
        this.myUsedDefaultWrap = true;
        return GroovyWrappingProcessor.createNoneWrap();
    }

    private static Wrap createNormalWrap() {
        return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
    }

    private static Wrap createNoneWrap() {
        return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
    }

    @Nullable
    private Wrap createCommonWrap() {
        int wrapType;
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.EXTENDS_CLAUSE || this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.IMPLEMENTS_CLAUSE) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.EXTENDS_LIST_WRAP, (boolean)true);
        }
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.THROW_CLAUSE) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.THROWS_LIST_WRAP, (boolean)true);
        }
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.PARAMETERS_LIST) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.METHOD_PARAMETERS_WRAP, (boolean)false);
        }
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ARGUMENTS || this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMMAND_ARGUMENTS) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.CALL_PARAMETERS_WRAP, (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMMAND_ARGUMENTS ? 1 : 0) != 0);
        }
        if (this.myParentType == GroovyElementTypes.TRY_RESOURCE_LIST) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.RESOURCE_LIST_WRAP, (boolean)false);
        }
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.FOR_TRADITIONAL_CLAUSE || this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.FOR_IN_CLAUSE) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.FOR_STATEMENT_WRAP, (boolean)true);
        }
        if (TokenSets.BINARY_EXPRESSIONS.contains(this.myParentType)) {
            return Wrap.createWrap((int)this.mySettings.BINARY_OPERATION_WRAP, (boolean)false);
        }
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ASSIGNMENT_EXPRESSION || this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.TUPLE_ASSIGNMENT_EXPRESSION) {
            return Wrap.createWrap((int)this.mySettings.ASSIGNMENT_WRAP, (boolean)false);
        }
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.CONDITIONAL_EXPRESSION || this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ELVIS_EXPRESSION) {
            return Wrap.createWrap((int)this.mySettings.TERNARY_OPERATION_WRAP, (boolean)false);
        }
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ASSERT_STATEMENT) {
            return Wrap.createWrap((int)this.mySettings.ASSERT_STATEMENT_WRAP, (boolean)false);
        }
        if (this.myParentType == GroovyElementTypes.ARRAY_INITIALIZER) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.ARRAY_INITIALIZER_WRAP, (boolean)false);
        }
        if (TokenSets.BLOCK_SET.contains(this.myParentType)) {
            return GroovyWrappingProcessor.createNormalWrap();
        }
        if (this.myParentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.MODIFIERS && (wrapType = this.getAnnotationsWrapType(this.myNode)) != -1) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)wrapType, (boolean)true);
        }
        return null;
    }

    public Wrap getChainedMethodCallWrap() {
        return this.myContext.isInsidePlainGString() ? Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false) : Wrap.createWrap((int)this.mySettings.METHOD_CALL_CHAIN_WRAP, (boolean)false);
    }

    private int getAnnotationsWrapType(ASTNode modifierList) {
        IElementType containerType = modifierList.getTreeParent().getElementType();
        if (TokenSets.TYPE_DEFINITIONS.contains(containerType)) {
            return this.mySettings.CLASS_ANNOTATION_WRAP;
        }
        if (TokenSets.METHOD_DEFS.contains(containerType)) {
            return this.mySettings.METHOD_ANNOTATION_WRAP;
        }
        if (org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.VARIABLE_DEFINITION == containerType) {
            IElementType pparentType = modifierList.getTreeParent().getTreeParent().getElementType();
            if (pparentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.CLASS_BODY || pparentType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ENUM_BODY) {
                return this.mySettings.FIELD_ANNOTATION_WRAP;
            }
            return this.mySettings.VARIABLE_ANNOTATION_WRAP;
        }
        if (org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.PARAMETER == containerType) {
            return this.mySettings.PARAMETER_ANNOTATION_WRAP;
        }
        if (org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.ENUM_CONSTANT == containerType) {
            return this.mySettings.ENUM_CONSTANTS_WRAP;
        }
        if (org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.IMPORT_STATEMENT == containerType) {
            return this.myContext.getGroovySettings().IMPORT_ANNOTATION_WRAP;
        }
        return -1;
    }
}

