/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GrBreakStringOnLineBreaksIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            GrBreakStringOnLineBreaksIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GrBreakStringOnLineBreaksIntention.$$$reportNull$$$0(1);
        }
        String text = GrBreakStringOnLineBreaksIntention.invokeImpl(element);
        GrExpression newExpr = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(text);
        ((GrExpression)element).replaceWithExpression(newExpr, true);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element instanceof GrLiteral && !element.getText().equals(GrBreakStringOnLineBreaksIntention.invokeImpl(element));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/GrBreakStringOnLineBreaksIntention$1", "satisfiedBy"));
            }
        };
        if (psiElementPredicate == null) {
            GrBreakStringOnLineBreaksIntention.$$$reportNull$$$0(2);
        }
        return psiElementPredicate;
    }

    private static String invokeImpl(PsiElement element) {
        String text = element.getText();
        String quote = GrStringUtil.getStartQuote(text);
        if (!"'".equals(quote) && !"\"".equals(quote)) {
            return text;
        }
        if (!text.contains("\\n")) {
            return text;
        }
        String value = GrStringUtil.removeQuotes(text);
        StringBuilder buffer = new StringBuilder();
        if (element instanceof GrString) {
            GrBreakStringOnLineBreaksIntention.processGString(element, quote, value, buffer);
        } else {
            GrBreakStringOnLineBreaksIntention.processSimpleString(quote, value, buffer);
        }
        String result2 = buffer.toString();
        if (result2.endsWith("+\n\"\"")) {
            return result2.substring(0, result2.length() - 4);
        }
        return result2;
    }

    private static void processGString(PsiElement element, String quote, String value, StringBuilder buffer) {
        ASTNode node = element.getNode();
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == GroovyTokenTypes.mGSTRING_BEGIN || type == GroovyTokenTypes.mGSTRING_END) continue;
            if (type == GroovyElementTypes.GSTRING_INJECTION) {
                buffer.append(child.getText());
                continue;
            }
            value = child.getText();
            int prev = 0;
            if (!GrBreakStringOnLineBreaksIntention.isInjection(child.getTreePrev())) {
                buffer.append(quote);
            }
            int pos = value.indexOf("\\n");
            while (pos >= 0) {
                int end = GrBreakStringOnLineBreaksIntention.checkForR(value, pos);
                buffer.append(value, prev, end);
                prev = end;
                buffer.append(quote);
                buffer.append("+\n");
                buffer.append(quote);
                pos = value.indexOf("\\n", prev);
            }
            buffer.append(value.substring(prev));
            if (GrBreakStringOnLineBreaksIntention.isInjection(child.getTreeNext())) continue;
            buffer.append(quote);
        }
    }

    private static boolean isInjection(ASTNode next) {
        return next != null && next.getElementType() == GroovyElementTypes.GSTRING_INJECTION;
    }

    private static void processSimpleString(String quote, String value, StringBuilder buffer) {
        int prev = 0;
        int pos = value.indexOf("\\n");
        while (pos >= 0) {
            buffer.append(quote);
            int end = GrBreakStringOnLineBreaksIntention.checkForR(value, pos);
            buffer.append(value, prev, end);
            prev = end;
            buffer.append(quote);
            buffer.append("+\n");
            pos = value.indexOf("\\n", prev);
        }
        buffer.append(quote);
        buffer.append(value.substring(prev));
        buffer.append(quote);
    }

    private static int checkForR(String value, int pos) {
        if (value.length() > (pos += 2) + 2 && "\r".equals(value.substring(pos, pos + 2))) {
            return pos + 2;
        }
        return pos;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/GrBreakStringOnLineBreaksIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/GrBreakStringOnLineBreaksIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

