/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class RemoveUnnecessaryEscapeCharactersIntention
extends Intention {
    public static final String HINT = "Remove unnecessary escape characters";

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            RemoveUnnecessaryEscapeCharactersIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RemoveUnnecessaryEscapeCharactersIntention.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        TextRange range = element.getTextRange();
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)RemoveUnnecessaryEscapeCharactersIntention.removeUnnecessaryEscapeSymbols((GrLiteral)element));
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof GrLiteral)) {
                    return false;
                }
                String text = element.getText();
                return GrStringUtil.getStartQuote(text) != null && !RemoveUnnecessaryEscapeCharactersIntention.removeUnnecessaryEscapeSymbols((GrLiteral)element).equals(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/RemoveUnnecessaryEscapeCharactersIntention$1", "satisfiedBy"));
            }
        };
        if (psiElementPredicate == null) {
            RemoveUnnecessaryEscapeCharactersIntention.$$$reportNull$$$0(2);
        }
        return psiElementPredicate;
    }

    private static String removeUnnecessaryEscapeSymbols(GrLiteral literal) {
        String text = literal.getText();
        String quote = GrStringUtil.getStartQuote(text);
        String value = GrStringUtil.removeQuotes(text);
        StringBuilder buffer = new StringBuilder();
        buffer.append(quote);
        if (quote == "'") {
            GrStringUtil.escapeAndUnescapeSymbols(value, "", "\"$", buffer);
        } else if (quote == "'''") {
            int position = buffer.length();
            GrStringUtil.escapeAndUnescapeSymbols(value, "", "\"'$n", buffer);
            GrStringUtil.fixAllTripleQuotes(buffer, position);
        } else if (quote == "\"") {
            if (literal instanceof GrString) {
                ASTNode node = literal.getNode();
                for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    IElementType type = child.getElementType();
                    if (type == GroovyTokenTypes.mGSTRING_BEGIN || type == GroovyTokenTypes.mGSTRING_END) continue;
                    if (type == GroovyElementTypes.GSTRING_INJECTION) {
                        buffer.append(child.getText());
                        continue;
                    }
                    GrStringUtil.escapeAndUnescapeSymbols(child.getText(), "", "'", buffer);
                }
            } else {
                GrStringUtil.escapeAndUnescapeSymbols(value, "", "'", buffer);
            }
        } else if (quote == "\"\"\"") {
            if (literal instanceof GrString) {
                ASTNode node = literal.getNode();
                for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    IElementType type = child.getElementType();
                    if (type == GroovyTokenTypes.mGSTRING_BEGIN || type == GroovyTokenTypes.mGSTRING_END) continue;
                    if (type == GroovyElementTypes.GSTRING_INJECTION) {
                        buffer.append(child.getText());
                        continue;
                    }
                    int position = buffer.length();
                    GrStringUtil.escapeAndUnescapeSymbols(child.getText(), "", "\"'n", buffer);
                    GrStringUtil.fixAllTripleDoubleQuotes(buffer, position);
                }
            } else {
                int position = buffer.length();
                GrStringUtil.escapeAndUnescapeSymbols(value, "", "\"'n", buffer);
                GrStringUtil.fixAllTripleDoubleQuotes(buffer, position);
            }
        } else {
            return text;
        }
        buffer.append(quote);
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/RemoveUnnecessaryEscapeCharactersIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/RemoveUnnecessaryEscapeCharactersIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

