/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public class GrSetStrongTypeIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(GrSetStrongTypeIntention.class);

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, final Editor editor) throws IncorrectOperationException {
        PsiElement elementToBuildTemplate;
        GrVariable[] variables;
        PsiElement parent;
        if (element == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(1);
        }
        if ((parent = element.getParent()) instanceof GrVariable && parent.getParent() instanceof GrVariableDeclaration) {
            variables = ((GrVariableDeclaration)parent.getParent()).getVariables();
            elementToBuildTemplate = parent.getParent();
        } else if (parent instanceof GrVariable && parent.getParent() instanceof GrForInClause) {
            variables = new GrVariable[]{(GrVariable)parent};
            elementToBuildTemplate = parent.getParent().getParent();
        } else if (parent instanceof GrVariableDeclaration) {
            variables = ((GrVariableDeclaration)parent).getVariables();
            elementToBuildTemplate = parent;
        } else if (parent instanceof GrParameter && parent.getParent() instanceof GrParameterList) {
            variables = new GrVariable[]{(GrVariable)parent};
            elementToBuildTemplate = parent.getParent().getParent();
        } else if (parent instanceof GrVariable) {
            variables = new GrVariable[]{(GrVariable)parent};
            elementToBuildTemplate = parent;
        } else {
            return;
        }
        ArrayList<SupertypeConstraint> types = new ArrayList<SupertypeConstraint>();
        if (parent.getParent() instanceof GrForInClause) {
            types.add(SupertypeConstraint.create(PsiUtil.extractIteratedType((GrForInClause)parent.getParent())));
        } else {
            for (GrVariable variable : variables) {
                PsiParameter parameter;
                PsiType type;
                PsiType type2;
                GrExpression initializer = variable.getInitializerGroovy();
                if (initializer != null && (type2 = initializer.getType()) != null) {
                    types.add(SupertypeConstraint.create(type2));
                }
                if (!(variable instanceof GrParameter) || (type = GrSetStrongTypeIntention.getClosureParameterType(parameter = (PsiParameter)variable)) == null) continue;
                types.add(SupertypeConstraint.create(type));
            }
        }
        final String originalText = elementToBuildTemplate.getText();
        final TypeInfo typeInfo = GrSetStrongTypeIntention.getOrCreateTypeElement(parent, elementToBuildTemplate);
        PsiElement replaceElement = typeInfo.elementToReplace;
        TypeConstraint[] constraints = types.toArray(TypeConstraint.EMPTY_ARRAY);
        ChooseTypeExpression chooseTypeExpression = new ChooseTypeExpression(constraints, element.getManager(), replaceElement.getResolveScope());
        TemplateBuilderImpl builder = new TemplateBuilderImpl(elementToBuildTemplate);
        builder.replaceElement(replaceElement, (Expression)chooseTypeExpression);
        final Document document = editor.getDocument();
        final RangeMarker rangeMarker = document.createRangeMarker(elementToBuildTemplate.getTextRange());
        rangeMarker.setGreedyToRight(true);
        rangeMarker.setGreedyToLeft(true);
        PsiElement afterPostprocess = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)elementToBuildTemplate);
        Template template = builder.buildTemplate();
        TextRange range = afterPostprocess.getTextRange();
        document.deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        templateManager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (rangeMarker.isValid()) {
                            document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)originalText);
                            editor.getCaretModel().moveToOffset(rangeMarker.getStartOffset() + typeInfo2.originalOffset);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/plugins/groovy/intentions/declaration/GrSetStrongTypeIntention$1", "templateFinished"));
            }
        });
    }

    @Nullable
    private static PsiType getClosureParameterType(@NotNull PsiParameter parameter) {
        PsiElement scope;
        if (parameter == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(2);
        }
        PsiType type = (scope = parameter.getDeclarationScope()) instanceof GrClosableBlock ? ClosureParameterEnhancer.inferType((GrClosableBlock)scope, ((GrParameterList)parameter.getParent()).getParameterIndex(parameter)) : null;
        return type;
    }

    @NotNull
    private static TypeInfo getOrCreateTypeElement(@NotNull PsiElement parent, @NotNull PsiElement elementToBuildTemplateOn) {
        int nameElementOffset;
        GrModifierList modifierList;
        if (parent == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(3);
        }
        if (elementToBuildTemplateOn == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(4);
        }
        if ((modifierList = GrSetStrongTypeIntention.getModifierList(parent)) != null && modifierList.hasModifierProperty("def") && modifierList.getModifiers().length == 1) {
            PsiElement modifier = modifierList.getModifier("def");
            LOG.assertTrue(modifier != null);
            int modifierOffset = modifier.getTextRange().getEndOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
            TypeInfo typeInfo = new TypeInfo(modifier, modifierOffset);
            if (typeInfo == null) {
                GrSetStrongTypeIntention.$$$reportNull$$$0(5);
            }
            return typeInfo;
        }
        PsiClassType typeToUse = TypesUtil.createType("Abc", parent);
        if (elementToBuildTemplateOn instanceof GrVariableDeclaration) {
            GrVariableDeclaration decl = (GrVariableDeclaration)elementToBuildTemplateOn;
            decl.setType((PsiType)typeToUse);
            nameElementOffset = decl.getModifierList().getTextRange().getEndOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
        } else {
            GrVariable var = (GrVariable)parent;
            var.setType((PsiType)typeToUse);
            nameElementOffset = var.getNameIdentifierGroovy().getTextRange().getStartOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
        }
        TypeInfo typeInfo = new TypeInfo(GrSetStrongTypeIntention.getTypeElement(parent), nameElementOffset);
        if (typeInfo == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(6);
        }
        return typeInfo;
    }

    @Nullable
    private static GrTypeElement getTypeElement(PsiElement parent) {
        if (parent instanceof GrVariable) {
            return ((GrVariable)parent).getTypeElementGroovy();
        }
        return ((GrVariableDeclaration)parent).getTypeElementGroovy();
    }

    @Nullable
    private static GrModifierList getModifierList(PsiElement parent) {
        GrModifierList modifierList = parent instanceof GrVariable ? ((GrVariable)parent).getModifierList() : ((GrVariableDeclaration)parent).getModifierList();
        return modifierList;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                PsiElement pparent;
                PsiElement parent;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (this.isNameIdentifierOfVariable(element, parent = element.getParent()) || this.isModifierListOfVar(element, parent)) {
                    pparent = parent.getParent();
                } else if (this.isModifierListOfVarDecl(element, parent)) {
                    pparent = parent;
                } else {
                    return false;
                }
                if (pparent instanceof GrVariableDeclaration) {
                    GrVariable[] variables;
                    if (((GrVariableDeclaration)pparent).getTypeElementGroovy() != null) {
                        return false;
                    }
                    for (GrVariable variable : variables = ((GrVariableDeclaration)pparent).getVariables()) {
                        if (!GrSetStrongTypeIntention.isVarDeclaredWithInitializer(variable)) continue;
                        return true;
                    }
                } else {
                    if (pparent instanceof GrForInClause) {
                        GrVariable variable = ((GrForInClause)pparent).getDeclaredVariable();
                        return variable != null && variable.getTypeElementGroovy() == null && PsiUtil.extractIteratedType((GrForInClause)pparent) != null;
                    }
                    if (parent instanceof GrParameter && pparent instanceof GrParameterList) {
                        return ((GrParameter)parent).getTypeElementGroovy() == null && GrSetStrongTypeIntention.getClosureParameterType((PsiParameter)parent) != null;
                    }
                    GrVariable variable = (GrVariable)parent;
                    return variable.getTypeElementGroovy() == null && GrSetStrongTypeIntention.isVarDeclaredWithInitializer(variable);
                }
                return false;
            }

            private boolean isModifierListOfVarDecl(PsiElement element, PsiElement parent) {
                return parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).getModifierList() == element;
            }

            private boolean isModifierListOfVar(PsiElement element, PsiElement parent) {
                return parent instanceof GrVariable && ((GrVariable)parent).getModifierList() == element;
            }

            private boolean isNameIdentifierOfVariable(PsiElement element, PsiElement parent) {
                return parent instanceof GrVariable && ((GrVariable)parent).getTypeElementGroovy() == null && element == ((GrVariable)parent).getNameIdentifierGroovy();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/declaration/GrSetStrongTypeIntention$2", "satisfiedBy"));
            }
        };
        if (psiElementPredicate == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(7);
        }
        return psiElementPredicate;
    }

    private static boolean isVarDeclaredWithInitializer(GrVariable variable) {
        GrExpression initializer = variable.getInitializerGroovy();
        return initializer != null && initializer.getType() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToBuildTemplateOn";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/declaration/GrSetStrongTypeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/declaration/GrSetStrongTypeIntention";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateTypeElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClosureParameterType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateTypeElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeInfo {
        final PsiElement elementToReplace;
        final int originalOffset;

        TypeInfo(PsiElement element, int offset) {
            this.originalOffset = offset;
            this.elementToReplace = element;
        }
    }
}

