/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightFieldBuilder;
import com.intellij.util.ArrayUtil;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public class GrPropertyForCompletion
extends LightFieldBuilder {
    @NotNull
    private final PsiMethod myOriginalAccessor;

    public GrPropertyForCompletion(@NotNull PsiMethod method, @NotNull String name, @NotNull PsiType type) {
        if (method == null) {
            GrPropertyForCompletion.$$$reportNull$$$0(0);
        }
        if (name == null) {
            GrPropertyForCompletion.$$$reportNull$$$0(1);
        }
        if (type == null) {
            GrPropertyForCompletion.$$$reportNull$$$0(2);
        }
        super(method.getManager(), name, type);
        this.myOriginalAccessor = method;
        ArrayList<String> modifiers = new ArrayList<String>();
        if (method.hasModifierProperty("public")) {
            modifiers.add("public");
        }
        if (method.hasModifierProperty("protected")) {
            modifiers.add("protected");
        }
        if (method.hasModifierProperty("private")) {
            modifiers.add("private");
        }
        if (method.hasModifierProperty("static")) {
            modifiers.add("static");
        }
        this.setContainingClass(method.getContainingClass());
        this.setModifiers(ArrayUtil.toStringArray(modifiers));
        this.setBaseIcon(JetgroovyIcons.Groovy.Property);
    }

    @NotNull
    public Language getLanguage() {
        GroovyLanguage groovyLanguage = GroovyLanguage.INSTANCE;
        if (groovyLanguage == null) {
            GrPropertyForCompletion.$$$reportNull$$$0(3);
        }
        return groovyLanguage;
    }

    @NotNull
    public PsiMethod getOriginalAccessor() {
        PsiMethod psiMethod = this.myOriginalAccessor;
        if (psiMethod == null) {
            GrPropertyForCompletion.$$$reportNull$$$0(4);
        }
        return psiMethod;
    }

    public int hashCode() {
        int isStatic = this.hasModifierProperty("static") ? 1 : 0;
        int visibilityModifier = this.getVisibilityCode();
        return this.getName().hashCode() << 3 + isStatic << 2 + visibilityModifier;
    }

    private int getVisibilityCode() {
        int visibilityModifier = this.hasModifierProperty("public") ? 3 : (this.hasModifierProperty("protected") ? 2 : (this.hasModifierProperty("private") ? 1 : 0));
        return visibilityModifier;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (!(another instanceof GrPropertyForCompletion)) {
            return false;
        }
        if (!((GrPropertyForCompletion)another).getName().equals(this.getName())) {
            return false;
        }
        if (this.hasModifierProperty("static") != ((GrPropertyForCompletion)another).hasModifierProperty("static")) {
            return false;
        }
        return this.getVisibilityCode() == ((GrPropertyForCompletion)another).getVisibilityCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/GrPropertyForCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/GrPropertyForCompletion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

