/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.expectedTypes;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConstructorCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesContributor;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyExpectedTypesProvider {
    public static TypeConstraint[] calculateTypeConstraints(@NotNull GrExpression expression) {
        if (expression == null) {
            GroovyExpectedTypesProvider.$$$reportNull$$$0(0);
        }
        return (TypeConstraint[])TypeInferenceHelper.getCurrentContext().getCachedValue(expression, () -> {
            if (expression == null) {
                GroovyExpectedTypesProvider.$$$reportNull$$$0(2);
            }
            MyCalculator calculator = new MyCalculator(expression);
            PsiElement parent = expression.getParent();
            if (parent instanceof GroovyPsiElement) {
                ((GroovyPsiElement)parent).accept(calculator);
            } else {
                parent.accept((PsiElementVisitor)new GroovyPsiElementVisitor(calculator));
            }
            TypeConstraint[] result2 = calculator.getResult();
            ArrayList custom = ContainerUtil.newArrayList();
            for (GroovyExpectedTypesContributor contributor : (GroovyExpectedTypesContributor[])GroovyExpectedTypesContributor.EP_NAME.getExtensions()) {
                custom.addAll(contributor.calculateTypeConstraints(expression));
            }
            if (!custom.isEmpty()) {
                custom.addAll(0, Arrays.asList(result2));
                return custom.toArray(TypeConstraint.EMPTY_ARRAY);
            }
            return result2;
        });
    }

    public static List<PsiType> getDefaultExpectedTypes(@NotNull GrExpression element) {
        if (element == null) {
            GroovyExpectedTypesProvider.$$$reportNull$$$0(1);
        }
        Object[] constraints = GroovyExpectedTypesProvider.calculateTypeConstraints(element);
        return ContainerUtil.map((Object[])constraints, constraint -> constraint.getDefaultType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/GroovyExpectedTypesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateTypeConstraints";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultExpectedTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$calculateTypeConstraints$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyCalculator
    extends GroovyElementVisitor {
        private TypeConstraint[] myResult;
        private final GrExpression myExpression;

        MyCalculator(GrExpression expression) {
            this.myExpression = (GrExpression)PsiUtil.skipParentheses(expression, true);
            this.myResult = TypeConstraint.EMPTY_ARRAY;
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            GrTypeElement typeElement;
            GrParameterListOwner parent;
            if (returnStatement == null) {
                MyCalculator.$$$reportNull$$$0(0);
            }
            if ((parent = (GrParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrParameterListOwner.class)) instanceof GrMethod && (typeElement = ((GrMethod)parent).getReturnTypeElementGroovy()) != null) {
                PsiType type = typeElement.getType();
                this.myResult = new TypeConstraint[]{SubtypeConstraint.create(type)};
            }
        }

        @Override
        public void visitVariable(@NotNull GrVariable variable) {
            if (variable == null) {
                MyCalculator.$$$reportNull$$$0(1);
            }
            if (this.myExpression.equals(variable.getInitializerGroovy())) {
                PsiType type = variable.getType();
                this.myResult = MyCalculator.createSimpleSubTypeResult(type);
            }
        }

        @Override
        public void visitNamedArgument(@NotNull GrNamedArgument argument) {
            PsiElement pparent;
            GrArgumentLabel label;
            if (argument == null) {
                MyCalculator.$$$reportNull$$$0(2);
            }
            if ((label = argument.getLabel()) != null && (pparent = argument.getParent().getParent()) instanceof GrCall && MyCalculator.resolvesToDefaultConstructor((GrCall)pparent)) {
                GroovyResolveResult resolveResult = label.advancedResolve();
                PsiElement resolved = resolveResult.getElement();
                PsiType type = resolved instanceof PsiField ? ((PsiField)resolved).getType() : (resolved instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)resolved) ? ((PsiMethod)resolved).getParameterList().getParameters()[0].getType() : null);
                PsiType substituted = resolveResult.getSubstitutor().substitute(type);
                if (substituted != null) {
                    this.myResult = MyCalculator.createSimpleSubTypeResult(substituted);
                }
            }
        }

        private static boolean resolvesToDefaultConstructor(GrCall call) {
            PsiElement resolved;
            PsiMethod method = call.resolveMethod();
            if (method != null && method.isConstructor() && method.getParameterList().isEmpty()) {
                return true;
            }
            return call instanceof GrConstructorCall && (resolved = PsiImplUtil.extractUniqueResult(((GrConstructorCall)call).multiResolveClass()).getElement()) instanceof PsiClass;
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCall) {
            GrExpression invokedExpression;
            if (methodCall == null) {
                MyCalculator.$$$reportNull$$$0(3);
            }
            if (this.myExpression.equals(invokedExpression = methodCall.getInvokedExpression())) {
                this.myResult = new TypeConstraint[]{SubtypeConstraint.create("groovy.lang.Closure", methodCall)};
                return;
            }
            GrClosableBlock[] closureArgs = methodCall.getClosureArguments();
            if (ArrayUtil.contains((Object)this.myExpression, (Object[])closureArgs)) {
                GrArgumentList argumentList = methodCall.getArgumentList();
                GrNamedArgument[] namedArgs = argumentList.getNamedArguments();
                GrExpression[] expressionArgs = argumentList.getExpressionArguments();
                GroovyResolveResult[] callVariants = ResolveUtil.getCallVariants(this.myExpression);
                this.processCallVariants(methodCall, callVariants, namedArgs, expressionArgs, closureArgs);
            }
        }

        @Override
        public void visitOpenBlock(@NotNull GrOpenBlock block) {
            GrStatement[] statements;
            if (block == null) {
                MyCalculator.$$$reportNull$$$0(4);
            }
            if ((statements = block.getStatements()).length > 0 && this.myExpression.equals(statements[statements.length - 1])) {
                this.checkExitPoint();
            }
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
            if (ifStatement == null) {
                MyCalculator.$$$reportNull$$$0(5);
            }
            if (this.myExpression.equals(ifStatement.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(ifStatement), (PsiType)PsiType.BOOLEAN)};
            } else if (this.myExpression.equals(ifStatement.getThenBranch()) || this.myExpression.equals(ifStatement.getElseBranch())) {
                this.checkExitPoint();
            }
        }

        @Override
        public void visitAnnotationMethod(@NotNull GrAnnotationMethod method) {
            PsiType type;
            if (method == null) {
                MyCalculator.$$$reportNull$$$0(6);
            }
            if ((type = method.getReturnType()) != null && MyCalculator.isAcceptableAnnotationValueType(type)) {
                this.myResult = MyCalculator.createSimpleSubTypeResult(type);
            }
        }

        @Override
        public void visitAnnotationArrayInitializer(@NotNull GrAnnotationArrayInitializer arrayInitializer) {
            GrAnnotationNameValuePair nameValuePair;
            if (arrayInitializer == null) {
                MyCalculator.$$$reportNull$$$0(7);
            }
            if ((nameValuePair = (GrAnnotationNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)arrayInitializer, GrAnnotationNameValuePair.class, (boolean)true, (Class[])new Class[]{GrAnnotationMethod.class})) != null) {
                PsiClass annot = ResolveUtil.resolveAnnotation(arrayInitializer);
                if (annot == null) {
                    return;
                }
                String name = nameValuePair.getName();
                if (name == null) {
                    return;
                }
                this.createResultFromAttrName(annot, name);
            } else {
                GrAnnotationMethod method = (GrAnnotationMethod)PsiTreeUtil.getParentOfType((PsiElement)arrayInitializer, GrAnnotationMethod.class);
                assert (method != null);
                PsiType type = method.getReturnType();
                int count = 1;
                PsiElement parent = arrayInitializer.getParent();
                while (parent instanceof GrAnnotationArrayInitializer) {
                    ++count;
                    parent = parent.getParent();
                }
                while (type instanceof PsiArrayType && count > 0) {
                    type = ((PsiArrayType)type).getComponentType();
                    --count;
                }
                if (type != null && MyCalculator.isAcceptableAnnotationValueType(type)) {
                    this.myResult = MyCalculator.createSimpleSubTypeResult(type);
                }
            }
        }

        @Override
        public void visitAnnotationNameValuePair(@NotNull GrAnnotationNameValuePair nameValuePair) {
            PsiClass annot;
            if (nameValuePair == null) {
                MyCalculator.$$$reportNull$$$0(8);
            }
            if (this.myExpression.equals(nameValuePair.getValue()) && (annot = ResolveUtil.resolveAnnotation(nameValuePair.getParent())) != null) {
                String name = nameValuePair.getName();
                if (name != null) {
                    this.createResultFromAttrName(annot, name);
                } else {
                    PsiMethod[] valueAttr = annot.findMethodsByName("value", false);
                    if (valueAttr.length > 0) {
                        boolean canHaveSimpleExpr;
                        boolean bl = canHaveSimpleExpr = ContainerUtil.find((Object[])annot.getMethods(), method -> !"value".equals(method.getName()) && (!(method instanceof PsiAnnotationMethod) || ((PsiAnnotationMethod)method).getDefaultValue() == null)) == null;
                        if (canHaveSimpleExpr) {
                            this.createResultFromAnnotationAttribute(valueAttr[0]);
                        }
                    }
                }
            }
        }

        private void createResultFromAttrName(PsiClass annotation, String attrName) {
            PsiMethod[] attrs = annotation.findMethodsByName(attrName, false);
            if (attrs.length > 0) {
                this.createResultFromAnnotationAttribute(attrs[0]);
            }
        }

        private void createResultFromAnnotationAttribute(PsiMethod attr) {
            PsiType type = attr.getReturnType();
            while (type instanceof PsiArrayType) {
                type = ((PsiArrayType)type).getComponentType();
            }
            if (type != null && MyCalculator.isAcceptableAnnotationValueType(type)) {
                this.myResult = MyCalculator.createSimpleSubTypeResult(type);
            }
        }

        private static boolean isAcceptableAnnotationValueType(PsiType type) {
            return type instanceof PsiPrimitiveType || type.equalsToText("java.lang.String") || type.equalsToText("java.lang.Class") || type instanceof PsiClassType && ((PsiClassType)type).resolve() != null && ((PsiClassType)type).resolve().isEnum();
        }

        @NotNull
        private static TypeConstraint[] createSimpleSubTypeResult(@NotNull PsiType type) {
            if (type == null) {
                MyCalculator.$$$reportNull$$$0(9);
            }
            TypeConstraint[] typeConstraintArray = new TypeConstraint[]{new SubtypeConstraint(type, type)};
            if (typeConstraintArray == null) {
                MyCalculator.$$$reportNull$$$0(10);
            }
            return typeConstraintArray;
        }

        private void checkExitPoint() {
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)this.myExpression, (Class[])new Class[]{PsiMethod.class, GrClosableBlock.class});
            if (element instanceof GrMethod) {
                final GrMethod method = (GrMethod)element;
                ControlFlowUtils.visitAllExitPoints(method.getBlock(), new ControlFlowUtils.ExitPointVisitor(){

                    @Override
                    public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                        if (returnValue == myExpression) {
                            PsiType returnType = method.getReturnType();
                            if (returnType != null) {
                                MyCalculator.access$102(this, MyCalculator.createSimpleSubTypeResult(returnType));
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
            if (whileStatement == null) {
                MyCalculator.$$$reportNull$$$0(11);
            }
            if (this.myExpression.equals(whileStatement.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(whileStatement), (PsiType)PsiType.BOOLEAN)};
            }
        }

        @Override
        public void visitTraditionalForClause(@NotNull GrTraditionalForClause forClause) {
            if (forClause == null) {
                MyCalculator.$$$reportNull$$$0(12);
            }
            if (this.myExpression.equals(forClause.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(forClause), (PsiType)PsiType.BOOLEAN)};
            }
        }

        @Override
        public void visitArgumentList(@NotNull GrArgumentList list) {
            if (list == null) {
                MyCalculator.$$$reportNull$$$0(13);
            }
            this.processCallVariants(list, ResolveUtil.getCallVariants(list), list.getNamedArguments(), list.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY);
        }

        private void processCallVariants(@NotNull PsiElement place, @NotNull GroovyResolveResult[] variants, @NotNull GrNamedArgument[] namedArguments, @NotNull GrExpression[] expressionArguments, @NotNull GrClosableBlock[] closureArguments) {
            if (place == null) {
                MyCalculator.$$$reportNull$$$0(14);
            }
            if (variants == null) {
                MyCalculator.$$$reportNull$$$0(15);
            }
            if (namedArguments == null) {
                MyCalculator.$$$reportNull$$$0(16);
            }
            if (expressionArguments == null) {
                MyCalculator.$$$reportNull$$$0(17);
            }
            if (closureArguments == null) {
                MyCalculator.$$$reportNull$$$0(18);
            }
            List<Pair<PsiParameter, PsiType>> expectedParams = ResolveUtil.collectExpectedParamsByArg(place, variants, namedArguments, expressionArguments, closureArguments, this.myExpression);
            this.collectExpectedTypeFromPossibleParams(expectedParams);
        }

        private void collectExpectedTypeFromPossibleParams(List<Pair<PsiParameter, PsiType>> expectedParams) {
            ArrayList constraints = ContainerUtil.newArrayList();
            for (Pair<PsiParameter, PsiType> pair : expectedParams) {
                PsiType type = (PsiType)pair.second;
                if (type == null) continue;
                constraints.add(SubtypeConstraint.create(type));
                if (!(type instanceof PsiArrayType) || !((PsiParameter)pair.first).isVarArgs()) continue;
                constraints.add(SubtypeConstraint.create(((PsiArrayType)type).getComponentType()));
            }
            if (!constraints.isEmpty()) {
                this.myResult = constraints.toArray(TypeConstraint.EMPTY_ARRAY);
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            PsiType otherType;
            if (expression == null) {
                MyCalculator.$$$reportNull$$$0(19);
            }
            IElementType type = expression.getOperationTokenType();
            GrExpression left = expression.getLeftOperand();
            GrExpression right = expression.getRightOperand();
            GrExpression other = this.myExpression == left ? right : left;
            PsiType psiType = otherType = other != null ? other.getType() : null;
            if (otherType == null) {
                return;
            }
            GroovyResolveResult[] callVariants = expression.multiResolve(true);
            if (this.myExpression == left || callVariants.length == 0) {
                if (type == GroovyTokenTypes.mPLUS && otherType.equalsToText("java.lang.String")) {
                    PsiClassType obj = TypesUtil.getJavaLangObject(expression);
                    this.myResult = MyCalculator.createSimpleSubTypeResult((PsiType)obj);
                } else if (type == GroovyTokenTypes.mREGEX_FIND || type == GroovyTokenTypes.mREGEX_MATCH) {
                    PsiClassType string = TypesUtil.createType("java.lang.String", expression);
                    this.myResult = MyCalculator.createSimpleSubTypeResult((PsiType)string);
                } else {
                    this.myResult = MyCalculator.createSimpleSubTypeResult(otherType);
                }
            } else {
                this.processCallVariants(expression, callVariants, GrNamedArgument.EMPTY_ARRAY, new GrExpression[]{this.myExpression}, GrClosableBlock.EMPTY_ARRAY);
            }
        }

        @Override
        public void visitInstanceofExpression(@NotNull GrInstanceOfExpression expression) {
            if (expression == null) {
                MyCalculator.$$$reportNull$$$0(20);
            }
            GrExpression operand = expression.getOperand();
            GrTypeElement typeElement = expression.getTypeElement();
            if (typeElement == null) {
                return;
            }
            if (this.myExpression == operand) {
                PsiType type = typeElement.getType();
                this.myResult = new TypeConstraint[]{new SupertypeConstraint(type, type)};
            }
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
            PsiType rType;
            if (expression == null) {
                MyCalculator.$$$reportNull$$$0(21);
            }
            GrExpression rValue = expression.getRValue();
            GrExpression lValue = expression.getLValue();
            if (this.myExpression.equals(rValue)) {
                PsiType type;
                GroovyResolveResult result2;
                PsiElement resolved;
                PsiType lType = lValue.getNominalType();
                if (lType != null) {
                    this.myResult = new TypeConstraint[]{SubtypeConstraint.create(lType)};
                } else if (lValue instanceof GrReferenceExpression && (resolved = (result2 = ((GrReferenceExpression)lValue).advancedResolve()).getElement()) instanceof GrVariable && (type = ((GrVariable)resolved).getTypeGroovy()) != null) {
                    this.myResult = new TypeConstraint[]{SubtypeConstraint.create(result2.getSubstitutor().substitute(type))};
                }
            } else if (this.myExpression.equals(lValue) && rValue != null && (rType = rValue.getType()) != null) {
                this.myResult = new TypeConstraint[]{SupertypeConstraint.create(rType)};
            }
        }

        @Override
        public void visitThrowStatement(@NotNull GrThrowStatement throwStatement) {
            if (throwStatement == null) {
                MyCalculator.$$$reportNull$$$0(22);
            }
            PsiClassType throwable = PsiType.getJavaLangThrowable((PsiManager)this.myExpression.getManager(), (GlobalSearchScope)throwStatement.getResolveScope());
            this.myResult = new TypeConstraint[]{SubtypeConstraint.create((PsiType)throwable)};
        }

        @Override
        public void visitUnaryExpression(final @NotNull GrUnaryExpression expression) {
            if (expression == null) {
                MyCalculator.$$$reportNull$$$0(23);
            }
            TypeConstraint constraint = new TypeConstraint((PsiType)PsiType.INT){

                @Override
                public boolean satisfied(PsiType type, @NotNull PsiElement context) {
                    if (context == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    PsiType boxed = TypesUtil.boxPrimitiveType(type, context.getManager(), context.getResolveScope());
                    IElementType opToken = expression.getOperationTokenType();
                    GrExpression operand = expression.getOperand();
                    GroovyResolveResult[] candidates = TypesUtil.getOverloadedUnaryOperatorCandidates(boxed, opToken, operand != null ? operand : expression, PsiType.EMPTY_ARRAY);
                    return candidates.length > 0;
                }

                @Override
                @NotNull
                public PsiType getDefaultType() {
                    PsiPrimitiveType psiPrimitiveType = PsiType.INT;
                    if (psiPrimitiveType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return psiPrimitiveType;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/GroovyExpectedTypesProvider$MyCalculator$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/GroovyExpectedTypesProvider$MyCalculator$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDefaultType";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "satisfied";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.myResult = new TypeConstraint[]{constraint};
        }

        @Override
        public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
            PsiElement parent;
            if (expression == null) {
                MyCalculator.$$$reportNull$$$0(24);
            }
            if ((parent = expression.getParent()) instanceof GroovyPsiElement) {
                ((GroovyPsiElement)parent).accept(this);
            } else {
                parent.accept((PsiElementVisitor)new GroovyPsiElementVisitor(this));
            }
        }

        @Override
        public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
            if (listOrMap == null) {
                MyCalculator.$$$reportNull$$$0(25);
            }
            if (listOrMap.isMap()) {
                return;
            }
            TypeConstraint[] constraints = GroovyExpectedTypesProvider.calculateTypeConstraints(listOrMap);
            ArrayList<PsiType> result2 = new ArrayList<PsiType>(constraints.length);
            for (TypeConstraint constraint : constraints) {
                PsiType type;
                PsiType iterable;
                if (!(constraint instanceof SubtypeConstraint) || (iterable = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)(type = constraint.getType()), (boolean)true)) == null) continue;
                result2.add(iterable);
            }
            if (result2.isEmpty()) {
                this.myResult = TypeConstraint.EMPTY_ARRAY;
            } else {
                this.myResult = new TypeConstraint[result2.size()];
                for (int i = 0; i < result2.size(); ++i) {
                    PsiType type = (PsiType)result2.get(i);
                    if (type == null) continue;
                    this.myResult[i] = SubtypeConstraint.create(type);
                }
            }
        }

        @Override
        public void visitCaseLabel(@NotNull GrCaseLabel caseLabel) {
            PsiElement parent;
            if (caseLabel == null) {
                MyCalculator.$$$reportNull$$$0(26);
            }
            if (!((parent = caseLabel.getParent().getParent()) instanceof GrSwitchStatement)) {
                return;
            }
            GrExpression condition = ((GrSwitchStatement)parent).getCondition();
            if (condition == null) {
                return;
            }
            PsiType type = condition.getType();
            if (type == null) {
                return;
            }
            this.myResult = new TypeConstraint[]{SubtypeConstraint.create(type)};
        }

        @Override
        public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
            if (switchStatement == null) {
                MyCalculator.$$$reportNull$$$0(27);
            }
            GrCaseSection[] sections = switchStatement.getCaseSections();
            ArrayList<PsiType> types = new ArrayList<PsiType>(sections.length);
            for (GrCaseSection section : sections) {
                for (GrCaseLabel label : section.getCaseLabels()) {
                    PsiType type;
                    GrExpression value = label.getValue();
                    if (value == null || (type = value.getType()) == null) continue;
                    types.add(type);
                }
            }
            PsiType upperBoundNullable = TypesUtil.getLeastUpperBoundNullable(types, switchStatement.getManager());
            if (upperBoundNullable == null) {
                return;
            }
            this.myResult = new TypeConstraint[]{SubtypeConstraint.create(upperBoundNullable)};
        }

        public TypeConstraint[] getResult() {
            return this.myResult;
        }

        static /* synthetic */ TypeConstraint[] access$102(MyCalculator x0, TypeConstraint[] x1) {
            x0.myResult = x1;
            return x1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCall";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayInitializer";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameValuePair";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/GroovyExpectedTypesProvider$MyCalculator";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "whileStatement";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forClause";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variants";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namedArguments";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionArguments";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closureArguments";
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 23: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "throwStatement";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listOrMap";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caseLabel";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/GroovyExpectedTypesProvider$MyCalculator";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSimpleSubTypeResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReturnStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitVariable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitNamedArgument";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMethodCallExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitOpenBlock";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitIfStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAnnotationMethod";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAnnotationArrayInitializer";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAnnotationNameValuePair";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createSimpleSubTypeResult";
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWhileStatement";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTraditionalForClause";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArgumentList";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "processCallVariants";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "visitBinaryExpression";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "visitInstanceofExpression";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAssignmentExpression";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "visitThrowStatement";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "visitUnaryExpression";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "visitParenthesizedExpression";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "visitListOrMap";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "visitCaseLabel";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSwitchStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

