/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrPsiTypeStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

public class GroovyPsiManager {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager");
    private static final Set<String> ourPopularClasses = ContainerUtil.newHashSet((Object[])new String[]{"groovy.lang.Closure", "groovy.lang.GroovyObject", "groovy.lang.GroovyObjectSupport", "groovy.lang.Script", "java.util.List", "java.util.Collection", "java.lang.String"});
    private final Project myProject;
    private final Map<String, GrTypeDefinition> myArrayClass = new HashMap<String, GrTypeDefinition>();
    private final ConcurrentMap<GroovyPsiElement, PsiType> myCalculatedTypes = ContainerUtil.createConcurrentWeakMap();
    private final ConcurrentMap<GrExpression, PsiType> topLevelTypes = ContainerUtil.createConcurrentWeakMap();
    private final ConcurrentMap<PsiMember, Boolean> myCompileStatic = ContainerUtil.createConcurrentWeakMap();
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"groovyPsiManager");
    private static final PsiType UNKNOWN_TYPE = new GrPsiTypeStub();

    public GroovyPsiManager(Project project) {
        this.myProject = project;
        PsiManagerEx.getInstanceEx((Project)this.myProject).registerRunnableToRunOnAnyChange(() -> this.dropTypesCache());
    }

    public void dropTypesCache() {
        this.myCalculatedTypes.clear();
        this.topLevelTypes.clear();
        this.myCompileStatic.clear();
    }

    public static GroovyPsiManager getInstance(Project project) {
        return (GroovyPsiManager)ServiceManager.getService((Project)project, GroovyPsiManager.class);
    }

    public PsiClassType createTypeByFQClassName(@NotNull String fqName, @NotNull GlobalSearchScope resolveScope) {
        PsiClass result2;
        if (fqName == null) {
            GroovyPsiManager.$$$reportNull$$$0(0);
        }
        if (resolveScope == null) {
            GroovyPsiManager.$$$reportNull$$$0(1);
        }
        if (ourPopularClasses.contains(fqName) && (result2 = JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqName, resolveScope)) != null) {
            return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(result2);
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(fqName, resolveScope);
    }

    public boolean isCompileStatic(@NotNull PsiMember member) {
        Boolean aBoolean;
        if (member == null) {
            GroovyPsiManager.$$$reportNull$$$0(2);
        }
        if ((aBoolean = (Boolean)this.myCompileStatic.get(member)) == null) {
            aBoolean = (Boolean)ConcurrencyUtil.cacheOrGet(this.myCompileStatic, (Object)member, (Object)this.isCompileStaticInner(member));
        }
        return aBoolean;
    }

    private boolean isCompileStaticInner(@NotNull PsiMember member) {
        PsiClass aClass;
        PsiModifierList list;
        if (member == null) {
            GroovyPsiManager.$$$reportNull$$$0(3);
        }
        if ((list = member.getModifierList()) != null) {
            PsiAnnotation compileStatic = list.findAnnotation("groovy.transform.CompileStatic");
            if (compileStatic != null) {
                return GroovyPsiManager.checkForPass(compileStatic);
            }
            PsiAnnotation typeChecked = list.findAnnotation("groovy.transform.TypeChecked");
            if (typeChecked != null) {
                return GroovyPsiManager.checkForPass(typeChecked);
            }
        }
        if ((aClass = member.getContainingClass()) != null) {
            return this.isCompileStatic((PsiMember)aClass);
        }
        return false;
    }

    private static boolean checkForPass(@NotNull PsiAnnotation annotation) {
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            GroovyPsiManager.$$$reportNull$$$0(4);
        }
        return (value = annotation.findAttributeValue("value")) == null || value instanceof PsiReference && ResolveUtil.isEnumConstant((PsiReference)value, "PASS", "groovy.transform.TypeCheckingMode");
    }

    @Deprecated
    @Nullable
    public PsiClass findClassWithCache(@NotNull String fqName, @NotNull GlobalSearchScope resolveScope) {
        if (fqName == null) {
            GroovyPsiManager.$$$reportNull$$$0(5);
        }
        if (resolveScope == null) {
            GroovyPsiManager.$$$reportNull$$$0(6);
        }
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqName, resolveScope);
    }

    @Nullable
    public <T extends GroovyPsiElement> PsiType getType(@NotNull T element, @NotNull Function<? super T, ? extends PsiType> calculator) {
        if (element == null) {
            GroovyPsiManager.$$$reportNull$$$0(7);
        }
        if (calculator == null) {
            GroovyPsiManager.$$$reportNull$$$0(8);
        }
        return GroovyPsiManager.getTypeWithCaching(element, this.myCalculatedTypes, calculator);
    }

    @Nullable
    public PsiType getTopLevelType(@NotNull GrExpression expression) {
        if (expression == null) {
            GroovyPsiManager.$$$reportNull$$$0(9);
        }
        return GroovyPsiManager.getTypeWithCaching(expression, this.topLevelTypes, InferenceKt::getTopLevelType);
    }

    @Nullable
    private static <K extends GroovyPsiElement> PsiType getTypeWithCaching(@NotNull K key, @NotNull ConcurrentMap<? super K, PsiType> map2, @NotNull Function<? super K, ? extends PsiType> calculator) {
        PsiType type;
        if (key == null) {
            GroovyPsiManager.$$$reportNull$$$0(10);
        }
        if (map2 == null) {
            GroovyPsiManager.$$$reportNull$$$0(11);
        }
        if (calculator == null) {
            GroovyPsiManager.$$$reportNull$$$0(12);
        }
        if ((type = (PsiType)map2.get(key)) == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            type = (PsiType)calculator.fun(key);
            if (type == null) {
                type = UNKNOWN_TYPE;
            }
            if (stamp.mayCacheNow()) {
                type = (PsiType)ConcurrencyUtil.cacheOrGet(map2, key, (Object)type);
            } else {
                PsiType alreadyInferred = (PsiType)map2.get(key);
                if (alreadyInferred != null) {
                    type = alreadyInferred;
                }
            }
        }
        if (!type.isValid()) {
            GroovyPsiManager.error(key, type);
        }
        return UNKNOWN_TYPE == type ? null : type;
    }

    private static void error(PsiElement element, PsiType type) {
        LOG.error("Type is invalid: " + type + "; element: " + element + " of class " + element.getClass());
    }

    @Nullable
    public GrTypeDefinition getArrayClass(@NotNull PsiType type) {
        String typeText;
        GrTypeDefinition definition;
        if (type == null) {
            GroovyPsiManager.$$$reportNull$$$0(13);
        }
        if ((definition = this.myArrayClass.get(typeText = type.getCanonicalText())) == null) {
            try {
                definition = GroovyPsiElementFactory.getInstance(this.myProject).createTypeDefinition("class __ARRAY__ { public int length; public " + typeText + "[] clone(){} }");
                this.myArrayClass.put(typeText, definition);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return definition;
    }

    @Nullable
    public static PsiType inferType(@NotNull PsiElement element, @NotNull Computable<? extends PsiType> computable) {
        List stack;
        if (element == null) {
            GroovyPsiManager.$$$reportNull$$$0(14);
        }
        if (computable == null) {
            GroovyPsiManager.$$$reportNull$$$0(15);
        }
        if ((stack = ourGuard.currentStack()).size() > 7) {
            ourGuard.prohibitResultCaching(stack.get(0));
            return null;
        }
        return (PsiType)ourGuard.doPreventingRecursion((Object)element, true, computable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeByFQClassName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompileStatic";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompileStaticInner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForPass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findClassWithCache";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getTopLevelType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeWithCaching";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "inferType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

