/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrUnaryExpressionImpl
extends GrExpressionImpl
implements GrUnaryExpression {
    private static final Function<GrUnaryExpressionImpl, PsiType> TYPE_CALCULATOR = new Function<GrUnaryExpressionImpl, PsiType>(){

        @Nullable
        public PsiType fun(GrUnaryExpressionImpl unary) {
            GroovyResolveResult resolveResult = PsiImplUtil.extractUniqueResult(unary.multiResolve(false));
            if (this.isIncDecNumber(resolveResult)) {
                return unary.getOperand().getType();
            }
            PsiType substituted = ResolveUtil.extractReturnTypeFromCandidate(resolveResult, unary, PsiType.EMPTY_ARRAY);
            if (substituted != null) {
                return substituted;
            }
            GrExpression operand = unary.getOperand();
            if (operand == null) {
                return null;
            }
            PsiType type = operand.getType();
            if (TypesUtil.isNumericType(type)) {
                return type;
            }
            return null;
        }

        private boolean isIncDecNumber(GroovyResolveResult result2) {
            PsiElement element = result2.getElement();
            if (!(element instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = element instanceof GrGdkMethod ? ((GrGdkMethod)element).getStaticMethod() : (PsiMethod)element;
            String name = method.getName();
            if (!"next".equals(name) && !"previous".equals(name)) {
                return false;
            }
            if (!PsiUtil.isDGMMethod((PsiElement)method)) {
                return false;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1) {
                return false;
            }
            return parameters[0].getType().equalsToText("java.lang.Number");
        }
    };
    private static final ResolveCache.PolyVariantResolver<GrUnaryExpressionImpl> OUR_RESOLVER = (unary, incompleteCode) -> {
        GrExpression operand = unary.getOperand();
        if (operand == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        PsiType type = operand.getType();
        if (type == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return TypesUtil.getOverloadedUnaryOperatorCandidates(type, unary.getOperationTokenType(), operand, PsiType.EMPTY_ARRAY);
    };

    public GrUnaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "Unary expression";
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPE_CALCULATOR);
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        PsiElement opElement = this.getOperationToken();
        ASTNode node = opElement.getNode();
        assert (node != null);
        IElementType iElementType = node.getElementType();
        if (iElementType == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(1);
        }
        return iElementType;
    }

    @Override
    @NotNull
    public PsiElement getOperationToken() {
        PsiElement opElement = this.findChildByType(TokenSets.UNARY_OP_SET);
        assert (opElement != null);
        PsiElement psiElement = opElement;
        if (psiElement == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Override
    public GrExpression getOperand() {
        return GrUnaryExpressionImpl.findExpressionChild(this);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(3);
        }
        visitor2.visitUnaryExpression(this);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult[] groovyResolveResultArray = TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, OUR_RESOLVER);
        if (groovyResolveResultArray == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(4);
        }
        return groovyResolveResultArray;
    }

    @Override
    public boolean isPostfix() {
        return this.getFirstChild() instanceof GrExpression;
    }

    @NotNull
    public PsiElement getElement() {
        GrUnaryExpressionImpl grUnaryExpressionImpl = this;
        if (grUnaryExpressionImpl == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(5);
        }
        return grUnaryExpressionImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement opToken = this.getOperationToken();
        int offset = opToken.getStartOffsetInParent();
        TextRange textRange = new TextRange(offset, offset + opToken.getTextLength());
        if (textRange == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(8);
        }
        throw new IncorrectOperationException("unary expression cannot be renamed to anything");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(9);
        }
        throw new IncorrectOperationException("unary expression cannot be bounded to anything");
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(10);
        }
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    public boolean isSoft() {
        return false;
    }

    public PsiReference getReference() {
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/arithmetic/GrUnaryExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/arithmetic/GrUnaryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationTokenType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationToken";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

