/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.BaseGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.MethodResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DynamicMembersHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

public abstract class GroovyResolverProcessor
implements PsiScopeProcessor,
ElementClassHint,
NameHint,
DynamicMembersHint,
MultiProcessor {
    @NotNull
    protected final GrReferenceExpression myRef;
    @NotNull
    private final String myName;
    @NotNull
    protected final EnumSet<GroovyResolveKind> myAcceptableKinds;
    private final boolean myIsLValue;
    @NotNull
    protected final PsiType[] myTypeArguments;
    @NotNull
    protected final NullableLazyValue<PsiType[]> myArgumentTypes;
    protected final List<GrResolverProcessor<? extends GroovyResolveResult>> myAccessorProcessors;
    protected final MultiMap<GroovyResolveKind, GroovyResolveResult> myCandidates;
    private boolean myCheckValidMethods;
    private boolean myStopExecutingMethods;

    GroovyResolverProcessor(@NotNull GrReferenceExpression ref, @NotNull EnumSet<GroovyResolveKind> kinds, boolean forceRValue) {
        if (ref == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(0);
        }
        if (kinds == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(1);
        }
        this.myCandidates = MultiMap.create();
        this.myCheckValidMethods = false;
        this.myStopExecutingMethods = false;
        this.myRef = ref;
        this.myAcceptableKinds = kinds;
        this.myName = GroovyResolverProcessor.getReferenceName(ref);
        this.myIsLValue = !forceRValue && PsiUtil.isLValue(this.myRef);
        this.myTypeArguments = ref.getTypeArguments();
        this.myArgumentTypes = kinds.contains((Object)GroovyResolveKind.METHOD) || this.myIsLValue ? NullableLazyValue.createValue(() -> InferenceKt.buildTopLevelArgumentTypes(this.myRef)) : NullableLazyValue.createValue(() -> null);
        this.myAccessorProcessors = this.calcAccessorProcessors();
    }

    private List<GrResolverProcessor<? extends GroovyResolveResult>> calcAccessorProcessors() {
        if (!this.isPropertyResolve() || !PropertyUtilKt.isPropertyName(this.myName)) {
            return Collections.emptyList();
        }
        Lazy receiverType = LazyKt.lazy(() -> this.getTopLevelQualifierType());
        if (this.myIsLValue) {
            return Collections.singletonList(new PropertyProcessor((Lazy<? extends PsiType>)receiverType, this.myName, PropertyKind.SETTER, (Function0<PsiType[]>)((Function0)() -> (PsiType[])this.myArgumentTypes.getValue()), (PsiElement)this.myRef));
        }
        return ContainerUtil.newArrayList((Object[])new GrResolverProcessor[]{new PropertyProcessor((Lazy<? extends PsiType>)receiverType, this.myName, PropertyKind.GETTER, (Function0<PsiType[]>)((Function0)() -> PsiType.EMPTY_ARRAY), (PsiElement)this.myRef), new PropertyProcessor((Lazy<? extends PsiType>)receiverType, this.myName, PropertyKind.BOOLEAN_GETTER, (Function0<PsiType[]>)((Function0)() -> PsiType.EMPTY_ARRAY), (PsiElement)this.myRef)});
    }

    public PsiType getTopLevelQualifierType() {
        GrExpression expression = this.myRef.getQualifierExpression();
        if (expression instanceof GrMethodCallExpression) {
            return InferenceKt.getTopLevelTypeCached(expression);
        }
        return PsiImplUtil.getQualifierType(this.myRef);
    }

    public boolean isPropertyResolve() {
        return this.myAcceptableKinds.contains((Object)GroovyResolveKind.PROPERTY);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiNamedElement)) {
            return true;
        }
        PsiNamedElement namedElement = (PsiNamedElement)element;
        String name = ResolveUtilKt.getName(state, namedElement);
        if (!this.myName.equals(name)) {
            return true;
        }
        GroovyResolveKind kind = GroovyResolverProcessor.getResolveKind(namedElement);
        if (!this.myAcceptableKinds.contains((Object)kind)) {
            return true;
        }
        if (kind == GroovyResolveKind.METHOD) {
            if (this.myStopExecutingMethods) {
                return true;
            }
            if (this.myCheckValidMethods) {
                this.myCheckValidMethods = false;
                if (!ResolveUtilKt.valid(this.myCandidates.get((Object)GroovyResolveKind.METHOD)).isEmpty()) {
                    this.myStopExecutingMethods = true;
                    return true;
                }
            }
        } else if (!this.myCandidates.get((Object)kind).isEmpty()) {
            return true;
        }
        MethodResolveResult candidate = kind == GroovyResolveKind.METHOD ? new MethodResolveResult((PsiMethod)namedElement, this.myRef, state) : new BaseGroovyResolveResult(namedElement, this.myRef, state);
        this.myCandidates.putValue((Object)kind, (Object)candidate);
        if (kind == GroovyResolveKind.VARIABLE && candidate.isValidResult()) {
            this.myStopExecutingMethods = true;
        }
        return true;
    }

    @Nullable
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(4);
        }
        if (hintKey == ElementClassHint.KEY || hintKey == NameHint.KEY || hintKey == DynamicMembersHint.KEY) {
            return (T)this;
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
        if (event == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(5);
        }
        if (JavaScopeProcessorEvent.CHANGE_LEVEL == event) {
            this.myCheckValidMethods = true;
        }
    }

    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        if (kind == ElementClassHint.DeclarationKind.METHOD) {
            if (this.myStopExecutingMethods) {
                return false;
            }
            if (this.isPropertyResolve() && !this.myAcceptableKinds.contains((Object)GroovyResolveKind.METHOD)) {
                return false;
            }
        }
        for (GroovyResolveKind resolveKind : this.myAcceptableKinds) {
            if (!resolveKind.declarationKinds.contains(kind)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(6);
        }
        String string = this.myName;
        if (string == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean shouldProcessMethods() {
        return this.myRef.getParent() instanceof GrCallExpression && !this.myCandidates.containsKey((Object)GroovyResolveKind.METHOD);
    }

    @Override
    public boolean shouldProcessProperties() {
        return true;
    }

    @Override
    @NotNull
    public Collection<? extends PsiScopeProcessor> getProcessors() {
        List list = this.myStopExecutingMethods ? Collections.singletonList(this) : ContainerUtil.concat(Collections.singletonList(this), this.myAccessorProcessors);
        if (list == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public abstract List<GroovyResolveResult> getCandidates();

    public final GroovyResolveResult[] getCandidatesArray() {
        List<GroovyResolveResult> candidates = this.getCandidates();
        int size = candidates.size();
        if (size == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (size == 1) {
            return new GroovyResolveResult[]{candidates.get(0)};
        }
        return candidates.toArray(new GroovyResolveResult[size]);
    }

    private static GroovyResolveKind getResolveKind(PsiNamedElement element) {
        if (element instanceof PsiClass) {
            return GroovyResolveKind.CLASS;
        }
        if (element instanceof PsiPackage) {
            return GroovyResolveKind.PACKAGE;
        }
        if (element instanceof PsiMethod) {
            return GroovyResolveKind.METHOD;
        }
        if (element instanceof PsiField) {
            return GroovyResolveKind.FIELD;
        }
        if (element instanceof GrBindingVariable) {
            return GroovyResolveKind.BINDING;
        }
        if (element instanceof PsiVariable) {
            return GroovyResolveKind.VARIABLE;
        }
        return null;
    }

    @NotNull
    protected List<GroovyResolveResult> getAllCandidates(@NotNull GroovyResolveKind kind) {
        if (kind == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(9);
        }
        if (kind == GroovyResolveKind.PROPERTY) {
            List results = ContainerUtil.newSmartList();
            this.myAccessorProcessors.forEach(it -> results.addAll(it.getResults()));
            List list = results;
            if (list == null) {
                GroovyResolverProcessor.$$$reportNull$$$0(10);
            }
            return list;
        }
        SmartList smartList = new SmartList(this.myCandidates.get((Object)kind));
        if (smartList == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    @NotNull
    protected List<GroovyResolveResult> getCandidates(@NotNull GroovyResolveKind kind) {
        if (kind == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(12);
        }
        List<GroovyResolveResult> list = ResolveUtilKt.singleOrValid(this.getAllCandidates(kind));
        if (list == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    protected static PsiSubstitutor getSubstitutor(@NotNull ResolveState state) {
        PsiSubstitutor substitutor;
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(14);
        }
        if ((substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY)) == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(15);
        }
        return psiSubstitutor;
    }

    @NotNull
    private static String getReferenceName(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(16);
        }
        String name = ref.getReferenceName();
        assert (name != null) : "Reference name cannot be null";
        String string = name;
        if (string == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessors";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCandidates";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllCandidates";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

