/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.MethodCandidate;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001b\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\r\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010\u001a/\u0010\u0012\u001a\u00020\u0013*\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u000b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"buildArguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/Argument;", "place", "Lcom/intellij/psi/PsiElement;", "buildQualifier", "ref", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "state", "Lcom/intellij/psi/ResolveState;", "buildTopLevelArgumentTypes", "", "Lcom/intellij/psi/PsiType;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiType;", "getTopLevelType", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "getTopLevelTypeCached", "putAll", "Lcom/intellij/psi/PsiSubstitutor;", "parameters", "Lcom/intellij/psi/PsiTypeParameter;", "arguments", "(Lcom/intellij/psi/PsiSubstitutor;[Lcom/intellij/psi/PsiTypeParameter;[Lcom/intellij/psi/PsiType;)Lcom/intellij/psi/PsiSubstitutor;", "intellij.groovy.psi"})
public final class InferenceKt {
    @Nullable
    public static final PsiType getTopLevelType(@NotNull GrExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (expression instanceof GrMethodCall) {
            Object object;
            GroovyResolveResult groovyResolveResult = ((GrMethodCall)expression).advancedResolve();
            Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"expression.advancedResolve()");
            GroovyResolveResult resolved = groovyResolveResult;
            GroovyResolveResult groovyResolveResult2 = resolved;
            if (!(groovyResolveResult2 instanceof GroovyMethodResult)) {
                groovyResolveResult2 = null;
            }
            if ((object = (GroovyMethodResult)groovyResolveResult2) != null && (object = object.getCandidate()) != null) {
                Object object2;
                Object it = object2 = object;
                GrExpression grExpression = ((GrMethodCall)expression).getInvokedExpression();
                if (grExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression");
                }
                GrReferenceExpression grReferenceExpression = (GrReferenceExpression)grExpression;
                Object object3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                GroovyInferenceSession session = new GroovyInferenceSessionBuilder(grReferenceExpression, (MethodCandidate)object3).resolveMode(false).build();
                return session.inferSubst().substitute(PsiUtil.getSmartReturnType(((MethodCandidate)it).getMethod()));
            }
        }
        if (expression instanceof GrClosableBlock) {
            return (PsiType)TypesUtil.createTypeByFQClassName("groovy.lang.Closure", expression);
        }
        return expression.getType();
    }

    @Nullable
    public static final PsiType getTopLevelTypeCached(@NotNull GrExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        return GroovyPsiManager.getInstance(expression.getProject()).getTopLevelType(expression);
    }

    @NotNull
    public static final Argument buildQualifier(@NotNull GrReferenceExpression ref, @NotNull ResolveState state) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        GrExpression qualifierExpression = ref.getQualifierExpression();
        SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
        if (qualifierExpression != null && spreadState == null) {
            return new Argument(null, qualifierExpression);
        }
        PsiType resolvedThis = (PsiType)state.get(ClassHint.THIS_TYPE);
        if (resolvedThis != null) {
            return new Argument(resolvedThis, null);
        }
        PsiType type = PsiImplUtil.getQualifierType(ref);
        if (spreadState == null) {
            return new Argument(type, null);
        }
        if (type == null) {
            return new Argument(null, null);
        }
        return new Argument(com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false), null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Argument> buildArguments(@NotNull PsiElement place) {
        void $receiver$iv$iv;
        PsiType[] argumentTypes;
        PsiType[] $receiver$iv;
        PsiElement parent;
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        PsiElement psiElement = place;
        if (!(psiElement instanceof GrEnumConstant)) {
            psiElement = null;
        }
        GrEnumConstant grEnumConstant = (GrEnumConstant)psiElement;
        PsiElement psiElement2 = parent = grEnumConstant != null ? (PsiElement)grEnumConstant : place.getParent();
        if (parent instanceof GrCall) {
            Collection<Argument> collection;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            ArrayList<Argument> result2 = new ArrayList<Argument>();
            GrNamedArgument[] grNamedArgumentArray = ((GrCall)parent).getNamedArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)grNamedArgumentArray, (String)"parent.namedArguments");
            GrNamedArgument[] namedArgs = grNamedArgumentArray;
            Object[] objectArray = ((GrCall)parent).getExpressionArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"parent.expressionArguments");
            Object[] expressions = objectArray;
            Object[] objectArray2 = ((GrCall)parent).getClosureArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"parent.closureArguments");
            Object[] closures = objectArray2;
            GrNamedArgument[] grNamedArgumentArray2 = namedArgs;
            GroovyPsiElement[] groovyPsiElementArray = grNamedArgumentArray2;
            if (!(groovyPsiElementArray.length == 0)) {
                GrNamedArgument context = namedArgs[0];
                result2.add(new Argument((PsiType)GrMapType.createFromNamedArgs(context, namedArgs), null));
            }
            Object[] objectArray3 = ArrayUtil.mergeArrays((Object[])expressions, (Object[])closures);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray3, (String)"ArrayUtil.mergeArrays(expressions, closures)");
            GrExpression[] argExp = (GrExpression[])objectArray3;
            groovyPsiElementArray = argExp;
            ArrayList<Argument> arrayList = result2;
            void var8_16 = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList(((void)$receiver$iv2).length);
            void var10_20 = $receiver$iv$iv2;
            int n = ((void)var10_20).length;
            for (int i = 0; i < n; ++i) {
                void exp;
                void item$iv$iv;
                void var14_25 = item$iv$iv = var10_20[i];
                collection = destination$iv$iv;
                Argument argument = new Argument(null, (GrExpression)exp);
                collection.add(argument);
            }
            collection = (List)destination$iv$iv;
            arrayList.addAll(collection);
            return result2;
        }
        PsiType[] psiTypeArray = PsiUtil.getArgumentTypes(place, false, null);
        if (psiTypeArray == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"PsiUtil.getArgumentTypes\u2026ll) ?: return emptyList()");
        PsiType[] expressions = $receiver$iv = (argumentTypes = psiTypeArray);
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        void var6_11 = $receiver$iv$iv;
        int n = ((void)var6_11).length;
        for (int i = 0; i < n; ++i) {
            void t;
            void item$iv$iv;
            void var10_21 = item$iv$iv = var6_11[i];
            Collection collection = destination$iv$iv;
            Argument argument = new Argument((PsiType)t, null);
            collection.add(argument);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiType[] buildTopLevelArgumentTypes(@NotNull PsiElement place) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Iterable iterable = $receiver$iv = (Iterable)InferenceKt.buildArguments(place);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void $type_expression;
            Argument argument = (Argument)item$iv$iv;
            Collection collection = destination$iv$iv;
            PsiType type = $type_expression.component1();
            GrExpression expression = $type_expression.component2();
            PsiType psiType = expression != null ? InferenceKt.getTopLevelTypeCached(expression) : (type instanceof GrMapType ? (PsiType)TypesUtil.createTypeByFQClassName("java.util.Map", place) : type);
            collection.add(psiType);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv;
        PsiType[] psiTypeArray = thisCollection$iv.toArray(new PsiType[0]);
        if (psiTypeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiTypeArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiSubstitutor putAll(@NotNull PsiSubstitutor $receiver, @NotNull PsiTypeParameter[] parameters, @NotNull PsiType[] arguments) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (arguments.length != parameters.length) {
            return $receiver;
        }
        Iterable $receiver$iv = ArraysKt.zip((Object[])parameters, (Object[])arguments);
        PsiSubstitutor accumulator$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            void $param_arg;
            Pair pair = (Pair)element$iv;
            PsiSubstitutor acc = accumulator$iv;
            PsiTypeParameter param = (PsiTypeParameter)$param_arg.component1();
            PsiType arg = (PsiType)$param_arg.component2();
            Intrinsics.checkExpressionValueIsNotNull((Object)acc.put(param, arg), (String)"acc.put(param, arg)");
        }
        return accumulator$iv;
    }
}

