/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.memberPullUp.JavaPullUpHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureHandler;
import org.jetbrains.plugins.groovy.refactoring.extract.method.GroovyExtractMethodHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrIntroduceVariableHandler;

public class GroovyRefactoringSupportProvider
extends RefactoringSupportProvider {
    public static final GroovyRefactoringSupportProvider INSTANCE = new GroovyRefactoringSupportProvider();

    public boolean isSafeDeleteAvailable(@NotNull PsiElement element) {
        if (element == null) {
            GroovyRefactoringSupportProvider.$$$reportNull$$$0(0);
        }
        return element instanceof GrTypeDefinition || element instanceof GrField || element instanceof GrMethod;
    }

    @Nullable
    public RefactoringActionHandler getIntroduceVariableHandler() {
        return new GrIntroduceVariableHandler();
    }

    @Nullable
    public RefactoringActionHandler getExtractMethodHandler() {
        return new GroovyExtractMethodHandler();
    }

    public ChangeSignatureHandler getChangeSignatureHandler() {
        return new GrChangeSignatureHandler();
    }

    public boolean isInplaceRenameAvailable(@NotNull PsiElement elementToRename, PsiElement nameSuggestionContext) {
        if (elementToRename == null) {
            GroovyRefactoringSupportProvider.$$$reportNull$$$0(1);
        }
        if (nameSuggestionContext != null && nameSuggestionContext.getContainingFile() != elementToRename.getContainingFile()) {
            return false;
        }
        if (!(elementToRename instanceof GrLabeledStatement)) {
            return false;
        }
        SearchScope useScope = PsiSearchHelper.getInstance((Project)elementToRename.getProject()).getUseScope(elementToRename);
        if (!(useScope instanceof LocalSearchScope)) {
            return false;
        }
        PsiElement[] scopeElements = ((LocalSearchScope)useScope).getScope();
        if (scopeElements.length > 1) {
            return false;
        }
        PsiFile containingFile = elementToRename.getContainingFile();
        return PsiTreeUtil.isAncestor((PsiElement)containingFile, (PsiElement)scopeElements[0], (boolean)false);
    }

    public boolean isInplaceIntroduceAvailable(@NotNull PsiElement element, PsiElement context) {
        if (element == null) {
            GroovyRefactoringSupportProvider.$$$reportNull$$$0(2);
        }
        return context != null && context.getContainingFile() == element.getContainingFile();
    }

    public boolean isMemberInplaceRenameAvailable(@NotNull PsiElement element, @Nullable PsiElement context) {
        GroovyResolveResult result2;
        PsiElement fileResolveContext;
        if (element == null) {
            GroovyRefactoringSupportProvider.$$$reportNull$$$0(3);
        }
        if (context == null || context.getContainingFile() instanceof GroovyFile) {
            return false;
        }
        PsiElement parent = context.getParent();
        if (parent instanceof GrReferenceElement && (fileResolveContext = (result2 = ((GrReferenceElement)parent).advancedResolve()).getCurrentFileResolveContext()) instanceof GrImportStatement && ((GrImportStatement)fileResolveContext).isAliasedImport()) {
            return false;
        }
        return element instanceof GrMember;
    }

    public RefactoringActionHandler getIntroduceFieldHandler() {
        return new GrIntroduceFieldHandler();
    }

    public RefactoringActionHandler getIntroduceParameterHandler() {
        return new GrIntroduceParameterHandler();
    }

    public RefactoringActionHandler getIntroduceConstantHandler() {
        return new GrIntroduceConstantHandler();
    }

    @Nullable
    public RefactoringActionHandler getPullUpHandler() {
        return new JavaPullUpHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringSupportProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSafeDeleteAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInplaceRenameAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInplaceIntroduceAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMemberInplaceRenameAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

