/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.lang.Language;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class BaseScriptTransformationSupport
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            BaseScriptTransformationSupport.$$$reportNull$$$0(0);
        }
        if (!(context.getCodeClass() instanceof GroovyScriptClass)) {
            return;
        }
        GroovyScriptClass scriptClass = (GroovyScriptClass)context.getCodeClass();
        LightMethodBuilder mainMethod = new LightMethodBuilder(scriptClass.getManager(), (Language)GroovyLanguage.INSTANCE, "main").setMethodReturnType((PsiType)PsiType.VOID).addParameter("args", (PsiType)new PsiArrayType((PsiType)PsiType.getJavaLangString((PsiManager)scriptClass.getManager(), (GlobalSearchScope)scriptClass.getResolveScope()))).addModifiers(new String[]{"public", "static"});
        LightMethodBuilder runMethod = new LightMethodBuilder(scriptClass.getManager(), (Language)GroovyLanguage.INSTANCE, "run").setMethodReturnType((PsiType)TypesUtil.getJavaLangObject(scriptClass)).addModifier("public");
        context.addMethod((PsiMethod)runMethod, true);
        context.addMethod((PsiMethod)mainMethod, true);
        context.setSuperType(BaseScriptTransformationSupport.getBaseClassType(scriptClass));
    }

    @NotNull
    private static PsiClassType getBaseClassType(@NotNull GroovyScriptClass scriptClass) {
        PsiClassType type;
        if (scriptClass == null) {
            BaseScriptTransformationSupport.$$$reportNull$$$0(1);
        }
        if ((type = BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotatedVariable(scriptClass)) != null) {
            PsiClassType psiClassType = type;
            if (psiClassType == null) {
                BaseScriptTransformationSupport.$$$reportNull$$$0(2);
            }
            return psiClassType;
        }
        PsiClassType superClassFromDSL = GroovyDslFileIndex.processScriptSuperClasses(scriptClass.getContainingFile());
        if (superClassFromDSL != null) {
            PsiClassType psiClassType = superClassFromDSL;
            if (psiClassType == null) {
                BaseScriptTransformationSupport.$$$reportNull$$$0(3);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = TypesUtil.createTypeByFQClassName("groovy.lang.Script", scriptClass);
        if (psiClassType == null) {
            BaseScriptTransformationSupport.$$$reportNull$$$0(4);
        }
        return psiClassType;
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotatedVariable(GroovyScriptClass scriptClass) {
        return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)scriptClass, () -> CachedValueProvider.Result.create((Object)BaseScriptTransformationSupport.doGetSuperClassType(scriptClass), (Object[])new Object[]{scriptClass.getContainingFile()}));
    }

    private static PsiClassType doGetSuperClassType(GroovyScriptClass scriptClass) {
        PsiType type;
        GrTypeElement typeElement;
        GrVariableDeclaration declaration = BaseScriptTransformationSupport.findDeclaration(scriptClass.getContainingFile());
        if (declaration != null && (typeElement = declaration.getTypeElementGroovy()) != null && (type = typeElement.getType()) instanceof PsiClassType) {
            return (PsiClassType)type;
        }
        return null;
    }

    @Nullable
    private static GrVariableDeclaration findDeclaration(GroovyFile file) {
        if (!GrFileIndexUtil.hasNameInFile(file, "BaseScript")) {
            return null;
        }
        for (GrVariableDeclaration declaration : file.getScriptDeclarations(false)) {
            if (!declaration.getModifierList().hasAnnotation("groovy.transform.BaseScript")) continue;
            return declaration;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/transformations/impl/BaseScriptTransformationSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/transformations/impl/BaseScriptTransformationSupport";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseClassType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyTransformation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBaseClassType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

