/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestTasksProvider;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public abstract class GradleTestRunConfigurationProducer
extends RunConfigurationProducer<ExternalSystemRunConfiguration> {
    private static final List<String> TEST_SOURCE_SET_TASKS = ContainerUtil.list((Object[])new String[]{"cleanTest", "test"});

    protected GradleTestRunConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.CHOOSE_PER_TEST || GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (other == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER;
    }

    protected boolean setupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        if (GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.PLATFORM_TEST_RUNNER) {
            return false;
        }
        if (configuration instanceof GradleRunConfiguration) {
            GradleRunConfiguration gradleRunConfiguration = (GradleRunConfiguration)configuration;
            gradleRunConfiguration.setScriptDebugEnabled(false);
        }
        return this.doSetupConfigurationFromContext(configuration, context, sourceElement);
    }

    protected abstract boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2, Ref<PsiElement> var3);

    public boolean isConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        if (GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.PLATFORM_TEST_RUNNER) {
            return false;
        }
        if (configuration == null) {
            return false;
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        return this.doIsConfigurationFromContext(configuration, context);
    }

    protected abstract boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2);

    @Nullable
    protected String resolveProjectPath(@NotNull Module module) {
        if (module == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        return GradleRunnerUtil.resolveProjectPath(module);
    }

    @NotNull
    public static List<String> getTasksToRun(@NotNull Module module) {
        String taskPrefix;
        if (module == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        for (GradleTestTasksProvider provider : (GradleTestTasksProvider[])GradleTestTasksProvider.EP_NAME.getExtensions()) {
            List<String> tasks = provider.getTasks(module);
            if (ContainerUtil.isEmpty(tasks)) continue;
            List<String> list = tasks;
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(4);
            }
            return list;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(5);
            }
            return list;
        }
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (projectPath == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(6);
            }
            return list;
        }
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)module.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
        if (externalProjectInfo == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(7);
            }
            return list;
        }
        String gradlePath = GradleProjectResolverUtil.getGradlePath((Module)module);
        if (gradlePath == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(8);
            }
            return list;
        }
        String string = taskPrefix = StringUtil.endsWithChar((CharSequence)gradlePath, (char)':') ? gradlePath : gradlePath + ':';
        if (StringUtil.endsWith((CharSequence)externalProjectId, (CharSequence)":test") || StringUtil.endsWith((CharSequence)externalProjectId, (CharSequence)":main")) {
            List list = ContainerUtil.map(TEST_SOURCE_SET_TASKS, task -> taskPrefix + task);
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(9);
            }
            return list;
        }
        DataNode moduleNode = GradleProjectResolverUtil.findModule((DataNode)externalProjectInfo.getExternalProjectStructure(), (String)projectPath);
        if (moduleNode == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(10);
            }
            return list;
        }
        String sourceSetId = StringUtil.substringAfter((String)externalProjectId, (String)(((ModuleData)moduleNode.getData()).getExternalName() + ':'));
        DataNode taskNode = sourceSetId == null ? ExternalSystemApiUtil.find((DataNode)moduleNode, (Key)ProjectKeys.TASK, node -> (((TaskData)node.getData()).isTest() || "org.gradle.api.tasks.testing.Test".equals(((TaskData)node.getData()).getType())) && StringUtil.equals((CharSequence)"test", (CharSequence)((TaskData)node.getData()).getName()) || StringUtil.equals((CharSequence)(taskPrefix + "test"), (CharSequence)((TaskData)node.getData()).getName())) : ExternalSystemApiUtil.find((DataNode)moduleNode, (Key)ProjectKeys.TASK, node -> (((TaskData)node.getData()).isTest() || "org.gradle.api.tasks.testing.Test".equals(((TaskData)node.getData()).getType())) && StringUtil.startsWith((CharSequence)((TaskData)node.getData()).getName(), (CharSequence)sourceSetId));
        if (taskNode == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(11);
            }
            return list;
        }
        String taskName = StringUtil.trimStart((String)((TaskData)taskNode.getData()).getName(), (String)taskPrefix);
        List tasks = ContainerUtil.list((Object[])new String[]{"clean" + StringUtil.capitalize((String)taskName), taskName});
        List list = ContainerUtil.map((Collection)tasks, task -> taskPrefix + task);
        if (list == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestRunConfigurationProducer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksToRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTasksToRun";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

