/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class ConfigurationErrorEvent
extends AbstractTestEvent {
    public ConfigurationErrorEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView xml) throws TestEventXmlView.XmlParserException {
        if (xml == null) {
            ConfigurationErrorEvent.$$$reportNull$$$0(0);
        }
        String errorTitle = xml.getEventTitle();
        String configurationErrorMsg = xml.getEventMessage();
        boolean openSettings = xml.isEventOpenSettings();
        final Project project = this.getProject();
        assert (project != null);
        String message = openSettings ? String.format("<br>\n%s<br><br>\n\n<a href=\"Gradle settings\">Open gradle settings</a>", configurationErrorMsg) : String.format("<br>\n%s", configurationErrorMsg);
        GradleNotification.getInstance((Project)project).showBalloon(errorTitle, message, NotificationType.WARNING, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                notification.expire();
                if ("Gradle settings".equals(event.getDescription())) {
                    ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
                    assert (manager instanceof GradleManager);
                    GradleManager gradleManager = (GradleManager)manager;
                    Configurable configurable = gradleManager.getConfigurable(project);
                    ShowSettingsUtil.getInstance().editConfigurable(project, configurable);
                } else {
                    BrowserUtil.browse((String)event.getDescription());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/ConfigurationErrorEvent$1";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "org/jetbrains/plugins/gradle/execution/test/runner/events/ConfigurationErrorEvent", "process"));
    }
}

