/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleIdeaPluginScriptContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleIdeaSettingsContributor;", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleMethodContextContributor;", "()V", "process", "", "methodCallInfo", "", "", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.gradle.java"})
public final class GradleIdeaSettingsContributor
implements GradleMethodContextContributor {
    @NotNull
    public static final String PROJECT_SETTINGS_FQN = "org.jetbrains.gradle.ext.ProjectSettings";
    @NotNull
    public static final String MODULE_SETTINGS_FQN = "org.jetbrains.gradle.ext.ModuleSettings";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull(methodCallInfo, (String)"methodCallInfo");
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        if (!Registry.is((String)"external.system.configuration.import.enabled")) {
            return true;
        }
        GlobalSearchScope globalSearchScope = place.getResolveScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"place.resolveScope");
        GlobalSearchScope resolveScope = globalSearchScope;
        GroovyPsiManager groovyPsiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)GradleIdeaPluginScriptContributor.Companion.getIdeaClosure())).accepts((Object)place)) {
            if (methodCallInfo.contains("project")) {
                GrLightParameter grLightParameter;
                GrLightMethodBuilder grLightMethodBuilder;
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass("org.gradle.plugins.ide.idea.model.IdeaProject", resolveScope);
                if (psiClass == null) {
                    return true;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"JavaPsiFacade.getInstanc\u2026olveScope) ?: return true");
                PsiClass ideaProjectClass = psiClass;
                PsiClassType psiClassType = groovyPsiManager.createTypeByFQClassName(PROJECT_SETTINGS_FQN, resolveScope);
                if (psiClassType == null) {
                    return true;
                }
                PsiClassType projectSettingsType = psiClassType;
                GrLightMethodBuilder $receiver = grLightMethodBuilder = new GrLightMethodBuilder(place.getManager(), "settings");
                $receiver.setContainingClass(ideaProjectClass);
                $receiver.setReturnType((PsiType)projectSettingsType);
                GrLightParameter $receiver2 = grLightParameter = $receiver.addAndGetParameter("configuration", "groovy.lang.Closure", false);
                $receiver2.putUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY, (Object)PROJECT_SETTINGS_FQN);
                $receiver2.putUserData(GrDelegatesToUtilKt.DELEGATES_TO_STRATEGY_KEY, (Object)1);
                GrLightMethodBuilder projectSettingsMethodBuilder = grLightMethodBuilder;
                if (!processor.execute((PsiElement)projectSettingsMethodBuilder, state)) {
                    return false;
                }
            } else if (methodCallInfo.contains("module")) {
                GrLightParameter grLightParameter;
                GrLightMethodBuilder grLightMethodBuilder;
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass("org.gradle.plugins.ide.idea.model.IdeaModule", resolveScope);
                if (psiClass == null) {
                    return true;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"JavaPsiFacade.getInstanc\u2026olveScope) ?: return true");
                PsiClass ideaModuleClass = psiClass;
                PsiClassType psiClassType = groovyPsiManager.createTypeByFQClassName(MODULE_SETTINGS_FQN, resolveScope);
                if (psiClassType == null) {
                    return true;
                }
                PsiClassType moduleSettingsType = psiClassType;
                GrLightMethodBuilder $receiver = grLightMethodBuilder = new GrLightMethodBuilder(place.getManager(), "settings");
                $receiver.setContainingClass(ideaModuleClass);
                $receiver.setReturnType((PsiType)moduleSettingsType);
                GrLightParameter $receiver3 = grLightParameter = $receiver.addAndGetParameter("configuration", "groovy.lang.Closure", false);
                $receiver3.putUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY, (Object)MODULE_SETTINGS_FQN);
                $receiver3.putUserData(GrDelegatesToUtilKt.DELEGATES_TO_STRATEGY_KEY, (Object)1);
                GrLightMethodBuilder moduleSettingsMethodBuilder = grLightMethodBuilder;
                if (!processor.execute((PsiElement)moduleSettingsMethodBuilder, state)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleIdeaSettingsContributor$Companion;", "", "()V", "MODULE_SETTINGS_FQN", "", "PROJECT_SETTINGS_FQN", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

