/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J3\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/junit/codeInsight/ChangeAnnotationFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "testAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "targetAnnotation", "", "(Lcom/intellij/psi/PsiAnnotation;Ljava/lang/String;)V", "getTargetAnnotation", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.junit"})
public final class ChangeAnnotationFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String targetAnnotation;

    @NotNull
    public String getFamilyName() {
        return "Replace annotation";
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        PsiAnnotation psiAnnotation = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText('@' + this.targetAnnotation, startElement);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"JavaPsiFacade.getElement\u2026nnotation\", startElement)");
        PsiAnnotation annotation = psiAnnotation;
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(startElement.replace((PsiElement)annotation));
    }

    @NotNull
    public String getText() {
        return "Change to " + StringUtil.getShortName((String)this.targetAnnotation);
    }

    @NotNull
    public final String getTargetAnnotation() {
        return this.targetAnnotation;
    }

    public ChangeAnnotationFix(@NotNull PsiAnnotation testAnnotation, @NotNull String targetAnnotation) {
        Intrinsics.checkParameterIsNotNull((Object)testAnnotation, (String)"testAnnotation");
        Intrinsics.checkParameterIsNotNull((Object)targetAnnotation, (String)"targetAnnotation");
        super((PsiElement)testAnnotation);
        this.targetAnnotation = targetAnnotation;
    }
}

