/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.dsl.impl;

import com.intellij.debugger.streams.trace.dsl.Convertable;
import com.intellij.debugger.streams.trace.dsl.Statement;
import com.intellij.debugger.streams.trace.dsl.StatementFactory;
import com.intellij.debugger.streams.trace.dsl.impl.CodeBlockBase;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/debugger/streams/trace/dsl/impl/LineSeparatedCodeBlock;", "Lcom/intellij/debugger/streams/trace/dsl/impl/CodeBlockBase;", "statementFactory", "Lcom/intellij/debugger/streams/trace/dsl/StatementFactory;", "statementSeparator", "", "(Lcom/intellij/debugger/streams/trace/dsl/StatementFactory;Ljava/lang/String;)V", "toCode", "indent", "", "intellij.java.debugger.streams"})
public abstract class LineSeparatedCodeBlock
extends CodeBlockBase {
    private final String statementSeparator;

    @Override
    @NotNull
    public String toCode(int indent) {
        if (this.getSize() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        List<Convertable> statements = this.getStatements();
        for (Convertable convertable : statements) {
            builder.append(convertable.toCode(indent));
            if (convertable instanceof Statement) {
                builder.append(this.statementSeparator);
            }
            builder.append("\n");
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public LineSeparatedCodeBlock(@NotNull StatementFactory statementFactory, @NotNull String statementSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)statementFactory, (String)"statementFactory");
        Intrinsics.checkParameterIsNotNull((Object)statementSeparator, (String)"statementSeparator");
        super(statementFactory);
        this.statementSeparator = statementSeparator;
    }

    public /* synthetic */ LineSeparatedCodeBlock(StatementFactory statementFactory, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(statementFactory, string);
    }
}

