/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.roots;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ScalableIconComponent
extends JComponent {
    private final Icon myIcon;
    private final Icon mySelectedIcon;
    private boolean myIsSelected = false;

    public ScalableIconComponent(Icon icon) {
        this(icon, icon);
    }

    public ScalableIconComponent(Icon icon, Icon selectedIcon) {
        this.myIcon = icon;
        Icon icon2 = this.mySelectedIcon = selectedIcon != null ? selectedIcon : icon;
        if (icon != null) {
            Dimension size = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            this.setPreferredSize(size);
            this.setMinimumSize(size);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Icon icon;
        Icon icon2 = icon = this.myIsSelected ? this.mySelectedIcon : this.myIcon;
        if (icon != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setBackground(this.getBackground());
            AffineTransform savedTransform = g2.getTransform();
            g2.scale((double)this.getWidth() / (double)icon.getIconWidth(), (double)this.getHeight() / (double)icon.getIconHeight());
            icon.paintIcon(this, g2, 0, 0);
            g2.setTransform(savedTransform);
        }
        super.paintComponent(g);
    }

    public final void setSelected(boolean isSelected) {
        this.myIsSelected = isSelected;
        this.revalidate();
        this.repaint();
    }
}

