/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.statistics.StatUtilKt;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemSettingsCollector
extends ProjectUsagesCollector {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getGroupId() {
        return "statistics.build.tools.state";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Set usages = new LinkedHashSet();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            String[] stringArray = new String[1];
            ProjectSystemId projectSystemId = manager.getSystemId();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectSystemId, (String)"manager.getSystemId()");
            stringArray[0] = StatUtilKt.escapeSystemId(projectSystemId);
            FUSUsageContext context = FUSUsageContext.create((String[])stringArray);
            Iterator iterator = ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project)).getLinkedProjectsSettings().iterator();
            while (iterator.hasNext()) {
                ExternalProjectSettings projectsSetting;
                ExternalProjectSettings externalProjectSettings = projectsSetting = (ExternalProjectSettings)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)externalProjectSettings, (String)"projectsSetting");
                usages.add(ExternalSystemSettingsCollector.Companion.addContext(StatisticsUtilKt.getBooleanUsage((String)"autoImport", (boolean)externalProjectSettings.isUseAutoImport()), context));
                usages.add(ExternalSystemSettingsCollector.Companion.addContext(StatisticsUtilKt.getBooleanUsage((String)"useQualifiedModuleNames", (boolean)projectsSetting.isUseQualifiedModuleNames()), context));
                usages.add(ExternalSystemSettingsCollector.Companion.addContext(StatisticsUtilKt.getCountingUsage((String)"modules.count", (int)projectsSetting.getModules().size()), context));
            }
        }
        return usages;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSettingsCollector$Companion;", "", "()V", "addContext", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "desc", "ctx", "Lcom/intellij/internal/statistic/service/fus/collectors/FUSUsageContext;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private final UsageDescriptor addContext(UsageDescriptor desc, FUSUsageContext ctx) {
            return new UsageDescriptor(desc.getKey(), desc.getValue(), ctx);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

