/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.java.decompiler.main.AssertProcessor;
import org.jetbrains.java.decompiler.main.ClassReference14Processor;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.EnumProcessor;
import org.jetbrains.java.decompiler.main.InitializerProcessor;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.TypeAnnotation;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructAnnDefaultAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationParameterAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructConstantValueAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructExceptionsAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLineNumberTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructMethodParametersAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructTypeAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class ClassWriter {
    private final PoolInterceptor interceptor = DecompilerContext.getPoolInterceptor();
    private static final StructGeneralAttribute.Key[] ANNOTATION_ATTRIBUTES = new StructGeneralAttribute.Key[]{StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS, StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_ANNOTATIONS};
    private static final StructGeneralAttribute.Key[] PARAMETER_ANNOTATION_ATTRIBUTES = new StructGeneralAttribute.Key[]{StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS, StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS};
    private static final StructGeneralAttribute.Key[] TYPE_ANNOTATION_ATTRIBUTES = new StructGeneralAttribute.Key[]{StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_TYPE_ANNOTATIONS, StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_TYPE_ANNOTATIONS};
    private static final Map<Integer, String> MODIFIERS = new LinkedHashMap<Integer, String>();
    private static final int CLASS_ALLOWED = 3103;
    private static final int FIELD_ALLOWED = 223;
    private static final int METHOD_ALLOWED = 3391;
    private static final int CLASS_EXCLUDED = 1032;
    private static final int FIELD_EXCLUDED = 25;
    private static final int METHOD_EXCLUDED = 1025;
    private static final int ACCESSIBILITY_FLAGS = 7;

    private static void invokeProcessors(ClassesProcessor.ClassNode node) {
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        InitializerProcessor.extractInitializers(wrapper);
        if (node.type == 0 && !cl.isVersionGE_1_5() && DecompilerContext.getOption("dc4")) {
            ClassReference14Processor.processClassReferences(node);
        }
        if (cl.hasModifier(16384) && DecompilerContext.getOption("den")) {
            EnumProcessor.clearEnum(wrapper);
        }
        if (DecompilerContext.getOption("das")) {
            AssertProcessor.buildAssertions(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classLambdaToJava(ClassesProcessor.ClassNode node, TextBuffer buffer, Exprent method_object, int indent, BytecodeMappingTracer origTracer) {
        ClassWrapper wrapper = node.getWrapper();
        if (wrapper == null) {
            return;
        }
        boolean lambdaToAnonymous = DecompilerContext.getOption("lac");
        ClassesProcessor.ClassNode outerNode = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        DecompilerContext.setProperty("CURRENT_CLASS_NODE", node);
        BytecodeMappingTracer tracer = new BytecodeMappingTracer(origTracer.getCurrentSourceLine());
        try {
            StructClass cl = wrapper.getClassStruct();
            DecompilerContext.getLogger().startWriteClass(node.simpleName);
            if (node.lambdaInformation.is_method_reference) {
                if (!node.lambdaInformation.is_content_method_static && method_object != null) {
                    buffer.append(method_object.toJava(indent, tracer));
                } else {
                    buffer.append(ExprProcessor.getCastTypeName(new VarType(node.lambdaInformation.content_class_name, true)));
                }
                buffer.append("::").append("<init>".equals(node.lambdaInformation.content_method_name) ? "new" : node.lambdaInformation.content_method_name);
            } else {
                StructMethod mt = cl.getMethod(node.lambdaInformation.content_method_key);
                MethodWrapper methodWrapper = wrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
                MethodDescriptor md_content = MethodDescriptor.parseDescriptor(node.lambdaInformation.content_method_descriptor);
                MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(node.lambdaInformation.method_descriptor);
                if (!lambdaToAnonymous) {
                    buffer.append('(');
                    boolean firstParameter = true;
                    int index = node.lambdaInformation.is_content_method_static ? 0 : 1;
                    int start_index = md_content.params.length - md_lambda.params.length;
                    for (int i = 0; i < md_content.params.length; ++i) {
                        if (i >= start_index) {
                            String parameterName;
                            if (!firstParameter) {
                                buffer.append(", ");
                            }
                            buffer.append((parameterName = methodWrapper.varproc.getVarName(new VarVersionPair(index, 0))) == null ? "param" + index : parameterName);
                            firstParameter = false;
                        }
                        index += md_content.params[i].stackSize;
                    }
                    buffer.append(") ->");
                }
                buffer.append(" {").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                ClassWriter.methodLambdaToJava(node, wrapper, mt, buffer, indent + 1, !lambdaToAnonymous, tracer);
                buffer.appendIndent(indent).append("}");
                ClassWriter.addTracer(cl, mt, tracer);
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_CLASS_NODE", outerNode);
        }
        DecompilerContext.getLogger().endWriteClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classToJava(ClassesProcessor.ClassNode node, TextBuffer buffer, int indent, BytecodeMappingTracer tracer) {
        ClassesProcessor.ClassNode outerNode = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        DecompilerContext.setProperty("CURRENT_CLASS_NODE", node);
        int startLine = tracer != null ? tracer.getCurrentSourceLine() : 0;
        BytecodeMappingTracer dummy_tracer = new BytecodeMappingTracer(startLine);
        try {
            boolean hide;
            ClassWriter.invokeProcessors(node);
            ClassWrapper wrapper = node.getWrapper();
            StructClass cl = wrapper.getClassStruct();
            DecompilerContext.getLogger().startWriteClass(cl.qualifiedName);
            int start_class_def = buffer.length();
            this.writeClassDefinition(node, buffer, indent);
            boolean hasContent = false;
            boolean enumFields = false;
            dummy_tracer.incrementCurrentSourceLine(buffer.countLines(start_class_def));
            for (StructField fd : cl.getFields()) {
                boolean isEnum;
                hide = fd.isSynthetic() && DecompilerContext.getOption("rsy") || wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
                if (hide) continue;
                boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("den");
                if (isEnum) {
                    if (enumFields) {
                        buffer.append(',').appendLineSeparator();
                        dummy_tracer.incrementCurrentSourceLine();
                    }
                    enumFields = true;
                } else if (enumFields) {
                    buffer.append(';');
                    buffer.appendLineSeparator();
                    buffer.appendLineSeparator();
                    dummy_tracer.incrementCurrentSourceLine(2);
                    enumFields = false;
                }
                this.fieldToJava(wrapper, cl, fd, buffer, indent + 1, dummy_tracer);
                hasContent = true;
            }
            if (enumFields) {
                buffer.append(';').appendLineSeparator();
                dummy_tracer.incrementCurrentSourceLine();
            }
            startLine += buffer.countLines(start_class_def);
            for (StructMethod mt : cl.getMethods()) {
                BytecodeMappingTracer method_tracer;
                boolean methodSkipped;
                boolean bl = hide = mt.isSynthetic() && DecompilerContext.getOption("rsy") || mt.hasModifier(64) && DecompilerContext.getOption("rbr") || wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
                if (hide) continue;
                int position = buffer.length();
                int storedLine = startLine++;
                if (hasContent) {
                    buffer.appendLineSeparator();
                }
                boolean bl2 = methodSkipped = !this.methodToJava(node, mt, buffer, indent + 1, method_tracer = new BytecodeMappingTracer(startLine));
                if (!methodSkipped) {
                    hasContent = true;
                    ClassWriter.addTracer(cl, mt, method_tracer);
                    startLine = method_tracer.getCurrentSourceLine();
                    continue;
                }
                buffer.setLength(position);
                startLine = storedLine;
            }
            for (ClassesProcessor.ClassNode inner : node.nested) {
                if (inner.type != 1) continue;
                StructClass innerCl = inner.classStruct;
                boolean isSynthetic = (inner.access & 0x1000) != 0 || innerCl.isSynthetic();
                boolean hide2 = isSynthetic && DecompilerContext.getOption("rsy") || wrapper.getHiddenMembers().contains(innerCl.qualifiedName);
                if (hide2) continue;
                if (hasContent) {
                    buffer.appendLineSeparator();
                    ++startLine;
                }
                BytecodeMappingTracer class_tracer = new BytecodeMappingTracer(startLine);
                this.classToJava(inner, buffer, indent + 1, class_tracer);
                startLine = buffer.countLines();
                hasContent = true;
            }
            buffer.appendIndent(indent).append('}');
            if (node.type != 2) {
                buffer.appendLineSeparator();
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_CLASS_NODE", outerNode);
        }
        DecompilerContext.getLogger().endWriteClass();
    }

    private static void addTracer(StructClass cls, StructMethod method, BytecodeMappingTracer tracer) {
        StructLineNumberTableAttribute table = method.getAttribute(StructGeneralAttribute.ATTRIBUTE_LINE_NUMBER_TABLE);
        tracer.setLineNumberTable(table);
        String key = InterpreterUtil.makeUniqueKey(method.getName(), method.getDescriptor());
        DecompilerContext.getBytecodeSourceMapper().addTracer(cls.qualifiedName, key, tracer);
    }

    private void writeClassDefinition(ClassesProcessor.ClassNode node, TextBuffer buffer, int indent) {
        int[] interfaces;
        VarType supertype;
        boolean isAnnotation;
        if (node.type == 2) {
            buffer.append(" {").appendLineSeparator();
            return;
        }
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        int flags = node.type == 0 ? cl.getAccessFlags() : node.access;
        boolean isDeprecated = cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
        boolean isSynthetic = (flags & 0x1000) != 0 || cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
        boolean isEnum = DecompilerContext.getOption("den") && (flags & 0x4000) != 0;
        boolean isInterface = (flags & 0x200) != 0;
        boolean bl = isAnnotation = (flags & 0x2000) != 0;
        if (isDeprecated) {
            ClassWriter.appendDeprecation(buffer, indent);
        }
        if (this.interceptor != null) {
            String oldName = this.interceptor.getOldName(cl.qualifiedName);
            ClassWriter.appendRenameComment(buffer, oldName, MType.CLASS, indent);
        }
        if (isSynthetic) {
            ClassWriter.appendComment(buffer, "synthetic class", indent);
        }
        ClassWriter.appendAnnotations(buffer, indent, cl, -1);
        buffer.appendIndent(indent);
        if (isEnum) {
            flags &= 0xFFFFFBFF;
            flags &= 0xFFFFFFEF;
        }
        ClassWriter.appendModifiers(buffer, flags, 3103, isInterface, 1032);
        if (isEnum) {
            buffer.append("enum ");
        } else if (isInterface) {
            if (isAnnotation) {
                buffer.append('@');
            }
            buffer.append("interface ");
        } else {
            buffer.append("class ");
        }
        buffer.append(node.simpleName);
        GenericClassDescriptor descriptor = ClassWriter.getGenericClassDescriptor(cl);
        if (descriptor != null && !descriptor.fparameters.isEmpty()) {
            ClassWriter.appendTypeParameters(buffer, descriptor.fparameters, descriptor.fbounds);
        }
        buffer.append(' ');
        if (!(isEnum || isInterface || cl.superClass == null || VarType.VARTYPE_OBJECT.equals(supertype = new VarType(cl.superClass.getString(), true)))) {
            buffer.append("extends ");
            if (descriptor != null) {
                buffer.append(GenericMain.getGenericCastTypeName(descriptor.superclass));
            } else {
                buffer.append(ExprProcessor.getCastTypeName(supertype));
            }
            buffer.append(' ');
        }
        if (!isAnnotation && (interfaces = cl.getInterfaces()).length > 0) {
            buffer.append(isInterface ? "extends " : "implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (descriptor != null) {
                    buffer.append(GenericMain.getGenericCastTypeName(descriptor.superinterfaces.get(i)));
                    continue;
                }
                buffer.append(ExprProcessor.getCastTypeName(new VarType(cl.getInterface(i), true)));
            }
            buffer.append(' ');
        }
        buffer.append('{').appendLineSeparator();
    }

    private void fieldToJava(ClassWrapper wrapper, StructClass cl, StructField fd, TextBuffer buffer, int indent, BytecodeMappingTracer tracer) {
        StructConstantValueAttribute attr;
        StructGenericSignatureAttribute attr2;
        boolean isEnum;
        int start = buffer.length();
        boolean isInterface = cl.hasModifier(512);
        boolean isDeprecated = fd.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
        boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("den");
        if (isDeprecated) {
            ClassWriter.appendDeprecation(buffer, indent);
        }
        if (this.interceptor != null) {
            String oldName = this.interceptor.getOldName(cl.qualifiedName + " " + fd.getName() + " " + fd.getDescriptor());
            ClassWriter.appendRenameComment(buffer, oldName, MType.FIELD, indent);
        }
        if (fd.isSynthetic()) {
            ClassWriter.appendComment(buffer, "synthetic field", indent);
        }
        ClassWriter.appendAnnotations(buffer, indent, fd, 19);
        buffer.appendIndent(indent);
        if (!isEnum) {
            ClassWriter.appendModifiers(buffer, fd.getAccessFlags(), 223, isInterface, 25);
        }
        VarType fieldType = new VarType(fd.getDescriptor(), false);
        GenericFieldDescriptor descriptor = null;
        if (DecompilerContext.getOption("dgs") && (attr2 = fd.getAttribute(StructGeneralAttribute.ATTRIBUTE_SIGNATURE)) != null) {
            descriptor = GenericMain.parseFieldSignature(attr2.getSignature());
        }
        if (!isEnum) {
            if (descriptor != null) {
                buffer.append(GenericMain.getGenericCastTypeName(descriptor.type));
            } else {
                buffer.append(ExprProcessor.getCastTypeName(fieldType));
            }
            buffer.append(' ');
        }
        buffer.append(fd.getName());
        tracer.incrementCurrentSourceLine(buffer.countLines(start));
        Exprent initializer = fd.hasModifier(8) ? wrapper.getStaticFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor())) : wrapper.getDynamicFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
        if (initializer != null) {
            if (isEnum && initializer.type == 10) {
                NewExprent expr = (NewExprent)initializer;
                expr.setEnumConst(true);
                buffer.append(expr.toJava(indent, tracer));
            } else {
                buffer.append(" = ");
                if (initializer.type == 3) {
                    ((ConstExprent)initializer).adjustConstType(fieldType);
                }
                buffer.append(initializer.toJava(indent, tracer));
            }
        } else if (fd.hasModifier(16) && fd.hasModifier(8) && (attr = fd.getAttribute(StructGeneralAttribute.ATTRIBUTE_CONSTANT_VALUE)) != null) {
            PrimitiveConstant constant = cl.getPool().getPrimitiveConstant(attr.getIndex());
            buffer.append(" = ");
            buffer.append(new ConstExprent(fieldType, constant.value, null).toJava(indent, tracer));
        }
        if (!isEnum) {
            buffer.append(";").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void methodLambdaToJava(ClassesProcessor.ClassNode lambdaNode, ClassWrapper classWrapper, StructMethod mt, TextBuffer buffer, int indent, boolean codeOnly, BytecodeMappingTracer tracer) {
        MethodWrapper methodWrapper = classWrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
        MethodWrapper outerWrapper = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", methodWrapper);
        try {
            String method_name = lambdaNode.lambdaInformation.method_name;
            MethodDescriptor md_content = MethodDescriptor.parseDescriptor(lambdaNode.lambdaInformation.content_method_descriptor);
            MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(lambdaNode.lambdaInformation.method_descriptor);
            if (!codeOnly) {
                buffer.appendIndent(indent);
                buffer.append("public ");
                buffer.append(method_name);
                buffer.append("(");
                boolean firstParameter = true;
                int index = lambdaNode.lambdaInformation.is_content_method_static ? 0 : 1;
                int start_index = md_content.params.length - md_lambda.params.length;
                for (int i = 0; i < md_content.params.length; ++i) {
                    if (i >= start_index) {
                        String typeName;
                        if (!firstParameter) {
                            buffer.append(", ");
                        }
                        if ("<undefinedtype>".equals(typeName = ExprProcessor.getCastTypeName(md_content.params[i].copy())) && DecompilerContext.getOption("uto")) {
                            typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT);
                        }
                        buffer.append(typeName);
                        buffer.append(" ");
                        String parameterName = methodWrapper.varproc.getVarName(new VarVersionPair(index, 0));
                        buffer.append(parameterName == null ? "param" + index : parameterName);
                        firstParameter = false;
                    }
                    index += md_content.params[i].stackSize;
                }
                buffer.append(") {").appendLineSeparator();
                ++indent;
            }
            RootStatement root = classWrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
            if (!methodWrapper.decompiledWithErrors && root != null) {
                try {
                    buffer.append(root.toJava(indent, tracer));
                }
                catch (Throwable t) {
                    String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be written.";
                    DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
                    methodWrapper.decompiledWithErrors = true;
                }
            }
            if (methodWrapper.decompiledWithErrors) {
                buffer.appendIndent(indent);
                buffer.append("// $FF: Couldn't be decompiled");
                buffer.appendLineSeparator();
            }
            if (root != null) {
                tracer.addMapping(root.getDummyExit().bytecode);
            }
            if (!codeOnly) {
                buffer.appendIndent(--indent).append('}').appendLineSeparator();
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", outerWrapper);
        }
    }

    private static String toValidJavaIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        boolean changed = false;
        StringBuilder res = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c) || i > 0 && !Character.isJavaIdentifierPart(c)) {
                changed = true;
                res.append("_");
                continue;
            }
            res.append(c);
        }
        if (!changed) {
            return name;
        }
        return res.append("/* $FF was: ").append(name).append("*/").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean methodToJava(ClassesProcessor.ClassNode node, StructMethod mt, TextBuffer buffer, int indent, BytecodeMappingTracer tracer) {
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        MethodWrapper methodWrapper = wrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
        boolean hideMethod = false;
        int start_index_method = buffer.length();
        MethodWrapper outerWrapper = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", methodWrapper);
        try {
            String message;
            List<VarVersionPair> mask;
            StructGenericSignatureAttribute attr;
            String name;
            boolean isBridge;
            boolean isInterface = cl.hasModifier(512);
            boolean isAnnotation = cl.hasModifier(8192);
            boolean isEnum = cl.hasModifier(16384) && DecompilerContext.getOption("den");
            boolean isDeprecated = mt.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
            boolean clinit = false;
            boolean init = false;
            boolean dinit = false;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            int flags = mt.getAccessFlags();
            if ((flags & 0x100) != 0) {
                flags &= 0xFFFFF7FF;
            }
            if ("<clinit>".equals(mt.getName())) {
                flags &= 8;
            }
            if (isDeprecated) {
                ClassWriter.appendDeprecation(buffer, indent);
            }
            if (this.interceptor != null) {
                String oldName = this.interceptor.getOldName(cl.qualifiedName + " " + mt.getName() + " " + mt.getDescriptor());
                ClassWriter.appendRenameComment(buffer, oldName, MType.METHOD, indent);
            }
            boolean isSynthetic = (flags & 0x1000) != 0 || mt.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
            boolean bl = isBridge = (flags & 0x40) != 0;
            if (isSynthetic) {
                ClassWriter.appendComment(buffer, "synthetic method", indent);
            }
            if (isBridge) {
                ClassWriter.appendComment(buffer, "bridge method", indent);
            }
            ClassWriter.appendAnnotations(buffer, indent, mt, 20);
            buffer.appendIndent(indent);
            ClassWriter.appendModifiers(buffer, flags, 3391, isInterface, 1025);
            if (isInterface && !mt.hasModifier(8) && mt.containsCode()) {
                buffer.append("default ");
            }
            if ("<init>".equals(name = mt.getName())) {
                if (node.type == 2) {
                    name = "";
                    dinit = true;
                } else {
                    name = node.simpleName;
                    init = true;
                }
            } else if ("<clinit>".equals(name)) {
                name = "";
                clinit = true;
            }
            GenericMethodDescriptor descriptor = null;
            if (DecompilerContext.getOption("dgs") && (attr = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_SIGNATURE)) != null && (descriptor = GenericMain.parseMethodSignature(attr.getSignature())) != null) {
                long actualParams = md.params.length;
                mask = methodWrapper.synthParameters;
                if (mask != null) {
                    actualParams = mask.stream().filter(Objects::isNull).count();
                } else if (isEnum && init) {
                    actualParams -= 2L;
                }
                if (actualParams != (long)descriptor.parameterTypes.size()) {
                    message = "Inconsistent generic signature in method " + mt.getName() + " " + mt.getDescriptor() + " in " + cl.qualifiedName;
                    DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                    descriptor = null;
                }
            }
            boolean throwsExceptions = false;
            int paramCount = 0;
            if (!clinit && !dinit) {
                int start;
                StructMethodParametersAttribute attr2;
                boolean thisVar;
                boolean bl2 = thisVar = !mt.hasModifier(8);
                if (descriptor != null && !descriptor.typeParameters.isEmpty()) {
                    ClassWriter.appendTypeParameters(buffer, descriptor.typeParameters, descriptor.typeParameterBounds);
                    buffer.append(' ');
                }
                if (!init) {
                    if (descriptor != null) {
                        buffer.append(GenericMain.getGenericCastTypeName(descriptor.returnType));
                    } else {
                        buffer.append(ExprProcessor.getCastTypeName(md.ret));
                    }
                    buffer.append(' ');
                }
                buffer.append(ClassWriter.toValidJavaIdentifier(name));
                buffer.append('(');
                mask = methodWrapper.synthParameters;
                int lastVisibleParameterIndex = -1;
                for (int i = 0; i < md.params.length; ++i) {
                    if (mask != null && mask.get(i) != null) continue;
                    lastVisibleParameterIndex = i;
                }
                List<StructMethodParametersAttribute.Entry> methodParameters = null;
                if (DecompilerContext.getOption("ump") && (attr2 = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_METHOD_PARAMETERS)) != null) {
                    methodParameters = attr2.getEntries();
                }
                int index = isEnum && init ? 3 : (thisVar ? 1 : 0);
                for (int i = start = isEnum && init ? 2 : 0; i < md.params.length; ++i) {
                    if (mask == null || mask.get(i) == null) {
                        String typeName;
                        Object parameterType;
                        boolean isVarArg;
                        if (paramCount > 0) {
                            buffer.append(", ");
                        }
                        ClassWriter.appendParameterAnnotations(buffer, mt, paramCount);
                        if (methodParameters != null && i < methodParameters.size()) {
                            ClassWriter.appendModifiers(buffer, methodParameters.get((int)i).myAccessFlags, 16, isInterface, 0);
                        } else if (methodWrapper.varproc.getVarFinal(new VarVersionPair(index, 0)) == 2) {
                            buffer.append("final ");
                        }
                        boolean bl3 = isVarArg = i == lastVisibleParameterIndex && mt.hasModifier(128);
                        if (descriptor != null) {
                            parameterType = descriptor.parameterTypes.get(paramCount);
                            if (isVarArg &= ((GenericType)parameterType).arrayDim > 0) {
                                parameterType = ((GenericType)parameterType).decreaseArrayDim();
                            }
                            typeName = GenericMain.getGenericCastTypeName((GenericType)parameterType);
                        } else {
                            parameterType = md.params[i];
                            if (isVarArg &= ((VarType)parameterType).arrayDim > 0) {
                                parameterType = ((VarType)parameterType).decreaseArrayDim();
                            }
                            typeName = ExprProcessor.getCastTypeName((VarType)parameterType);
                        }
                        if ("<undefinedtype>".equals(typeName) && DecompilerContext.getOption("uto")) {
                            typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT);
                        }
                        buffer.append(typeName);
                        if (isVarArg) {
                            buffer.append("...");
                        }
                        buffer.append(' ');
                        String parameterName = methodParameters != null && i < methodParameters.size() ? methodParameters.get((int)i).myName : methodWrapper.varproc.getVarName(new VarVersionPair(index, 0));
                        buffer.append(parameterName == null ? "param" + index : parameterName);
                        ++paramCount;
                    }
                    index += md.params[i].stackSize;
                }
                buffer.append(')');
                StructExceptionsAttribute attr3 = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_EXCEPTIONS);
                if (descriptor != null && !descriptor.exceptionTypes.isEmpty() || attr3 != null) {
                    throwsExceptions = true;
                    buffer.append(" throws ");
                    for (int i = 0; i < attr3.getThrowsExceptions().size(); ++i) {
                        Object type;
                        if (i > 0) {
                            buffer.append(", ");
                        }
                        if (descriptor != null && !descriptor.exceptionTypes.isEmpty()) {
                            type = descriptor.exceptionTypes.get(i);
                            buffer.append(GenericMain.getGenericCastTypeName((GenericType)type));
                            continue;
                        }
                        type = new VarType(attr3.getExcClassname(i, cl.getPool()), true);
                        buffer.append(ExprProcessor.getCastTypeName((VarType)type));
                    }
                }
            }
            tracer.incrementCurrentSourceLine(buffer.countLines(start_index_method));
            if ((flags & 0x500) != 0) {
                StructAnnDefaultAttribute attr4;
                if (isAnnotation && (attr4 = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_ANNOTATION_DEFAULT)) != null) {
                    buffer.append(" default ");
                    buffer.append(attr4.getDefaultValue().toJava(0, BytecodeMappingTracer.DUMMY));
                }
                buffer.append(';');
                buffer.appendLineSeparator();
            } else {
                if (!clinit && !dinit) {
                    buffer.append(' ');
                }
                buffer.append('{').appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                RootStatement root = wrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
                if (root != null && !methodWrapper.decompiledWithErrors) {
                    try {
                        BytecodeMappingTracer codeTracer = new BytecodeMappingTracer(tracer.getCurrentSourceLine());
                        TextBuffer code = root.toJava(indent + 1, codeTracer);
                        hideMethod = code.length() == 0 && (clinit || dinit || ClassWriter.hideConstructor(node, init, throwsExceptions, paramCount, flags));
                        buffer.append(code);
                        tracer.setCurrentSourceLine(codeTracer.getCurrentSourceLine());
                        tracer.addTracer(codeTracer);
                    }
                    catch (Throwable t) {
                        message = "Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be written.";
                        DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
                        methodWrapper.decompiledWithErrors = true;
                    }
                }
                if (methodWrapper.decompiledWithErrors) {
                    buffer.appendIndent(indent + 1);
                    buffer.append("// $FF: Couldn't be decompiled");
                    buffer.appendLineSeparator();
                    tracer.incrementCurrentSourceLine();
                } else if (root != null) {
                    tracer.addMapping(root.getDummyExit().bytecode);
                }
                buffer.appendIndent(indent).append('}').appendLineSeparator();
            }
            tracer.incrementCurrentSourceLine();
        }
        finally {
            DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", outerWrapper);
        }
        return !hideMethod;
    }

    private static boolean hideConstructor(ClassesProcessor.ClassNode node, boolean init, boolean throwsExceptions, int paramCount, int methodAccessFlags) {
        boolean isEnum;
        if (!init || throwsExceptions || paramCount > 0 || !DecompilerContext.getOption("hdc")) {
            return false;
        }
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        int classAccesFlags = node.type == 0 ? cl.getAccessFlags() : node.access;
        boolean bl = isEnum = cl.hasModifier(16384) && DecompilerContext.getOption("den");
        if (!isEnum && (classAccesFlags & 7) != (methodAccessFlags & 7)) {
            return false;
        }
        int count = 0;
        for (StructMethod mt : cl.getMethods()) {
            if (!"<init>".equals(mt.getName()) || ++count <= 1) continue;
            return false;
        }
        return true;
    }

    private static void appendDeprecation(TextBuffer buffer, int indent) {
        buffer.appendIndent(indent).append("/** @deprecated */").appendLineSeparator();
    }

    private static void appendRenameComment(TextBuffer buffer, String oldName, MType type, int indent) {
        if (oldName == null) {
            return;
        }
        buffer.appendIndent(indent);
        buffer.append("// $FF: renamed from: ");
        switch (type) {
            case CLASS: {
                buffer.append(ExprProcessor.buildJavaClassName(oldName));
                break;
            }
            case FIELD: {
                String[] fParts = oldName.split(" ");
                FieldDescriptor fd = FieldDescriptor.parseDescriptor(fParts[2]);
                buffer.append(fParts[1]);
                buffer.append(' ');
                buffer.append(ClassWriter.getTypePrintOut(fd.type));
                break;
            }
            default: {
                String[] mParts = oldName.split(" ");
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mParts[2]);
                buffer.append(mParts[1]);
                buffer.append(" (");
                boolean first = true;
                for (VarType paramType : md.params) {
                    if (!first) {
                        buffer.append(", ");
                    }
                    first = false;
                    buffer.append(ClassWriter.getTypePrintOut(paramType));
                }
                buffer.append(") ");
                buffer.append(ClassWriter.getTypePrintOut(md.ret));
            }
        }
        buffer.appendLineSeparator();
    }

    private static String getTypePrintOut(VarType type) {
        String typeText = ExprProcessor.getCastTypeName(type, false);
        if ("<undefinedtype>".equals(typeText) && DecompilerContext.getOption("uto")) {
            typeText = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT, false);
        }
        return typeText;
    }

    private static void appendComment(TextBuffer buffer, String comment, int indent) {
        buffer.appendIndent(indent).append("// $FF: ").append(comment).appendLineSeparator();
    }

    private static void appendAnnotations(TextBuffer buffer, int indent, StructMember mb, int targetType) {
        HashSet<String> filter = new HashSet<String>();
        for (StructGeneralAttribute.Key key : ANNOTATION_ATTRIBUTES) {
            StructAnnotationAttribute attribute = (StructAnnotationAttribute)mb.getAttribute(key);
            if (attribute == null) continue;
            for (AnnotationExprent annotation : attribute.getAnnotations()) {
                String text = annotation.toJava(indent, BytecodeMappingTracer.DUMMY).toString();
                filter.add(text);
                buffer.append(text).appendLineSeparator();
            }
        }
        ClassWriter.appendTypeAnnotations(buffer, indent, mb, targetType, -1, filter);
    }

    private static void appendParameterAnnotations(TextBuffer buffer, StructMethod mt, int param) {
        HashSet<String> filter = new HashSet<String>();
        for (StructGeneralAttribute.Key key : PARAMETER_ANNOTATION_ATTRIBUTES) {
            List<List<AnnotationExprent>> annotations;
            StructAnnotationParameterAttribute attribute = (StructAnnotationParameterAttribute)mt.getAttribute(key);
            if (attribute == null || param >= (annotations = attribute.getParamAnnotations()).size()) continue;
            for (AnnotationExprent annotation : annotations.get(param)) {
                String text = annotation.toJava(-1, BytecodeMappingTracer.DUMMY).toString();
                filter.add(text);
                buffer.append(text).append(' ');
            }
        }
        ClassWriter.appendTypeAnnotations(buffer, -1, mt, 22, param, filter);
    }

    private static void appendTypeAnnotations(TextBuffer buffer, int indent, StructMember mb, int targetType, int index, Set<String> filter) {
        for (StructGeneralAttribute.Key key : TYPE_ANNOTATION_ATTRIBUTES) {
            StructTypeAnnotationAttribute attribute = (StructTypeAnnotationAttribute)mb.getAttribute(key);
            if (attribute == null) continue;
            for (TypeAnnotation annotation : attribute.getAnnotations()) {
                String text;
                if (!annotation.isTopLevel() || annotation.getTargetType() != targetType || index >= 0 && annotation.getIndex() != index || filter.contains(text = annotation.getAnnotation().toJava(indent, BytecodeMappingTracer.DUMMY).toString())) continue;
                buffer.append(text);
                if (indent < 0) {
                    buffer.append(' ');
                    continue;
                }
                buffer.appendLineSeparator();
            }
        }
    }

    private static void appendModifiers(TextBuffer buffer, int flags, int allowed, boolean isInterface, int excluded) {
        flags &= allowed;
        if (!isInterface) {
            excluded = 0;
        }
        for (int modifier : MODIFIERS.keySet()) {
            if ((flags & modifier) != modifier || (modifier & excluded) != 0) continue;
            buffer.append(MODIFIERS.get(modifier)).append(' ');
        }
    }

    public static GenericClassDescriptor getGenericClassDescriptor(StructClass cl) {
        StructGenericSignatureAttribute attr;
        if (DecompilerContext.getOption("dgs") && (attr = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_SIGNATURE)) != null) {
            return GenericMain.parseClassSignature(attr.getSignature());
        }
        return null;
    }

    public static void appendTypeParameters(TextBuffer buffer, List<String> parameters, List<? extends List<GenericType>> bounds) {
        buffer.append('<');
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(parameters.get(i));
            List<GenericType> parameterBounds = bounds.get(i);
            if (parameterBounds.size() <= 1 && "java/lang/Object".equals(parameterBounds.get((int)0).value)) continue;
            buffer.append(" extends ");
            buffer.append(GenericMain.getGenericCastTypeName(parameterBounds.get(0)));
            for (int j = 1; j < parameterBounds.size(); ++j) {
                buffer.append(" & ");
                buffer.append(GenericMain.getGenericCastTypeName(parameterBounds.get(j)));
            }
        }
        buffer.append('>');
    }

    static {
        MODIFIERS.put(1, "public");
        MODIFIERS.put(4, "protected");
        MODIFIERS.put(2, "private");
        MODIFIERS.put(1024, "abstract");
        MODIFIERS.put(8, "static");
        MODIFIERS.put(16, "final");
        MODIFIERS.put(2048, "strictfp");
        MODIFIERS.put(128, "transient");
        MODIFIERS.put(64, "volatile");
        MODIFIERS.put(32, "synchronized");
        MODIFIERS.put(256, "native");
    }

    private static enum MType {
        CLASS,
        FIELD,
        METHOD;

    }
}

