/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructMethod;

public class MethodWrapper {
    public final RootStatement root;
    public final VarProcessor varproc;
    public final StructMethod methodStruct;
    public final CounterContainer counter;
    public final Set<String> setOuterVarNames = new HashSet<String>();
    public DirectGraph graph;
    public List<VarVersionPair> synthParameters;
    public boolean decompiledWithErrors;

    public MethodWrapper(RootStatement root, VarProcessor varproc, StructMethod methodStruct, CounterContainer counter) {
        this.root = root;
        this.varproc = varproc;
        this.methodStruct = methodStruct;
        this.counter = counter;
    }

    public DirectGraph getOrBuildGraph() {
        if (this.graph == null && this.root != null) {
            this.graph = new FlattenStatementsHelper().buildDirectGraph(this.root);
        }
        return this.graph;
    }

    public String toString() {
        return this.methodStruct.getName();
    }
}

