/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructBootstrapMethodsAttribute
extends StructGeneralAttribute {
    private final List<LinkConstant> methodRefs = new ArrayList<LinkConstant>();
    private final List<List<PooledConstant>> methodArguments = new ArrayList<List<PooledConstant>>();

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
        int method_number = data.readUnsignedShort();
        for (int i = 0; i < method_number; ++i) {
            int bootstrap_method_ref = data.readUnsignedShort();
            int num_bootstrap_arguments = data.readUnsignedShort();
            ArrayList<PooledConstant> list_arguments = new ArrayList<PooledConstant>();
            for (int j = 0; j < num_bootstrap_arguments; ++j) {
                int bootstrap_argument_ref = data.readUnsignedShort();
                list_arguments.add(pool.getConstant(bootstrap_argument_ref));
            }
            this.methodRefs.add(pool.getLinkConstant(bootstrap_method_ref));
            this.methodArguments.add(list_arguments);
        }
    }

    public int getMethodsNumber() {
        return this.methodRefs.size();
    }

    public LinkConstant getMethodReference(int index) {
        return this.methodRefs.get(index);
    }

    public List<PooledConstant> getMethodArguments(int index) {
        return this.methodArguments.get(index);
    }
}

