/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.JobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.layout.ColumnConstraints;

public class AddColumnConstraintsJob
extends BatchDocumentJob {
    private final Map<FXOMObject, Set<Integer>> targetGridPanes;
    private final GridPaneJobUtils.Position position;
    private static final double defaultMinWidth = 10.0;
    private static final double defaultPrefWidth = 100.0;

    public AddColumnConstraintsJob(EditorController editorController, GridPaneJobUtils.Position position, Map<FXOMObject, Set<Integer>> targetGridPanes) {
        super(editorController);
        this.position = position;
        this.targetGridPanes = targetGridPanes;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        assert (!this.targetGridPanes.isEmpty());
        for (FXOMObject targetGridPane : this.targetGridPanes.keySet()) {
            assert (targetGridPane instanceof FXOMInstance);
            Set<Integer> targetIndexes = this.targetGridPanes.get(targetGridPane);
            result.addAll(this.addColumnConstraints((FXOMInstance)targetGridPane, targetIndexes));
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return "Add Column Constraints";
    }

    private Set<Job> addColumnConstraints(FXOMInstance targetGridPane, Set<Integer> targetIndexes) {
        LinkedHashSet<Job> result = new LinkedHashSet<Job>();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        PropertyName propertyName = new PropertyName("columnConstraints");
        FXOMProperty constraintsProperty = targetGridPane.getProperties().get(propertyName);
        if (constraintsProperty == null) {
            constraintsProperty = new FXOMPropertyC(fxomDocument, propertyName);
        }
        assert (constraintsProperty instanceof FXOMPropertyC);
        DesignHierarchyMask mask = new DesignHierarchyMask(targetGridPane);
        int shiftIndex = 0;
        int constraintsSize = mask.getColumnsConstraintsSize();
        for (int targetIndex : targetIndexes) {
            AddPropertyValueJob addValueJob;
            FXOMInstance addedConstraints;
            FXOMObject targetConstraints;
            int addedIndex = targetIndex + shiftIndex;
            if (this.position == GridPaneJobUtils.Position.AFTER) {
                ++addedIndex;
            }
            if ((targetConstraints = mask.getColumnConstraintsAtIndex(targetIndex)) != null) {
                assert (targetConstraints instanceof FXOMInstance);
                addedConstraints = this.makeColumnConstraintsInstance((FXOMInstance)targetConstraints);
                addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, addedIndex, this.getEditorController());
                result.add(addValueJob);
            } else {
                for (int index = constraintsSize; index < addedIndex; ++index) {
                    FXOMInstance addedConstraints2 = this.makeColumnConstraintsInstance();
                    AddPropertyValueJob addValueJob2 = new AddPropertyValueJob(addedConstraints2, (FXOMPropertyC)constraintsProperty, index, this.getEditorController());
                    result.add(addValueJob2);
                }
                addedConstraints = this.makeColumnConstraintsInstance();
                JobUtils.setMinWidth(addedConstraints, ColumnConstraints.class, 10.0);
                JobUtils.setPrefWidth(addedConstraints, ColumnConstraints.class, 100.0);
                addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, addedIndex, this.getEditorController());
                result.add(addValueJob);
                constraintsSize = addedIndex + 1;
            }
            ++shiftIndex;
        }
        if (constraintsProperty.getParentInstance() == null) {
            AddPropertyJob addPropertyJob = new AddPropertyJob(constraintsProperty, targetGridPane, -1, this.getEditorController());
            result.add(addPropertyJob);
        }
        return result;
    }

    private FXOMInstance makeColumnConstraintsInstance() {
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, ColumnConstraints.class);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }

    private FXOMInstance makeColumnConstraintsInstance(FXOMInstance constraints) {
        assert (constraints != null);
        assert (constraints.getDeclaredClass() == ColumnConstraints.class);
        FXOMInstance result = this.makeColumnConstraintsInstance();
        boolean fillWidth = JobUtils.getFillWidth(constraints, ColumnConstraints.class);
        double maxWidth = JobUtils.getMaxWidth(constraints, ColumnConstraints.class);
        double minWidth = JobUtils.getMinWidth(constraints, ColumnConstraints.class);
        double percentWidth = JobUtils.getPercentWidth(constraints, ColumnConstraints.class);
        double prefWidth = JobUtils.getPrefWidth(constraints, ColumnConstraints.class);
        String halignment = JobUtils.getHAlignment(constraints, ColumnConstraints.class);
        String hgrow = JobUtils.getHGrow(constraints, ColumnConstraints.class);
        JobUtils.setFillWidth(result, ColumnConstraints.class, fillWidth);
        JobUtils.setMaxWidth(result, ColumnConstraints.class, maxWidth);
        JobUtils.setMinWidth(result, ColumnConstraints.class, Math.max(minWidth, 10.0));
        JobUtils.setPercentWidth(result, ColumnConstraints.class, percentWidth);
        JobUtils.setPrefWidth(result, ColumnConstraints.class, Math.max(prefWidth, 100.0));
        JobUtils.setHAlignment(result, ColumnConstraints.class, halignment);
        JobUtils.setHGrow(result, ColumnConstraints.class, hgrow);
        return result;
    }
}

