/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.key;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;

public abstract class AbstractKeyGesture
extends AbstractGesture {
    private KeyEvent firstKeyPressedEvent;
    private KeyEvent lastKeyEvent;
    private AbstractGesture.Observer observer;

    public AbstractKeyGesture(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    protected abstract void keyPressed();

    protected abstract void keyReleased();

    protected KeyEvent getFirstKeyPressedEvent() {
        return this.firstKeyPressedEvent;
    }

    protected KeyEvent getLastKeyEvent() {
        return this.lastKeyEvent;
    }

    @Override
    public void start(InputEvent e, AbstractGesture.Observer observer) {
        assert (e != null);
        assert (e instanceof KeyEvent);
        assert (e.getEventType() == KeyEvent.KEY_PRESSED);
        assert (observer != null);
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        assert (glassLayer.getOnKeyPressed() == null);
        assert (glassLayer.getOnKeyReleased() == null);
        glassLayer.setOnKeyPressed(e1 -> {
            if (e1.getCode() == this.firstKeyPressedEvent.getCode()) {
                this.lastKeyEvent = e1;
                try {
                    this.keyPressed();
                }
                finally {
                    e1.consume();
                }
            }
        });
        glassLayer.setOnKeyReleased(e1 -> {
            if (e1.getCode() == this.firstKeyPressedEvent.getCode()) {
                this.lastKeyEvent = e1;
                try {
                    this.keyReleased();
                }
                finally {
                    this.performTermination();
                    e1.consume();
                }
            }
        });
        this.lastKeyEvent = this.firstKeyPressedEvent = (KeyEvent)e;
        this.observer = observer;
        try {
            this.keyPressed();
        }
        catch (RuntimeException x) {
            this.performTermination();
            throw x;
        }
    }

    private void performTermination() {
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        glassLayer.setOnKeyPressed(null);
        glassLayer.setOnKeyReleased(null);
        try {
            this.observer.gestureDidTerminate(this);
        }
        finally {
            this.observer = null;
            this.firstKeyPressedEvent = null;
            this.lastKeyEvent = null;
        }
    }
}

