/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;

public class EnumerationPropertyMetadata
extends ValuePropertyMetadata {
    public static final String EQUIV_NONE = "NONE";
    public static final String EQUIV_AUTOMATIC = "AUTOMATIC";
    public static final String EQUIV_INHERITED = "INHERIT";
    private final Class<?> enumClass;
    private final Enum<?> defaultValue;
    private final String nullEquivalent;

    public EnumerationPropertyMetadata(PropertyName name, Class<?> enumClass, boolean readWrite, Enum<?> defaultValue, InspectorPath inspectorPath) {
        super(name, readWrite, inspectorPath);
        assert (enumClass.isEnum());
        assert (!readWrite || defaultValue != null);
        this.enumClass = enumClass;
        this.defaultValue = defaultValue;
        this.nullEquivalent = null;
    }

    public EnumerationPropertyMetadata(PropertyName name, Class<?> enumClass, String nullEquivalent, boolean readWrite, InspectorPath inspectorPath) {
        super(name, readWrite, inspectorPath);
        assert (enumClass.isEnum());
        assert (nullEquivalent != null);
        this.enumClass = enumClass;
        this.defaultValue = null;
        this.nullEquivalent = nullEquivalent;
    }

    public String getValue(FXOMInstance fxomInstance) {
        String result;
        if (this.isReadWrite()) {
            FXOMProperty fxomProperty = fxomInstance.getProperties().get(this.getName());
            if (fxomProperty == null) {
                result = this.getDefaultValue();
            } else {
                assert (fxomProperty instanceof FXOMPropertyT);
                FXOMPropertyT fxomPropertyT = (FXOMPropertyT)fxomProperty;
                PrefixedValue pv = new PrefixedValue(fxomPropertyT.getValue());
                result = pv.isBindingExpression() ? this.getDefaultValue() : fxomPropertyT.getValue();
            }
        } else {
            Object o = this.getName().getValue(fxomInstance.getSceneGraphObject());
            if (o == null) {
                result = this.getDefaultValue();
            } else {
                assert (o.getClass() == this.enumClass);
                result = o.toString();
            }
        }
        return result;
    }

    public void setValue(FXOMInstance fxomInstance, String value) {
        assert (this.isReadWrite());
        assert (value != null);
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(this.getName());
        if (fxomProperty == null) {
            if (!value.equals(this.getDefaultValue())) {
                FXOMPropertyT newProperty = new FXOMPropertyT(fxomInstance.getFxomDocument(), this.getName(), value);
                newProperty.addToParentInstance(-1, fxomInstance);
            }
        } else {
            assert (fxomProperty instanceof FXOMPropertyT);
            FXOMPropertyT fxomPropertyT = (FXOMPropertyT)fxomProperty;
            if (value.equals(this.getDefaultValue())) {
                fxomPropertyT.removeFromParentInstance();
            } else {
                fxomPropertyT.setValue(value);
            }
        }
    }

    public String getDefaultValue() {
        String result;
        if (this.isReadWrite()) {
            assert (this.defaultValue == null == (this.nullEquivalent != null));
            result = this.defaultValue == null ? this.nullEquivalent : this.defaultValue.toString();
        } else {
            result = null;
        }
        return result;
    }

    public List<String> getValidValues() {
        ArrayList<String> result = new ArrayList<String>();
        for (Object e : this.enumClass.getEnumConstants()) {
            result.add(e.toString());
        }
        if (this.nullEquivalent != null) {
            assert (this.defaultValue == null);
            if (!result.contains(this.nullEquivalent)) {
                result.add(0, this.nullEquivalent);
            }
        }
        return result;
    }

    @Override
    public Class<?> getValueClass() {
        return this.enumClass;
    }

    @Override
    public Object getDefaultValueObject() {
        return this.getDefaultValue();
    }

    @Override
    public Object getValueObject(FXOMInstance fxomInstance) {
        return this.getValue(fxomInstance);
    }

    @Override
    public void setValueObject(FXOMInstance fxomInstance, Object valueObject) {
        assert (valueObject instanceof String);
        this.setValue(fxomInstance, (String)valueObject);
    }
}

