/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ArgumentAndDeclIndex;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.StackValueKt;
import org.jetbrains.kotlin.codegen.ValueKind;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.org.objectweb.asm.Type;

public class CallBasedArgumentGenerator
extends ArgumentGenerator {
    private final ExpressionCodegen codegen;
    private final CallGenerator callGenerator;
    private final List<ValueParameterDescriptor> valueParameters;
    private final List<Type> valueParameterTypes;
    private final boolean isVarargInvoke;

    public CallBasedArgumentGenerator(@NotNull ExpressionCodegen codegen, @NotNull CallGenerator callGenerator, @NotNull List<ValueParameterDescriptor> valueParameters2, @NotNull List<Type> valueParameterTypes) {
        this.codegen = codegen;
        this.callGenerator = callGenerator;
        this.valueParameters = valueParameters2;
        this.valueParameterTypes = valueParameterTypes;
        CallableDescriptor container2 = valueParameters2.isEmpty() ? null : valueParameters2.get(0).getContainingDeclaration();
        this.isVarargInvoke = JvmCodegenUtil.isDeclarationOfBigArityFunctionInvoke(container2);
        if (!this.isVarargInvoke) assert (valueParameters2.size() == valueParameterTypes.size()) : "Value parameters and their types mismatch in sizes: " + valueParameters2.size() + " != " + valueParameterTypes.size();
    }

    @Override
    protected void generateExpression(int i2, @NotNull ExpressionValueArgument argument2) {
        ValueParameterDescriptor parameter = this.valueParameters.get(i2);
        ValueArgument valueArgument = argument2.getValueArgument();
        assert (valueArgument != null);
        KtExpression argumentExpression2 = valueArgument.getArgumentExpression();
        assert (argumentExpression2 != null) : valueArgument.asElement().getText();
        this.callGenerator.genValueAndPut(parameter, argumentExpression2, this.isVarargInvoke ? AsmTypes.OBJECT_TYPE : this.valueParameterTypes.get(i2), i2);
    }

    @Override
    protected void generateDefault(int i2, @NotNull DefaultValueArgument argument2) {
        this.callGenerator.putValueIfNeeded(CallBasedArgumentGenerator.getJvmKotlinType(this.valueParameterTypes, this.valueParameters, i2), StackValue.createDefaultValue(this.valueParameterTypes.get(i2)), ValueKind.DEFAULT_PARAMETER, i2);
    }

    @Override
    protected void generateVararg(int i2, @NotNull VarargValueArgument argument2) {
        ValueParameterDescriptor parameter = this.valueParameters.get(i2);
        StackValue lazyVararg = this.codegen.genVarargs(argument2, FlexibleTypesKt.upperIfFlexible(parameter.getType()));
        this.callGenerator.putValueIfNeeded(CallBasedArgumentGenerator.getJvmKotlinType(this.valueParameterTypes, this.valueParameters, i2), lazyVararg, ValueKind.GENERAL_VARARG, i2);
    }

    @Override
    protected void generateDefaultJava(int i2, @NotNull DefaultValueArgument argument2) {
        StackValue argumentValue = StackValueKt.findJavaDefaultArgumentValue(this.valueParameters.get(i2), this.valueParameterTypes.get(i2), this.codegen.typeMapper);
        this.callGenerator.putValueIfNeeded(CallBasedArgumentGenerator.getJvmKotlinType(this.valueParameterTypes, this.valueParameters, i2), argumentValue);
    }

    @Override
    protected void reorderArgumentsIfNeeded(@NotNull List<ArgumentAndDeclIndex> actualArgsWithDeclIndex) {
        this.callGenerator.reorderArgumentsIfNeeded(actualArgsWithDeclIndex, this.valueParameterTypes);
    }

    @NotNull
    private static JvmKotlinType getJvmKotlinType(@NotNull List<Type> valueParameterTypes, @NotNull List<ValueParameterDescriptor> valueParameters2, int i2) {
        return new JvmKotlinType(valueParameterTypes.get(i2), valueParameters2.get(i2).getOriginal().getType());
    }
}

