/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public abstract class TransformationMethodVisitor
extends MethodVisitor {
    private final MethodNode methodNode;
    private final MethodVisitor delegate;

    public TransformationMethodVisitor(@NotNull MethodVisitor delegate, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        super(327680);
        this.delegate = delegate;
        this.methodNode = new MethodNode(access, name2, desc, signature, exceptions);
        this.methodNode.localVariables = new ArrayList(5);
        this.mv = InlineCodegenUtilsKt.wrapWithMaxLocalCalc(this.methodNode);
    }

    public void visitEnd() {
        if (this.methodNode.maxLocals <= 0 || this.methodNode.maxStack <= 0) {
            this.mv.visitMaxs(-1, -1);
        }
        super.visitEnd();
        try {
            if (TransformationMethodVisitor.shouldBeTransformed(this.methodNode)) {
                this.performTransformations(this.methodNode);
            }
            this.methodNode.accept((MethodVisitor)new EndIgnoringMethodVisitorDecorator(327680, this.delegate));
            if (!(this.methodNode.instructions.size() != 0 || this.delegate instanceof MethodNode && this.methodNode.localVariables == null)) {
                List localVariables = this.methodNode.localVariables;
                int n = localVariables == null ? 0 : localVariables.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    ((LocalVariableNode)localVariables.get(i2)).accept(this.delegate);
                }
            }
            this.delegate.visitEnd();
        }
        catch (Throwable t) {
            throw new CompilationException("Couldn't transform method node:\n" + InlineCodegenUtilsKt.getNodeText(this.methodNode), t, null);
        }
    }

    protected abstract void performTransformations(@NotNull MethodNode var1);

    @Nullable
    public TraceMethodVisitor getTraceMethodVisitorIfPossible() {
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor((Printer)new Textifier());
        try {
            this.methodNode.accept((MethodVisitor)traceMethodVisitor);
        }
        catch (Throwable e) {
            return null;
        }
        return traceMethodVisitor;
    }

    private static boolean shouldBeTransformed(@NotNull MethodNode node) {
        return node.instructions.size() > 0;
    }

    private static class EndIgnoringMethodVisitorDecorator
    extends MethodVisitor {
        public EndIgnoringMethodVisitorDecorator(int api, @NotNull MethodVisitor mv) {
            super(api, mv);
        }

        public void visitEnd() {
        }
    }
}

