/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class KotlinPluginUtil {
    public static final PluginId KOTLIN_PLUGIN_ID;

    @NotNull
    public static String getPluginVersion() {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin((PluginId)KOTLIN_PLUGIN_ID);
        assert (plugin != null) : "Kotlin plugin not found: " + Arrays.toString(PluginManagerCore.getPlugins());
        return plugin.getVersion();
    }

    public static boolean isSnapshotVersion() {
        return "@snapshot@".equals(KotlinPluginUtil.getPluginVersion());
    }

    public static boolean isDevVersion() {
        return KotlinPluginUtil.getPluginVersion().contains("-dev-");
    }

    static {
        PluginId pluginId = PluginManagerCore.getPluginByClassName((String)KotlinPluginUtil.class.getName());
        if (pluginId == null) {
            pluginId = PluginId.getId((String)"org.jetbrains.kotlin");
        }
        KOTLIN_PLUGIN_ID = pluginId;
    }
}

