/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.frontend.di.InjectionKt;
import org.jetbrains.kotlin.idea.caches.resolve.CodeFragmentAnalyzer;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.BodyResolveCache;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017R\"\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/KotlinResolveDataProvider;", "", "()V", "topmostElementTypes", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "[Ljava/lang/Class;", "analyze", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lcom/intellij/openapi/project/Project;", "globalContext", "Lorg/jetbrains/kotlin/context/GlobalContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "codeFragmentAnalyzer", "Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer;", "bodyResolveCache", "Lorg/jetbrains/kotlin/resolve/BodyResolveCache;", "analyzableElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "analyzeExpressionCodeFragment", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "findAnalyzableParent", "element", "idea-core"})
final class KotlinResolveDataProvider {
    private static final Class<? extends PsiElement>[] topmostElementTypes;
    public static final KotlinResolveDataProvider INSTANCE;

    @NotNull
    public final KtElement findAnalyzableParent(@NotNull KtElement element3) {
        KtElement ktElement;
        KtElement analyzableElement;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3 instanceof KtFile) {
            return element3;
        }
        KtElement topmostElement = (KtElement)KtPsiUtil.getTopmostParentOfTypes((PsiElement)element3, Arrays.copyOf(topmostElementTypes, topmostElementTypes.length));
        KtElement ktElement2 = topmostElement;
        KtElement ktElement3 = analyzableElement = ktElement2 instanceof KtAnnotationEntry || ktElement2 instanceof KtTypeConstraint || ktElement2 instanceof KtSuperTypeList || ktElement2 instanceof KtTypeParameter || ktElement2 instanceof KtParameter ? (KtElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)topmostElement), (Class[])new Class[]{KtClassOrObject.class, KtCallableDeclaration.class}) : topmostElement;
        if (analyzableElement instanceof KtPrimaryConstructor) {
            return ((KtPrimaryConstructor)analyzableElement).getContainingClassOrObject();
        }
        if (analyzableElement instanceof KtClassInitializer) {
            return ((KtClassInitializer)analyzableElement).getContainingDeclaration();
        }
        KtElement ktElement4 = analyzableElement;
        if (ktElement4 == null) {
            ktElement4 = ktElement = (KtElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)((PsiElement)element3), KtDeclaration.class);
        }
        if (ktElement4 == null) {
            KtFile ktFile = element3.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"element.containingKtFile");
            ktElement = ktFile;
        }
        return ktElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnalysisResult analyze(@NotNull Project project, @NotNull GlobalContext globalContext, @NotNull ModuleDescriptor moduleDescriptor, @NotNull ResolveSession resolveSession, @NotNull CodeFragmentAnalyzer codeFragmentAnalyzer, @NotNull BodyResolveCache bodyResolveCache, @NotNull KtElement analyzableElement) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)globalContext, (String)"globalContext");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)resolveSession, (String)"resolveSession");
        Intrinsics.checkParameterIsNotNull((Object)codeFragmentAnalyzer, (String)"codeFragmentAnalyzer");
        Intrinsics.checkParameterIsNotNull((Object)bodyResolveCache, (String)"bodyResolveCache");
        Intrinsics.checkParameterIsNotNull((Object)analyzableElement, (String)"analyzableElement");
        try {
            void $receiver$iv;
            if (analyzableElement instanceof KtCodeFragment) {
                return AnalysisResult.Companion.success(this.analyzeExpressionCodeFragment(codeFragmentAnalyzer, (KtCodeFragment)analyzableElement), moduleDescriptor);
            }
            BindingContext bindingContext2 = resolveSession.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"resolveSession.bindingContext");
            DelegatingBindingTrace trace = new DelegatingBindingTrace(bindingContext2, "Trace for resolution of " + analyzableElement, false, null, true, 12, null);
            TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform(analyzableElement.getContainingKtFile());
            Intrinsics.checkExpressionValueIsNotNull((Object)targetPlatform, (String)"TargetPlatformDetector.g\u2026Element.containingKtFile)");
            TargetPlatform targetPlatform2 = targetPlatform;
            ComponentProvider componentProvider = InjectionKt.createContainerForLazyBodyResolve(ContextKt.withModule(ContextKt.withProject(globalContext, project), moduleDescriptor), resolveSession, trace, targetPlatform2, bodyResolveCache, PlatformKt.getJvmTarget(analyzableElement), PlatformKt.getLanguageVersionSettings(analyzableElement));
            LazyTopDownAnalyzer lazyTopDownAnalyzer = DslKt.getService((ComponentProvider)$receiver$iv, LazyTopDownAnalyzer.class);
            LazyTopDownAnalyzer.analyzeDeclarations$default(lazyTopDownAnalyzer, TopDownAnalysisMode.TopLevelDeclarations, CollectionsKt.listOf((Object)analyzableElement), null, 4, null);
            return AnalysisResult.Companion.success(trace.getBindingContext(), moduleDescriptor);
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (IndexNotReadyException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            DiagnosticUtils.throwIfRunningOnServer(e);
            KotlinCacheServiceImplKt.getLOG().error(e);
            BindingContext bindingContext3 = BindingContext.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext3, (String)"BindingContext.EMPTY");
            return AnalysisResult.Companion.internalError(bindingContext3, e);
        }
    }

    private final BindingContext analyzeExpressionCodeFragment(CodeFragmentAnalyzer codeFragmentAnalyzer, KtCodeFragment codeFragment) {
        BindingTraceContext trace = new BindingTraceContext();
        codeFragmentAnalyzer.analyzeCodeFragment(codeFragment, trace, BodyResolveMode.PARTIAL_FOR_COMPLETION);
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        return bindingContext2;
    }

    private KotlinResolveDataProvider() {
    }

    static {
        KotlinResolveDataProvider kotlinResolveDataProvider;
        INSTANCE = kotlinResolveDataProvider = new KotlinResolveDataProvider();
        topmostElementTypes = new Class[]{KtNamedFunction.class, KtAnonymousInitializer.class, KtProperty.class, KtImportDirective.class, KtPackageDirective.class, KtCodeFragment.class, KtAnnotationEntry.class, KtTypeConstraint.class, KtSuperTypeList.class, KtTypeParameter.class, KtParameter.class, KtTypeAlias.class};
    }
}

