/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KotlinCompletionCharFilter;", "Lcom/intellij/codeInsight/lookup/CharFilter;", "()V", "acceptChar", "Lcom/intellij/codeInsight/lookup/CharFilter$Result;", "c", "", "prefixLength", "", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "Companion", "idea"})
public final class KotlinCompletionCharFilter
extends CharFilter {
    @NotNull
    private static final Key<Unit> ACCEPT_OPENING_BRACE;
    @NotNull
    private static final Key<Unit> SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING;
    @NotNull
    private static final Key<Unit> HIDE_LOOKUP_ON_COLON;
    @NotNull
    private static final Key<String> JUST_TYPING_PREFIX;
    public static final Companion Companion;

    @Nullable
    public CharFilter.Result acceptChar(char c, int prefixLength, @NotNull Lookup lookup) {
        CharFilter.Result result2;
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        if (!(lookup.getPsiFile() instanceof KtFile)) {
            return null;
        }
        if (!lookup.isCompletion()) {
            return null;
        }
        CompletionService completionService = CompletionService.getCompletionService();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionService, (String)"CompletionService.getCompletionService()");
        CompletionProcess completionProcess = completionService.getCurrentCompletion();
        if (completionProcess == null) {
            return null;
        }
        boolean isAutopopup = completionProcess.isAutopopupCompletion();
        if (Character.isJavaIdentifierPart(c) || c == '@') {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        LookupElement currentItem = lookup.getCurrentItem();
        if (isAutopopup && !lookup.isSelectionTouched()) {
            LookupElement lookupElement2 = currentItem;
            if ((lookupElement2 != null ? (Unit)lookupElement2.getUserData(SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING) : null) != null) {
                return CharFilter.Result.HIDE_LOOKUP;
            }
        }
        if (c == ':') {
            LookupElement lookupElement3 = currentItem;
            return (lookupElement3 != null ? (Unit)lookupElement3.getUserData(HIDE_LOOKUP_ON_COLON) : null) != null ? CharFilter.Result.HIDE_LOOKUP : CharFilter.Result.ADD_TO_PREFIX;
        }
        if (!lookup.isSelectionTouched()) {
            LookupElement lookupElement4 = currentItem;
            if (lookupElement4 != null) {
                CompletionUtilsKt.putUserDataDeep(lookupElement4, JUST_TYPING_PREFIX, lookup.itemPattern(currentItem));
            }
        }
        switch (c) {
            case '.': {
                if (prefixLength == 0 && isAutopopup && !lookup.isSelectionTouched()) {
                    Editor editor = lookup.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"lookup.editor");
                    CaretModel caretModel = editor.getCaretModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"lookup.editor.caretModel");
                    int caret = caretModel.getOffset();
                    if (caret > 0) {
                        Editor editor2 = lookup.getEditor();
                        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"lookup.editor");
                        Document document = editor2.getDocument();
                        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"lookup.editor.document");
                        if (document.getCharsSequence().charAt(caret - 1) == '.') {
                            return CharFilter.Result.HIDE_LOOKUP;
                        }
                    }
                }
                result2 = CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                break;
            }
            case '{': {
                LookupElement lookupElement5 = currentItem;
                if ((lookupElement5 != null ? (Unit)lookupElement5.getUserData(ACCEPT_OPENING_BRACE) : null) != null) {
                    result2 = CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                    break;
                }
                result2 = CharFilter.Result.HIDE_LOOKUP;
                break;
            }
            case ' ': 
            case '!': 
            case '(': 
            case ',': 
            case '=': {
                result2 = CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                break;
            }
            default: {
                result2 = CharFilter.Result.HIDE_LOOKUP;
            }
        }
        return result2;
    }

    static {
        Companion = new Companion(null);
        ACCEPT_OPENING_BRACE = new Key("KotlinCompletionCharFilter.ACCEPT_OPENING_BRACE");
        SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING = new Key("KotlinCompletionCharFilter.SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING");
        HIDE_LOOKUP_ON_COLON = new Key("KotlinCompletionCharFilter.HIDE_LOOKUP_ON_COLON");
        JUST_TYPING_PREFIX = new Key("KotlinCompletionCharFilter.JUST_TYPING_PREFIX");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KotlinCompletionCharFilter$Companion;", "", "()V", "ACCEPT_OPENING_BRACE", "Lcom/intellij/openapi/util/Key;", "", "getACCEPT_OPENING_BRACE", "()Lcom/intellij/openapi/util/Key;", "HIDE_LOOKUP_ON_COLON", "getHIDE_LOOKUP_ON_COLON", "JUST_TYPING_PREFIX", "", "getJUST_TYPING_PREFIX", "SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING", "getSUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING", "idea"})
    public static final class Companion {
        @NotNull
        public final Key<Unit> getACCEPT_OPENING_BRACE() {
            return ACCEPT_OPENING_BRACE;
        }

        @NotNull
        public final Key<Unit> getSUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING() {
            return SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING;
        }

        @NotNull
        public final Key<Unit> getHIDE_LOOKUP_ON_COLON() {
            return HIDE_LOOKUP_ON_COLON;
        }

        @NotNull
        public final Key<String> getJUST_TYPING_PREFIX() {
            return JUST_TYPING_PREFIX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

