/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.kotlin.idea.framework.CommonLibraryKind;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00192\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006H\u0016J6\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleLibraryDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "resetLibraryKind", "modifiableModel", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx$ModifiableModelEx;", "looksAsNonJvmLibraryName", "", "", "Companion", "idea-gradle"})
public final class KotlinGradleLibraryDataService
extends AbstractProjectDataService<LibraryData, Void> {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> nonJvmSuffixes;
    public static final Companion Companion;

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"ProjectKeys.LIBRARY");
        return key;
    }

    public void postProcess(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        IdePlatformKind<?> idePlatformKind;
        IdePlatformKind<?> it;
        boolean bl;
        block11: {
            Iterable $receiver$iv2;
            Intrinsics.checkParameterIsNotNull(toImport, (String)"toImport");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
            if (toImport.isEmpty()) {
                return;
            }
            DataNode dataNode = ((DataNode)CollectionsKt.first((Iterable)toImport)).getParent();
            if (dataNode == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)dataNode, (String)"toImport.first().parent!!");
            DataNode projectDataNode = dataNode;
            Collection collection = projectDataNode.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"projectDataNode.children");
            Iterable iterable = $receiver$iv2 = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : iterable) {
                DataNode it2;
                DataNode dataNode2 = it2 = (DataNode)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode2, (String)"it");
                if (!(dataNode2.getData() instanceof ModuleData)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List moduleDataNodes = (List)destination$iv$iv;
            Iterable iterable2 = moduleDataNodes;
            if (iterable2 instanceof Collection && ((Collection)iterable2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable2) {
                    DataNode node = (DataNode)element$iv;
                    Object object = KotlinGradleSourceSetDataServiceKt.detectPlatformKindByPlugin((DataNode<ModuleData>)node) != null ? (!JvmIdePlatformUtil.isJvm(it = idePlatformKind) ? idePlatformKind : null) : null;
                    if (!(object != null)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        boolean anyNonJvmModules = bl;
        for (DataNode dataNode : toImport) {
            LibraryEx.ModifiableModelEx modifiableModel;
            Library ideLibrary;
            block13: {
                block12: {
                    if (modelsProvider.findIdeLibrary((LibraryData)dataNode.getData()) == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ideLibrary, (String)"modelsProvider.findIdeLi\u2026ataNode.data) ?: continue");
                    Library.ModifiableModel modifiableModel2 = modelsProvider.getModifiableLibraryModel(ideLibrary);
                    if (modifiableModel2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx.ModifiableModelEx");
                    }
                    modifiableModel = (LibraryEx.ModifiableModelEx)modifiableModel2;
                    if (anyNonJvmModules) break block12;
                    String string = ideLibrary.getName();
                    if (string == null) break block13;
                    if (!this.looksAsNonJvmLibraryName(string)) break block13;
                }
                VirtualFile[] virtualFileArray = modifiableModel.getFiles(OrderRootType.CLASSES);
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"modifiableModel.getFiles(OrderRootType.CLASSES)");
                if (LibraryKindsKt.detectLibraryKind(virtualFileArray) == null) continue;
                it = idePlatformKind;
                modifiableModel.setKind(it);
                continue;
            }
            if (!(ideLibrary instanceof LibraryImpl) || ((LibraryImpl)ideLibrary).getKind() != JSLibraryKind.INSTANCE && ((LibraryImpl)ideLibrary).getKind() != CommonLibraryKind.INSTANCE) continue;
            this.resetLibraryKind(modifiableModel);
        }
    }

    private final boolean looksAsNonJvmLibraryName(@NotNull String $receiver) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = nonJvmSuffixes;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!StringsKt.contains$default((CharSequence)$receiver, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void resetLibraryKind(LibraryEx.ModifiableModelEx modifiableModel) {
        try {
            Class<LibraryImpl> cls = LibraryImpl.class;
            Field[] fieldArray = cls.getDeclaredFields();
            int n = fieldArray.length;
            for (int j = 0; j < n; ++j) {
                Field field2;
                Field field3 = field2 = fieldArray[j];
                Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"field");
                if (!Intrinsics.areEqual(field3.getType(), PersistentLibraryKind.class)) continue;
                field2.setAccessible(true);
                field2.set(modifiableModel, null);
                return;
            }
            LOG.info("Could not find field of type PersistentLibraryKind in LibraryImpl.class");
        }
        catch (Exception e) {
            LOG.info("Failed to reset library kind", (Throwable)e);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinGradleLibraryDataService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Kotli\u2026yDataService::class.java)");
        LOG = logger;
        nonJvmSuffixes = CollectionsKt.listOf((Object[])new String[]{"-common", "-js", "-native", "-kjsm"});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleLibraryDataService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "nonJvmSuffixes", "", "", "getNonJvmSuffixes", "()Ljava/util/List;", "idea-gradle"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final List<String> getNonJvmSuffixes() {
            return nonJvmSuffixes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

