/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedWriter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleAbstractMultiplatformModuleBuilder;
import org.jetbrains.kotlin.konan.target.KonanTargetKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\u0004H\u0016J\b\u0010%\u001a\u00020\u0004H\u0016J\b\u0010&\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R\u0014\u0010\u0019\u001a\u00020\u001aX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleSharedMultiplatformModuleBuilder;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleAbstractMultiplatformModuleBuilder;", "()V", "commonName", "", "commonSourceName", "getCommonSourceName", "()Ljava/lang/String;", "commonTestName", "getCommonTestName", "jsSourceName", "getJsSourceName", "jsTargetName", "jsTestName", "getJsTestName", "jvmSourceName", "getJvmSourceName", "jvmTargetName", "jvmTestName", "getJvmTestName", "nativeSourceName", "getNativeSourceName", "nativeTargetName", "nativeTestName", "getNativeTestName", "shouldEnableGradleMetadataPreview", "", "getShouldEnableGradleMetadataPreview", "()Z", "buildMultiPlatformPart", "createProjectSkeleton", "", "module", "Lcom/intellij/openapi/module/Module;", "rootDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBuilderId", "getDescription", "getPresentableName", "idea-gradle"})
public final class KotlinGradleSharedMultiplatformModuleBuilder
extends KotlinGradleAbstractMultiplatformModuleBuilder {
    private final String commonName = "common";
    private String jvmTargetName = "jvm";
    private String jsTargetName = "js";
    private String nativeTargetName = this.getUserTargetName(this.getDefaultNativeTarget());
    private final boolean shouldEnableGradleMetadataPreview = true;

    private final String getCommonSourceName() {
        return this.commonName + "Main";
    }

    private final String getCommonTestName() {
        return this.commonName + "Test";
    }

    private final String getJvmSourceName() {
        return this.jvmTargetName + "Main";
    }

    private final String getJvmTestName() {
        return this.jvmTargetName + "Test";
    }

    private final String getJsSourceName() {
        return this.jsTargetName + "Main";
    }

    private final String getJsTestName() {
        return this.jsTargetName + "Test";
    }

    private final String getNativeSourceName() {
        return this.nativeTargetName + "Main";
    }

    private final String getNativeTestName() {
        return this.nativeTargetName + "Test";
    }

    @Override
    protected boolean getShouldEnableGradleMetadataPreview() {
        return this.shouldEnableGradleMetadataPreview;
    }

    @NotNull
    public String getBuilderId() {
        return "kotlin.gradle.multiplatform.shared";
    }

    @NotNull
    public String getPresentableName() {
        return "Kotlin (Multiplatform Library)";
    }

    @NotNull
    public String getDescription() {
        return "Multiplatform Gradle projects allow sharing the same Kotlin code between all three main platforms (JVM, JS, Native).";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createProjectSkeleton(@NotNull Module module, @NotNull VirtualFile rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        VirtualFile virtualFile = rootDir.createChildDirectory((Object)this, "src");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"rootDir.createChildDirectory(this, \"src\")");
        VirtualFile src = virtualFile;
        BufferedWriter commonMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonSourceName(), null, null, null, 14, null);
        BufferedWriter commonTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonTestName(), null, null, "SampleTests.kt", 6, null);
        BufferedWriter jvmMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJvmSourceName(), this.jvmTargetName, null, null, 12, null);
        BufferedWriter jvmTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJvmTestName(), null, null, "SampleTestsJVM.kt", 6, null);
        BufferedWriter jsMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJsSourceName(), this.jsTargetName, null, null, 12, null);
        BufferedWriter jsTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJsTestName(), null, null, "SampleTestsJS.kt", 6, null);
        BufferedWriter nativeMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getNativeSourceName(), this.nativeTargetName, null, null, 12, null);
        BufferedWriter nativeTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getNativeTestName(), null, null, "SampleTestsNative.kt", 6, null);
        try {
            commonMain.write(StringsKt.trimIndent((String)"\n                package sample\n\n                expect class Sample() {\n                    fun checkMe(): Int\n                }\n\n                expect object Platform {\n                    val name: String\n                }\n\n                fun hello(): String = \"Hello from ${Platform.name}\"\n            "));
            jvmMain.write(StringsKt.trimIndent((String)"\n                package sample\n\n                actual class Sample {\n                    actual fun checkMe() = 42\n                }\n\n                actual object Platform {\n                    actual val name: String = \"JVM\"\n                }\n            "));
            jsMain.write(StringsKt.trimIndent((String)"\n                package sample\n\n                actual class Sample {\n                    actual fun checkMe() = 12\n                }\n\n                actual object Platform {\n                    actual val name: String = \"JS\"\n                }\n            "));
            nativeMain.write(StringsKt.trimIndent((String)"\n                package sample\n\n                actual class Sample {\n                    actual fun checkMe() = 7\n                }\n\n                actual object Platform {\n                    actual val name: String = \"Native\"\n                }\n            "));
            commonTest.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import kotlin.test.Test\n                import kotlin.test.assertTrue\n\n                class SampleTests {\n                    @Test\n                    fun testMe() {\n                        assertTrue(Sample().checkMe() > 0)\n                    }\n                }\n            "));
            jvmTest.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import kotlin.test.Test\n                import kotlin.test.assertTrue\n\n                class SampleTestsJVM {\n                    @Test\n                    fun testHello() {\n                        assertTrue(\"JVM\" in hello())\n                    }\n                }\n            "));
            jsTest.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import kotlin.test.Test\n                import kotlin.test.assertTrue\n\n                class SampleTestsJS {\n                    @Test\n                    fun testHello() {\n                        assertTrue(\"JS\" in hello())\n                    }\n                }\n            "));
            nativeTest.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import kotlin.test.Test\n                import kotlin.test.assertTrue\n\n                class SampleTestsNative {\n                    @Test\n                    fun testHello() {\n                        assertTrue(\"Native\" in hello())\n                    }\n                }\n            "));
        }
        catch (Throwable throwable) {
            Iterable $receiver$iv = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, jvmMain, jvmTest, jsMain, jsTest, nativeMain, nativeTest});
            for (Object element$iv : $receiver$iv) {
                BufferedWriter p1 = (BufferedWriter)element$iv;
                p1.close();
            }
            throw throwable;
        }
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, jvmMain, jvmTest, jsMain, jsTest, nativeMain, nativeTest});
        for (Object element$iv : $receiver$iv) {
            BufferedWriter p1 = (BufferedWriter)element$iv;
            p1.close();
        }
    }

    @Override
    @NotNull
    protected String buildMultiPlatformPart() {
        return StringsKt.trimIndent((String)("\n            group 'com.example'\n            version '0.0.1'\n\n            apply plugin: 'maven-publish'\n\n            kotlin {\n                targets {\n                    fromPreset(presets.jvm, '" + this.jvmTargetName + "')\n                    fromPreset(presets.js, '" + this.jsTargetName + "')\n                    // For ARM, preset should be changed to presets.iosArm32 or presets.iosArm64\n                    // For Linux, preset should be changed to e.g. presets.linuxX64\n                    // For MacOS, preset should be changed to e.g. presets.macosX64\n                    fromPreset(presets." + KonanTargetKt.getPresetName(this.getDefaultNativeTarget()) + ", '" + this.getUserTargetName(this.getDefaultNativeTarget()) + "')\n                }\n                sourceSets {\n                    " + this.getCommonSourceName() + " {\n                        dependencies {\n                            implementation 'org.jetbrains.kotlin:kotlin-stdlib-common'\n                        }\n                    }\n                    " + this.getCommonTestName() + " {\n                        dependencies {\n                            implementation 'org.jetbrains.kotlin:kotlin-test-common'\n                            implementation 'org.jetbrains.kotlin:kotlin-test-annotations-common'\n                        }\n                    }\n                    " + this.getJvmSourceName() + " {\n                        dependencies {\n                            implementation 'org.jetbrains.kotlin:kotlin-stdlib-jdk8'\n                        }\n                    }\n                    " + this.getJvmTestName() + " {\n                        dependencies {\n                            implementation 'org.jetbrains.kotlin:kotlin-test'\n                            implementation 'org.jetbrains.kotlin:kotlin-test-junit'\n                        }\n                    }\n                    " + this.getJsSourceName() + " {\n                        dependencies {\n                            implementation 'org.jetbrains.kotlin:kotlin-stdlib-js'\n                        }\n                    }\n                    " + this.getJsTestName() + " {\n                        dependencies {\n                            implementation 'org.jetbrains.kotlin:kotlin-test-js'\n                        }\n                    }\n                    " + this.getNativeSourceName() + " {\n                    }\n                    " + this.getNativeTestName() + " {\n                    }\n                }\n            }\n        "));
    }

    public KotlinGradleSharedMultiplatformModuleBuilder() {
        super(false, 1, null);
    }
}

